/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.availability;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;

public class AvailabilityCollectorThreadPool
implements Executor {
    private static final Log log = LogFactory.getLog(AvailabilityCollectorThreadPool.class);
    private ExecutorService threadPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        AvailabilityCollectorThreadPool availabilityCollectorThreadPool = this;
        synchronized (availabilityCollectorThreadPool) {
            if (this.threadPool == null) {
                log.debug((Object)"Initializing AvailabilityCollector thread pool");
                LoggingThreadFactory daemonFactory = new LoggingThreadFactory("AvailabilityCollector", true);
                this.threadPool = Executors.newCachedThreadPool(daemonFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AvailabilityCollectorThreadPool availabilityCollectorThreadPool = this;
        synchronized (availabilityCollectorThreadPool) {
            if (this.threadPool != null) {
                log.debug((Object)"Shutting down AvailabilityCollector thread pool...");
                PluginContainer pluginContainer = PluginContainer.getInstance();
                pluginContainer.shutdownExecutorService(this.threadPool, true);
                this.threadPool = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        if (runnable instanceof AvailabilityCollectorRunnable) {
            AvailabilityCollectorThreadPool availabilityCollectorThreadPool = this;
            synchronized (availabilityCollectorThreadPool) {
                if (this.threadPool != null) {
                    this.threadPool.execute(runnable);
                }
            }
            return;
        }
        if (runnable == null) {
            throw new NullPointerException("runnable == null");
        }
        throw new IllegalArgumentException("Runnable is of type [" + runnable.getClass() + "]; must be of type [" + AvailabilityCollectorRunnable.class + "]");
    }
}

