/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.availability;

import java.util.concurrent.Executor;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityContext;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;

public class AvailabilityContextImpl
implements AvailabilityContext {
    private final Resource resource;
    private final Executor availCollectionThreadPool;

    public AvailabilityContextImpl(Resource resource, Executor availCollectionThreadPool) {
        this.resource = resource;
        this.availCollectionThreadPool = availCollectionThreadPool;
    }

    public AvailabilityCollectorRunnable createAvailabilityCollectorRunnable(AvailabilityFacet availChecker, long interval) {
        return new AvailabilityCollectorRunnable(availChecker, interval, Thread.currentThread().getContextClassLoader(), this.availCollectionThreadPool);
    }

    public void requestAvailabilityCheck() {
        PluginContainer.getInstance().getInventoryManager().requestAvailabilityCheck(this.resource);
    }

    public AvailabilityType getLastReportedAvailability() {
        Availability avail = PluginContainer.getInstance().getInventoryManager().getAvailabilityIfKnown(this.resource);
        return null != avail ? avail.getAvailabilityType() : null;
    }

    public void disable() {
        PluginContainer.getInstance().getInventoryManager().setResourceEnablement(this.resource.getId(), false);
    }

    public void enable() {
        PluginContainer.getInstance().getInventoryManager().setResourceEnablement(this.resource.getId(), true);
    }

    public Resource getResource() {
        return this.resource;
    }
}

