/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.bundle;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.bundle.BundlePurgeResponse;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleRequest;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleResponse;
import org.rhq.core.clientapi.server.bundle.BundleServerService;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.pluginapi.bundle.BundlePurgeRequest;
import org.rhq.core.pluginapi.bundle.BundlePurgeResult;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;

public class BundleManager
extends AgentService
implements BundleAgentService,
BundleManagerProvider,
ContainerService {
    private final Log log = LogFactory.getLog(BundleManager.class);
    private final String AUDIT_DEPLOYMENT_ENDED = "Deployment Ended";
    private final String AUDIT_DEPLOYMENT_STARTED = "Deployment Started";
    private final String AUDIT_DEPLOYMENT_SCHEDULED = "Deployment Scheduled";
    private final String AUDIT_FILE_DOWNLOAD_ENDED = "File Download Started";
    private final String AUDIT_FILE_DOWNLOAD_STARTED = "File Download Started";
    private final String AUDIT_PURGE_STARTED = "Purge Started";
    private final String AUDIT_PURGE_ENDED = "Purge Ended";
    private PluginContainerConfiguration configuration;
    private ExecutorService deployerThreadPool;

    public BundleManager() {
        super(BundleAgentService.class);
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void initialize() {
        this.createDeployerThreadPool();
    }

    @Override
    public void shutdown() {
        this.shutdownDeployerThreadPool();
    }

    private void createDeployerThreadPool() {
        this.shutdownDeployerThreadPool();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory("BundleDeployment", true);
        this.deployerThreadPool = Executors.newSingleThreadExecutor(threadFactory);
    }

    private void shutdownDeployerThreadPool() {
        if (this.deployerThreadPool != null) {
            PluginContainer pluginContainer = PluginContainer.getInstance();
            pluginContainer.shutdownExecutorService(this.deployerThreadPool, false);
            this.deployerThreadPool = null;
        }
    }

    public List<PackageVersion> getAllBundleVersionPackageVersions(BundleVersion bundleVersion) throws Exception {
        int bvId = bundleVersion.getId();
        List pvs = this.getBundleServerService().getAllBundleVersionPackageVersions(bvId);
        return pvs;
    }

    public long getFileContent(PackageVersion packageVersion, OutputStream outputStream) throws Exception {
        outputStream = this.remoteOutputStream(outputStream);
        long size = this.getBundleServerService().downloadPackageBits(packageVersion, outputStream);
        return size;
    }

    public BundleScheduleResponse schedule(final BundleScheduleRequest request) {
        BundleScheduleResponse response = new BundleScheduleResponse();
        try {
            final BundleResourceDeployment resourceDeployment = request.getBundleResourceDeployment();
            final BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            InventoryManager im = this.getInventoryManager();
            BundleType bundleType = bundleDeployment.getBundleVersion().getBundle().getBundleType();
            ResourceType resourceType = bundleType.getResourceType();
            Set<Resource> resources = im.getResourcesWithType(resourceType);
            if (resources.isEmpty()) {
                throw new Exception("No bundle plugin supports bundle type [" + bundleType + "]");
            }
            final int bundleHandlerResourceId = resources.iterator().next().getId();
            final ResourceContainer resourceContainer = im.getResourceContainer(bundleHandlerResourceId);
            if (null == resourceContainer.getResourceContext()) {
                throw new Exception("No bundle plugin resource available to handle deployment for bundle type [" + bundleType + "]. Ensure the bundle plugin is deployed and its resource is imported into inventory.");
            }
            this.auditDeployment(resourceDeployment, "Deployment Scheduled", bundleDeployment.getName(), "Scheduled deployment time: " + request.getRequestedDeployTimeAsString());
            Runnable deployerRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        File pluginTmpDir = resourceContainer.getResourceContext().getTemporaryDirectory();
                        File bundleFilesDir = new File(pluginTmpDir, "bundle-versions/" + bundleDeployment.getBundleVersion().getId());
                        bundleFilesDir.mkdirs();
                        BundleManager.this.removeOldDownloadedBundleFiles(bundleFilesDir);
                        Map downloadedFiles = BundleManager.this.downloadBundleFiles(resourceDeployment, bundleFilesDir);
                        String deploymentMessage = "Deployment [" + bundleDeployment + "] to [" + resourceDeployment.getResource() + "]";
                        BundleManager.this.auditDeployment(resourceDeployment, "Deployment Started", bundleDeployment.getName(), deploymentMessage);
                        File absoluteDestDir = BundleManager.this.getAbsoluteDestinationDir(request.getBundleResourceDeployment());
                        BundleDeployRequest deployRequest = new BundleDeployRequest();
                        deployRequest.setBundleManagerProvider((BundleManagerProvider)BundleManager.this);
                        deployRequest.setResourceDeployment(resourceDeployment);
                        deployRequest.setBundleFilesLocation(bundleFilesDir);
                        deployRequest.setPackageVersionFiles(downloadedFiles);
                        deployRequest.setCleanDeployment(request.isCleanDeployment());
                        deployRequest.setRevert(request.isRevert());
                        deployRequest.setAbsoluteDestinationDirectory(absoluteDestDir);
                        int facetMethodTimeout = 14400000;
                        BundleFacet bundlePluginComponent = BundleManager.this.getBundleFacet(bundleHandlerResourceId, facetMethodTimeout);
                        BundleDeployResult result = bundlePluginComponent.deployBundle(deployRequest);
                        if (result.isSuccess()) {
                            BundleManager.this.completeDeployment(resourceDeployment, BundleDeploymentStatus.SUCCESS, deploymentMessage);
                        } else {
                            BundleManager.this.completeDeployment(resourceDeployment, BundleDeploymentStatus.FAILURE, result.getErrorMessage());
                        }
                    }
                    catch (InterruptedException ie) {
                        BundleManager.this.log.error((Object)"Failed to complete bundle deployment due to interrupt", (Throwable)ie);
                        BundleManager.this.completeDeployment(resourceDeployment, BundleDeploymentStatus.FAILURE, "Deployment interrupted");
                    }
                    catch (Throwable t) {
                        BundleManager.this.log.error((Object)"Failed to complete bundle deployment", t);
                        BundleManager.this.completeDeployment(resourceDeployment, BundleDeploymentStatus.FAILURE, "Deployment failed: " + ThrowableUtil.getAllMessages((Throwable)t));
                    }
                }
            };
            this.deployerThreadPool.execute(deployerRunnable);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to schedule bundle request: " + request), t);
            response.setErrorMessage(t);
        }
        return response;
    }

    public BundlePurgeResponse purge(org.rhq.core.clientapi.agent.bundle.BundlePurgeRequest request) {
        BundlePurgeResponse response = new BundlePurgeResponse();
        try {
            BundleResourceDeployment resourceDeployment = request.getLiveBundleResourceDeployment();
            BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            InventoryManager im = this.getInventoryManager();
            BundleType bundleType = bundleDeployment.getBundleVersion().getBundle().getBundleType();
            ResourceType resourceType = bundleType.getResourceType();
            Set<Resource> resources = im.getResourcesWithType(resourceType);
            if (resources.isEmpty()) {
                throw new Exception("No bundle plugin supports bundle type [" + bundleType + "]");
            }
            int bundleHandlerResourceId = resources.iterator().next().getId();
            ResourceContainer resourceContainer = im.getResourceContainer(bundleHandlerResourceId);
            if (null == resourceContainer.getResourceContext()) {
                throw new Exception("No bundle plugin resource available to handle purge for bundle type [" + bundleType + "]. Ensure the bundle plugin is deployed and its resource is imported into inventory.");
            }
            String deploymentMessage = "Deployment [" + bundleDeployment + "] to be purged via [" + resourceDeployment.getResource() + "]";
            this.auditDeployment(resourceDeployment, "Purge Started", bundleDeployment.getName(), deploymentMessage);
            File absoluteDestDir = this.getAbsoluteDestinationDir(request.getLiveBundleResourceDeployment());
            BundlePurgeRequest purgeRequest = new BundlePurgeRequest();
            purgeRequest.setBundleManagerProvider((BundleManagerProvider)this);
            purgeRequest.setLiveResourceDeployment(resourceDeployment);
            purgeRequest.setAbsoluteDestinationDirectory(absoluteDestDir);
            int facetMethodTimeout = 1800000;
            BundleFacet bundlePluginComponent = this.getBundleFacet(bundleHandlerResourceId, facetMethodTimeout);
            BundlePurgeResult result = bundlePluginComponent.purgeBundle(purgeRequest);
            if (result.isSuccess()) {
                this.auditDeployment(resourceDeployment, "Purge Ended", bundleDeployment.getName(), deploymentMessage);
            } else {
                response.setErrorMessage(result.getErrorMessage());
                this.auditDeployment(resourceDeployment, "Purge Ended", bundleDeployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, "Failed: " + deploymentMessage, result.getErrorMessage());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to purge bundle: " + request), t);
            response.setErrorMessage(t);
        }
        return response;
    }

    public void auditDeployment(BundleResourceDeployment bundleResourceDeployment, String action, String info, String message) {
        this.auditDeployment(bundleResourceDeployment, action, info, null, BundleResourceDeploymentHistory.Status.SUCCESS, message, null);
    }

    public void auditDeployment(BundleResourceDeployment bundleResourceDeployment, String action, String info, BundleResourceDeploymentHistory.Category category, BundleResourceDeploymentHistory.Status status, String message, String attachment) {
        if (null == action || null == info) {
            throw new IllegalArgumentException("action or info is null");
        }
        if (null == status) {
            status = BundleResourceDeploymentHistory.Status.SUCCESS;
        }
        BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory("Bundle Plugin", action, info, category, status, message, attachment);
        this.log.debug((Object)("Reporting deployment step [" + history + "] to Server..."));
        this.getBundleServerService().addDeploymentHistory(bundleResourceDeployment.getId(), history);
    }

    private void removeOldDownloadedBundleFiles(final File currentBundleVersionFilesDir) {
        File parent = null;
        try {
            File[] doomedFiles;
            parent = currentBundleVersionFilesDir.getParentFile();
            for (File doomedFile : doomedFiles = parent.listFiles(new FileFilter(){

                @Override
                public boolean accept(File child) {
                    return !currentBundleVersionFilesDir.equals(child);
                }
            })) {
                FileUtil.purge((File)doomedFile, (boolean)true);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to clean up old downloaded bundle files in [" + parent + "]. You can ignore this but if the agent is asked to deploy a lot of bundles, the file system may fill up." + " Cause: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PackageVersion, File> downloadBundleFiles(BundleResourceDeployment resourceDeployment, File downloadDir) throws Exception {
        BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
        BundleVersion bundleVersion = bundleDeployment.getBundleVersion();
        HashMap<PackageVersion, File> packageVersionFiles = new HashMap<PackageVersion, File>();
        List<PackageVersion> packageVersions = this.getAllBundleVersionPackageVersions(bundleVersion);
        for (PackageVersion packageVersion : packageVersions) {
            File packageFile = new File(downloadDir, packageVersion.getFileName());
            try {
                this.verifyHash(packageVersion, packageFile);
            }
            catch (Exception e) {
                packageFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(packageFile);
                try {
                    this.auditDeployment(resourceDeployment, "File Download Started", packageVersion.getDisplayName(), "Downloading [" + packageVersion + "]");
                    long size = this.getFileContent(packageVersion, fos);
                    if (packageVersion.getFileSize() != null && size != packageVersion.getFileSize()) {
                        String message = "Downloaded bundle file [" + packageVersion + "] but its size was [" + size + "] when it was expected to be [" + packageVersion.getFileSize() + "].";
                        this.log.warn((Object)message);
                        this.auditDeployment(resourceDeployment, "File Download Started", packageVersion.getDisplayName(), null, BundleResourceDeploymentHistory.Status.WARN, message, null);
                    } else {
                        this.auditDeployment(resourceDeployment, "File Download Started", packageVersion.getDisplayName(), "Download complete for [" + packageVersion + "]");
                    }
                }
                catch (Exception e2) {
                    String message = "Failed to downloaded bundle file [" + packageVersion + "] " + e2;
                    this.log.warn((Object)message);
                    this.auditDeployment(resourceDeployment, "File Download Started", packageVersion.getDisplayName(), null, BundleResourceDeploymentHistory.Status.FAILURE, message, null);
                }
                finally {
                    fos.close();
                }
                this.verifyHash(packageVersion, packageFile);
            }
            packageVersionFiles.put(packageVersion, packageFile);
        }
        return packageVersionFiles;
    }

    private void completeDeployment(BundleResourceDeployment resourceDeployment, BundleDeploymentStatus status, String message) {
        this.getBundleServerService().setBundleDeploymentStatus(resourceDeployment.getId(), status);
        BundleResourceDeploymentHistory.Status auditStatus = BundleDeploymentStatus.SUCCESS.equals((Object)status) ? BundleResourceDeploymentHistory.Status.SUCCESS : BundleResourceDeploymentHistory.Status.FAILURE;
        this.auditDeployment(resourceDeployment, "Deployment Ended", resourceDeployment.getBundleDeployment().getName(), null, auditStatus, message, null);
    }

    private void verifyHash(PackageVersion packageVersion, File packageFile) throws Exception {
        if (!packageFile.exists()) {
            throw new Exception("Package version [" + packageVersion + "] does not exist, cannot check hash");
        }
        if (packageVersion.getMD5() != null) {
            String realHash = new MessageDigestGenerator("MD5").calcDigestString(packageFile);
            if (!packageVersion.getMD5().equals(realHash)) {
                throw new Exception("Package version [" + packageVersion + "] failed MD5 check. expected=[" + packageVersion.getMD5() + "], actual=[" + realHash + "]");
            }
        } else if (packageVersion.getSHA256() != null) {
            String realHash = new MessageDigestGenerator("SHA-256").calcDigestString(packageFile);
            if (!packageVersion.getSHA256().equals(realHash)) {
                throw new Exception("Package version [" + packageVersion + "] failed SHA256 check. expected=[" + packageVersion.getSHA256() + "], actual=[" + realHash + "]");
            }
        } else {
            this.log.debug((Object)("Package version [" + packageVersion + "] has no MD5/SHA256 hash - not verifying it"));
        }
    }

    private File getAbsoluteDestinationDir(BundleResourceDeployment bundleResourceDeployment) {
        File destDir;
        String baseLocation;
        BundleDestination dest = bundleResourceDeployment.getBundleDeployment().getDestination();
        String destBaseDirName = dest.getDestinationBaseDirectoryName();
        String relativeDeployDir = dest.getDeployDir();
        if (relativeDeployDir == null || relativeDeployDir.trim().length() == 0) {
            relativeDeployDir = File.separator;
        }
        InventoryManager im = this.getInventoryManager();
        Resource resource = bundleResourceDeployment.getResource();
        ResourceContainer container = im.getResourceContainer(resource);
        resource = container.getResource();
        ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory bundleDestBaseDir = null;
        ResourceTypeBundleConfiguration rtbc = resource.getResourceType().getResourceTypeBundleConfiguration();
        if (rtbc == null) {
            throw new IllegalArgumentException("The resource type doesn't support bundle deployments: " + resource);
        }
        for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory bdbd : rtbc.getBundleDestinationBaseDirectories()) {
            if (!bdbd.getName().equals(destBaseDirName)) continue;
            bundleDestBaseDir = bdbd;
            break;
        }
        if (bundleDestBaseDir == null) {
            throw new IllegalArgumentException("The resource type doesn't support bundle destination base location named [" + destBaseDirName + "]");
        }
        String destBaseDirValueName = bundleDestBaseDir.getValueName();
        switch (bundleDestBaseDir.getValueContext()) {
            case fileSystem: {
                if (!new File(relativeDeployDir).isAbsolute()) {
                    baseLocation = destBaseDirValueName;
                    if (baseLocation != null && baseLocation.trim().length() != 0) break;
                    baseLocation = File.separator;
                    break;
                }
                baseLocation = null;
                break;
            }
            case pluginConfiguration: {
                baseLocation = resource.getPluginConfiguration().getSimpleValue(destBaseDirValueName, null);
                if (baseLocation != null) break;
                throw new IllegalArgumentException("Cannot determine the bundle base deployment location - there is no plugin configuration setting for [" + destBaseDirValueName + "]");
            }
            case resourceConfiguration: {
                baseLocation = resource.getResourceConfiguration().getSimpleValue(destBaseDirValueName, null);
                if (baseLocation != null) break;
                throw new IllegalArgumentException("Cannot determine the bundle base deployment location - there is no resource configuration setting for [" + destBaseDirValueName + "]");
            }
            case measurementTrait: {
                baseLocation = this.getMeasurementManager().getTraitValue(container, destBaseDirValueName);
                if (baseLocation != null) break;
                throw new IllegalArgumentException("Cannot obtain trait [" + destBaseDirName + "] for resource [" + resource.getName() + "]");
            }
            default: {
                throw new IllegalArgumentException("Unknown bundle destination location context: " + bundleDestBaseDir);
            }
        }
        if (!(destDir = new File(baseLocation, relativeDeployDir)).isAbsolute()) {
            throw new IllegalArgumentException("The base location path specified by [" + destBaseDirValueName + "] in the context [" + bundleDestBaseDir.getValueContext() + "] along with the destination directory of [" + relativeDeployDir + "] did not resolve to an absolute path [" + destDir.getPath() + "] so there is no way to know where to put the bundle.");
        }
        return destDir;
    }

    private BundleServerService getBundleServerService() {
        if (this.configuration.getServerServices() != null) {
            return this.configuration.getServerServices().getBundleServerService();
        }
        throw new IllegalStateException("There is no bundle server service available to obtain bundle files");
    }

    protected BundleFacet getBundleFacet(int resourceId, long timeout) throws PluginContainerException {
        return ComponentUtil.getComponent(resourceId, BundleFacet.class, FacetLockType.READ, timeout, false, true);
    }

    protected InventoryManager getInventoryManager() {
        return PluginContainer.getInstance().getInventoryManager();
    }

    protected MeasurementManager getMeasurementManager() {
        return PluginContainer.getInstance().getMeasurementManager();
    }
}

