/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigurationManager;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;

public class ConfigurationCheckExecutor
implements Runnable,
Callable {
    private final Log log = LogFactory.getLog(ConfigurationCheckExecutor.class);
    private ConfigurationManager configurationManager;
    private ConfigurationServerService configurationServerService;
    private InventoryManager inventoryManager;
    private static final long CONFIGURATION_CHECK_TIMEOUT = 30000L;

    public ConfigurationCheckExecutor(ConfigurationManager configurationManager, ConfigurationServerService configurationServerService, InventoryManager inventoryManager) {
        this.configurationManager = configurationManager;
        this.configurationServerService = configurationServerService;
        this.inventoryManager = inventoryManager;
    }

    @Override
    public void run() {
        this.call();
    }

    public Object call() {
        this.log.info((Object)"Starting configuration update check...");
        long start = System.currentTimeMillis();
        this.checkConfigurations(this.inventoryManager.getPlatform(), true);
        this.log.info((Object)("Configuration update check completed in " + (System.currentTimeMillis() - start) + "ms"));
        return null;
    }

    public void checkConfigurations(Resource resource, boolean checkChildren) {
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(resource);
        ConfigurationFacet resourceComponent = null;
        ResourceType resourceType = resource.getResourceType();
        if (resourceContainer != null && resourceContainer.getAvailability() != null && resourceContainer.getAvailability().getAvailabilityType() == AvailabilityType.UP) {
            try {
                resourceComponent = resourceContainer.createResourceComponentProxy(ConfigurationFacet.class, FacetLockType.NONE, 30000L, true, false);
            }
            catch (PluginContainerException e) {
                // empty catch block
            }
            if (resourceComponent != null && resource.getInventoryStatus() == InventoryStatus.COMMITTED && resourceType.getResourceConfigurationDefinition() != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Checking for updated Resource configuration for " + resource + "..."));
                }
                try {
                    Configuration liveConfiguration = resourceComponent.loadResourceConfiguration();
                    if (liveConfiguration != null) {
                        ConfigurationDefinition configurationDefinition = resourceType.getResourceConfigurationDefinition();
                        ConfigurationUtility.normalizeConfiguration((Configuration)liveConfiguration, (ConfigurationDefinition)configurationDefinition);
                        List errorMessages = ConfigurationUtility.validateConfiguration((Configuration)liveConfiguration, (ConfigurationDefinition)configurationDefinition);
                        for (String errorMessage : errorMessages) {
                            this.log.warn((Object)("Plugin Error: Invalid " + resourceType.getName() + " resource configuration returned by " + resourceType.getPlugin() + " plugin - " + errorMessage));
                        }
                        Configuration original = resource.getResourceConfiguration();
                        if (!liveConfiguration.equals((Object)original)) {
                            this.log.info((Object)("New configuration version detected on resource: " + resource));
                            this.configurationServerService.persistUpdatedResourceConfiguration(resource.getId(), liveConfiguration);
                            resource.setResourceConfiguration(liveConfiguration);
                        }
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)("An error occurred while checking for an updated Resource configuration for " + resource + "."), t);
                }
            }
            if (checkChildren) {
                for (Resource child : this.inventoryManager.getContainerChildren(resource, resourceContainer)) {
                    try {
                        this.checkConfigurations(child, true);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to check Resource configuration for " + child + "."), (Throwable)e);
                    }
                }
            }
        }
    }
}

