/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.File;
import java.io.IOException;
import org.rhq.common.drift.ChangeSetReader;
import org.rhq.common.drift.ChangeSetReaderImpl;
import org.rhq.common.drift.ChangeSetWriter;
import org.rhq.common.drift.ChangeSetWriterImpl;
import org.rhq.common.drift.Headers;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.pc.drift.ChangeSetManager;

public class ChangeSetManagerImpl
implements ChangeSetManager {
    private File changeSetsDir;

    public ChangeSetManagerImpl(File changeSetsDir) {
        this.changeSetsDir = changeSetsDir;
    }

    @Override
    public boolean changeSetExists(int resourceId, Headers headers) {
        File changeSetDir = this.findChangeSetDir(resourceId, headers.getDriftDefinitionName());
        if (changeSetDir == null || !changeSetDir.exists()) {
            return false;
        }
        return new File(changeSetDir, "changeset.txt").exists();
    }

    @Override
    public File findChangeSet(int resourceId, String driftDefinitionName) throws IOException {
        File changeSetDir = this.findChangeSetDir(resourceId, driftDefinitionName);
        File changeSetFile = new File(changeSetDir, "changeset.txt");
        if (changeSetFile.exists()) {
            return changeSetFile;
        }
        return null;
    }

    @Override
    public File findChangeSet(int resourceId, String name, DriftChangeSetCategory type) {
        File resourceDir = new File(this.changeSetsDir, Integer.toString(resourceId));
        File changeSetDir = new File(resourceDir, name);
        if (!changeSetDir.exists()) {
            changeSetDir.mkdirs();
        }
        switch (type) {
            case COVERAGE: {
                return new File(changeSetDir, "changeset.txt");
            }
            case DRIFT: {
                return new File(changeSetDir, "drift-changeset.txt");
            }
        }
        throw new IllegalArgumentException(type + " is not a recognized, supported change set type.");
    }

    @Override
    public ChangeSetReader getChangeSetReader(int resourceId, String driftDefinitionName) throws IOException {
        File changeSetFile = this.findChangeSet(resourceId, driftDefinitionName);
        if (changeSetFile == null) {
            return null;
        }
        return new ChangeSetReaderImpl(changeSetFile);
    }

    @Override
    public ChangeSetReader getChangeSetReader(File changeSetFile) throws IOException {
        return new ChangeSetReaderImpl(changeSetFile);
    }

    @Override
    public ChangeSetWriter getChangeSetWriter(int resourceId, Headers headers) throws IOException {
        File resourceDir = new File(this.changeSetsDir, Integer.toString(resourceId));
        File changeSetDir = new File(resourceDir, headers.getDriftDefinitionName());
        if (!changeSetDir.exists()) {
            changeSetDir.mkdirs();
        }
        File changeSet = headers.getType() == DriftChangeSetCategory.COVERAGE ? new File(changeSetDir, "changeset.txt") : new File(changeSetDir, "drift-changeset.txt");
        return new ChangeSetWriterImpl(changeSet, headers);
    }

    @Override
    public ChangeSetWriter getChangeSetWriter(File changeSetFile, Headers headers) throws IOException {
        return new ChangeSetWriterImpl(changeSetFile, headers);
    }

    private File findChangeSetDir(int resourceId, String driftDefinitionName) {
        File resourceDir = new File(this.changeSetsDir, Integer.toString(resourceId));
        if (!resourceDir.exists()) {
            return null;
        }
        return new File(resourceDir, driftDefinitionName);
    }
}

