/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.Serializable;
import org.rhq.core.domain.drift.DriftDefinition;

public class DriftDetectionSchedule
implements Comparable<DriftDetectionSchedule>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int resourceId;
    private DriftDefinition driftDef;
    private long nextScan;

    public DriftDetectionSchedule(int resourceId, DriftDefinition definition) {
        this.resourceId = resourceId;
        this.driftDef = definition;
        this.nextScan = -1L;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public DriftDefinition getDriftDefinition() {
        return this.driftDef;
    }

    public long getNextScan() {
        return this.nextScan;
    }

    public void updateShedule() {
        this.nextScan = System.currentTimeMillis() + this.driftDef.getInterval() * 1000L;
    }

    public void resetSchedule() {
        this.nextScan = -1L;
    }

    public DriftDetectionSchedule copy() {
        DriftDetectionSchedule copy = new DriftDetectionSchedule(this.resourceId, new DriftDefinition(this.driftDef.getConfiguration().deepCopyWithoutProxies()));
        copy.driftDef.setId(this.driftDef.getId());
        copy.nextScan = this.nextScan;
        return copy;
    }

    @Override
    public int compareTo(DriftDetectionSchedule other) {
        if (this.nextScan < other.nextScan) {
            return -1;
        }
        if (this.nextScan > other.nextScan) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DriftDetectionSchedule) {
            DriftDetectionSchedule that = (DriftDetectionSchedule)obj;
            return this.nextScan == that.nextScan;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.nextScan).hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[resourceId: " + this.resourceId + ", driftDefinitionId: " + this.driftDef.getId() + ", driftDefinitionName: " + this.driftDef.getName() + "]";
    }
}

