/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.common.drift.ChangeSetReader;
import org.rhq.common.drift.ChangeSetWriter;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.Filter;
import org.rhq.core.pc.drift.ChangeSetManager;
import org.rhq.core.pc.drift.DriftClient;
import org.rhq.core.pc.drift.DriftDetectionSchedule;
import org.rhq.core.pc.drift.DriftDetectionSummary;
import org.rhq.core.pc.drift.FilterFileVisitor;
import org.rhq.core.pc.drift.ScheduleQueue;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.file.FileVisitor;

public class DriftDetector
implements Runnable {
    private Log log = LogFactory.getLog(DriftDetector.class);
    static final String FILE_CHANGESET_FULL = "changeset.txt";
    static final String FILE_CHANGESET_DELTA = "drift-changeset.txt";
    static final String FILE_SNAPSHOT_PINNED = "snapshot.pinned";
    private ScheduleQueue scheduleQueue;
    private ChangeSetManager changeSetMgr;
    private MessageDigestGenerator digestGenerator = new MessageDigestGenerator("SHA-256");
    private DriftClient driftClient;

    public void setScheduleQueue(ScheduleQueue queue) {
        this.scheduleQueue = queue;
    }

    public void setChangeSetManager(ChangeSetManager changeSetManager) {
        this.changeSetMgr = changeSetManager;
    }

    public void setDriftClient(DriftClient driftClient) {
        this.driftClient = driftClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block41: {
            DriftDetectionSchedule schedule;
            boolean updateSchedule;
            long startTime;
            block40: {
                block39: {
                    block38: {
                        block37: {
                            this.log.debug((Object)"Starting drift detection...");
                            startTime = System.currentTimeMillis();
                            updateSchedule = true;
                            schedule = null;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Fetching next schedule from " + this.scheduleQueue));
                            }
                            if ((schedule = this.scheduleQueue.getNextSchedule()) != null) break block37;
                            this.log.debug((Object)"No schedules are in the queue.");
                            updateSchedule = false;
                            try {
                                this.scheduleQueue.deactivateSchedule(updateSchedule);
                                long endTime = System.currentTimeMillis();
                                this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
                            }
                            catch (Throwable t) {
                                Throwable cause = t.getCause();
                                String message = null != cause ? cause.getMessage() : t.getMessage();
                                this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message), t);
                            }
                            return;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Processing " + schedule));
                        }
                        if (schedule.getNextScan() <= System.currentTimeMillis() + 100L) break block38;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Skipping " + schedule + " because it is too early to do the next detection."));
                        }
                        updateSchedule = false;
                        try {
                            this.scheduleQueue.deactivateSchedule(updateSchedule);
                            long endTime = System.currentTimeMillis();
                            this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
                        }
                        catch (Throwable t) {
                            Throwable cause = t.getCause();
                            String message = null != cause ? cause.getMessage() : t.getMessage();
                            this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message), t);
                        }
                        return;
                    }
                    if (schedule.getDriftDefinition().isEnabled()) break block39;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Skipping " + schedule + " because the drift definition is disabled."));
                    }
                    updateSchedule = false;
                    try {
                        this.scheduleQueue.deactivateSchedule(updateSchedule);
                        long endTime = System.currentTimeMillis();
                        this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
                    }
                    catch (Throwable t) {
                        Throwable cause = t.getCause();
                        String message = null != cause ? cause.getMessage() : t.getMessage();
                        this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message), t);
                    }
                    return;
                }
                if (!this.previousSnapshotExists(schedule)) break block40;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Skipping " + schedule + " because server has not yet acked previous change set"));
                }
                updateSchedule = false;
                try {
                    this.scheduleQueue.deactivateSchedule(updateSchedule);
                    long endTime = System.currentTimeMillis();
                    this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
                }
                catch (Throwable t) {
                    Throwable cause = t.getCause();
                    String message = null != cause ? cause.getMessage() : t.getMessage();
                    this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message), t);
                }
                return;
            }
            DriftDetectionSummary detectionSummary = new DriftDetectionSummary();
            detectionSummary.setSchedule(schedule);
            try {
                if (this.changeSetMgr.changeSetExists(schedule.getResourceId(), this.createHeaders(schedule, DriftChangeSetCategory.COVERAGE, 0))) {
                    detectionSummary.setType(DriftChangeSetCategory.DRIFT);
                    this.generateDriftChangeSet(detectionSummary);
                } else {
                    detectionSummary.setType(DriftChangeSetCategory.COVERAGE);
                    this.generateSnapshot(detectionSummary);
                }
                if (!detectionSummary.isBaseDirExists()) {
                    this.driftClient.reportMissingBaseDir(schedule.getResourceId(), schedule.getDriftDefinition());
                } else if (detectionSummary.isRepeat()) {
                    this.driftClient.repeatChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), detectionSummary.getVersion());
                } else if (this.changesNeedToBeReported(detectionSummary)) {
                    this.driftClient.sendChangeSetToServer(detectionSummary);
                }
            }
            catch (IOException e) {
                this.log.error((Object)("Drift detection failed: " + e.getMessage()), (Throwable)e);
                this.revertSnapshot(detectionSummary);
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Drift detection failed: " + e.getMessage()), (Throwable)e);
                this.revertSnapshot(detectionSummary);
            }
            try {
                this.scheduleQueue.deactivateSchedule(updateSchedule);
                long endTime = System.currentTimeMillis();
                this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                String message = null != cause ? cause.getMessage() : t.getMessage();
                this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message), t);
            }
            break block41;
            catch (Throwable t) {
                String message;
                Throwable cause;
                try {
                    cause = t.getCause();
                    message = null != cause ? cause.getMessage() : t.getMessage();
                    this.log.error((Object)("An unexpected error occurred during drift detection: " + message), t);
                }
                catch (Throwable throwable) {
                    try {
                        this.scheduleQueue.deactivateSchedule(updateSchedule);
                        long endTime = System.currentTimeMillis();
                        this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
                    }
                    catch (Throwable t2) {
                        Throwable cause2 = t2.getCause();
                        String message2 = null != cause2 ? cause2.getMessage() : t2.getMessage();
                        this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message2), t2);
                    }
                    throw throwable;
                }
                try {
                    this.scheduleQueue.deactivateSchedule(updateSchedule);
                    long endTime = System.currentTimeMillis();
                    this.log.debug((Object)("Finished drift detection in " + (endTime - startTime) + " ms"));
                }
                catch (Throwable t3) {
                    cause = t3.getCause();
                    message = null != cause ? cause.getMessage() : t3.getMessage();
                    this.log.error((Object)("An unexpected error occurred while deactivating schedule: " + message), t3);
                }
            }
        }
    }

    private boolean changesNeedToBeReported(DriftDetectionSummary detectionSummary) {
        return detectionSummary.getType() == DriftChangeSetCategory.COVERAGE || detectionSummary.getDriftChangeSet() != null;
    }

    private boolean previousSnapshotExists(DriftDetectionSchedule schedule) {
        File snapshot = this.changeSetMgr.findChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), DriftChangeSetCategory.COVERAGE);
        File previousSnapshot = new File(snapshot.getParentFile(), snapshot.getName() + ".previous");
        return previousSnapshot.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDriftChangeSet(DriftDetectionSummary summary) throws IOException {
        LinkedList<FileEntry> changedPinnedEntries;
        LinkedList<FileEntry> changedEntries;
        LinkedList<FileEntry> unchangedEntries;
        HashSet<File> newFiles;
        block27: {
            LinkedList<FileEntry> deltaEntries;
            LinkedList<FileEntry> snapshotEntries;
            int newVersion;
            File currentFullSnapshot;
            DriftDetectionSchedule schedule;
            block28: {
                schedule = summary.getSchedule();
                this.log.debug((Object)("Generating drift change set for " + schedule));
                boolean isPinned = schedule.getDriftDefinition().isPinned();
                File basedir = new File(this.basedir(schedule.getResourceId(), schedule.getDriftDefinition()));
                currentFullSnapshot = this.changeSetMgr.findChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), DriftChangeSetCategory.COVERAGE);
                File snapshotFile = isPinned ? new File(currentFullSnapshot.getParentFile(), FILE_SNAPSHOT_PINNED) : currentFullSnapshot;
                newFiles = new HashSet<File>(1000);
                if (basedir.isDirectory()) {
                    DriftDefinition driftDef = schedule.getDriftDefinition();
                    List includes = driftDef.getIncludes();
                    List excludes = driftDef.getExcludes();
                    for (File dir : DriftDetector.getScanDirectories(basedir, includes)) {
                        FileUtil.forEachFile((File)dir, (FileVisitor)new FilterFileVisitor(basedir, includes, excludes, new FileVisitor(){

                            public void visit(File file) {
                                if (file.canRead()) {
                                    newFiles.add(file);
                                } else if (DriftDetector.this.log.isDebugEnabled()) {
                                    DriftDetector.this.log.debug((Object)("Skipping " + file.getPath() + " as new file since it is not readable."));
                                }
                            }
                        }));
                    }
                }
                unchangedEntries = new LinkedList<FileEntry>();
                changedEntries = new LinkedList<FileEntry>();
                LinkedList<FileEntry> removedEntries = new LinkedList<FileEntry>();
                LinkedList<FileEntry> addedEntries = new LinkedList<FileEntry>();
                changedPinnedEntries = isPinned ? new LinkedList<FileEntry>() : null;
                try {
                    ChangeSetReader snapshotReader = null;
                    boolean updateSnapshot = false;
                    try {
                        snapshotReader = this.changeSetMgr.getChangeSetReader(snapshotFile);
                        if (!basedir.exists()) {
                            this.log.warn((Object)("The base directory [" + basedir.getAbsolutePath() + "] for " + schedule + " does not exist."));
                        }
                        if (isPinned) {
                            ChangeSetReader currentFullSnapshotReader = null;
                            try {
                                currentFullSnapshotReader = this.changeSetMgr.getChangeSetReader(currentFullSnapshot);
                                newVersion = currentFullSnapshotReader.getHeaders().getVersion() + 1;
                            }
                            finally {
                                if (null != currentFullSnapshotReader) {
                                    currentFullSnapshotReader.close();
                                }
                            }
                        } else {
                            newVersion = snapshotReader.getHeaders().getVersion() + 1;
                        }
                        updateSnapshot = this.scanSnapshot(schedule, basedir, snapshotReader, newFiles, unchangedEntries, changedEntries, removedEntries, changedPinnedEntries);
                    }
                    finally {
                        if (null != snapshotReader) {
                            snapshotReader.close();
                        }
                    }
                    if (isPinned && updateSnapshot) {
                        changedPinnedEntries.addAll(unchangedEntries);
                        this.backupAndDeleteCurrentSnapshot(snapshotFile);
                        this.updatePinnedSnapshot(schedule, snapshotFile, changedPinnedEntries);
                    }
                    for (File file : newFiles) {
                        try {
                            FileEntry addedFileEntry;
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)("Detected added file for " + schedule + " --> " + file.getAbsolutePath()));
                            }
                            if (null == (addedFileEntry = this.getAddedFileEntry(basedir, file))) continue;
                            addedEntries.add(addedFileEntry);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("An unexpected error occurred while generating a drift change set for file " + file.getPath() + " in schedule " + schedule + ". Skipping file."), t);
                        }
                    }
                    snapshotEntries = new LinkedList<FileEntry>(unchangedEntries);
                    snapshotEntries.addAll(changedEntries);
                    snapshotEntries.addAll(addedEntries);
                    deltaEntries = new LinkedList<FileEntry>(changedEntries);
                    deltaEntries.addAll(removedEntries);
                    deltaEntries.addAll(addedEntries);
                    if (deltaEntries.isEmpty()) {
                        File newSnapshot = currentFullSnapshot;
                        if (!isPinned) {
                            if (updateSnapshot) {
                                currentFullSnapshot.delete();
                                newSnapshot = this.updateCurrentSnapshot(schedule, snapshotEntries, newVersion - 1);
                            }
                        } else if (newVersion > 1 && !this.isPreviousChangeSetEmpty(schedule.getResourceId(), schedule.getDriftDefinition())) {
                            currentFullSnapshot.delete();
                            newSnapshot = this.updateCurrentSnapshot(schedule, snapshotEntries, newVersion);
                            this.updateDeltaSnapshot(summary, schedule, deltaEntries, newVersion, currentFullSnapshot, newSnapshot);
                        }
                        summary.setNewSnapshot(newSnapshot);
                        break block27;
                    }
                    if (!isPinned || newVersion <= 1 || !this.isSameAsPreviousChangeSet(deltaEntries, currentFullSnapshot)) break block28;
                    summary.setVersion(newVersion - 1);
                    summary.setRepeat(true);
                }
                catch (Throwable throwable) {
                    DriftDetector.safeClear(newFiles, unchangedEntries, changedEntries, changedPinnedEntries);
                    throw throwable;
                }
                DriftDetector.safeClear(newFiles, unchangedEntries, changedEntries, changedPinnedEntries);
                return;
            }
            File oldSnapshot = this.backupAndDeleteCurrentSnapshot(currentFullSnapshot);
            File newSnapshot = this.updateCurrentSnapshot(schedule, snapshotEntries, newVersion);
            this.updateDeltaSnapshot(summary, schedule, deltaEntries, newVersion, oldSnapshot, newSnapshot);
        }
        DriftDetector.safeClear(newFiles, unchangedEntries, changedEntries, changedPinnedEntries);
    }

    private FileEntry getAddedFileEntry(File basedir, File file) throws IOException {
        FileEntry result;
        block2: {
            result = null;
            try {
                String sha256 = this.sha256(file);
                String relativePath = this.relativePath(basedir, file);
                long lastModified = file.lastModified();
                long length = file.length();
                result = FileEntry.addedFileEntry((String)relativePath, (String)sha256, (Long)lastModified, (Long)length);
            }
            catch (FileNotFoundException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Skipping " + file.getPath() + " since it is missing or is not a physically readable file."));
            }
        }
        return result;
    }

    private static void safeClear(Collection<?> ... collections) {
        if (null == collections) {
            return;
        }
        for (Collection<?> c : collections) {
            if (null == c) continue;
            c.clear();
        }
    }

    private static Set<File> getScanDirectories(File basedir, List<Filter> includes) {
        HashSet<File> directories = new HashSet<File>();
        if (null == includes || includes.isEmpty()) {
            directories.add(basedir);
        } else {
            for (Filter filter : includes) {
                String path = filter.getPath();
                if (".".equals(path)) {
                    directories.add(basedir);
                    continue;
                }
                directories.add(new File(basedir, path));
            }
        }
        return directories;
    }

    private boolean scanSnapshot(DriftDetectionSchedule schedule, File basedir, ChangeSetReader snapshotReader, Set<File> newFiles, List<FileEntry> unchangedEntries, List<FileEntry> changedEntries, List<FileEntry> removedEntries, List<FileEntry> changedPinnedEntries) throws IOException {
        boolean result = false;
        for (FileEntry entry : snapshotReader) {
            File file = new File(basedir, entry.getFile());
            newFiles.remove(file);
            if (!file.exists() || !file.canRead()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Detected " + (file.exists() ? "unreadable" : "deleted") + " file for " + schedule + " --> " + file.getAbsolutePath()));
                }
                removedEntries.add(FileEntry.removedFileEntry((String)entry.getFile(), (String)entry.getNewSHA()));
                if (null == changedPinnedEntries) continue;
                changedPinnedEntries.add(entry);
                continue;
            }
            String currentSHA = null;
            boolean isChanged = false;
            if (entry.getLastModified() == -1L || entry.getSize() == -1L || entry.getLastModified().longValue() != file.lastModified() || entry.getSize().longValue() != file.length()) {
                currentSHA = this.sha256(file);
                boolean bl = isChanged = !entry.getNewSHA().equals(currentSHA);
            }
            if (isChanged) {
                FileEntry changedEntry = FileEntry.changedFileEntry((String)entry.getFile(), (String)entry.getNewSHA(), (String)currentSHA, (Long)file.lastModified(), (Long)file.length());
                changedEntries.add(changedEntry);
                if (null == changedPinnedEntries) continue;
                changedPinnedEntries.add(entry);
                continue;
            }
            if (-1L == entry.getLastModified()) {
                entry.setLastModified(Long.valueOf(file.lastModified()));
                result = true;
            }
            if (-1L == entry.getSize()) {
                entry.setSize(Long.valueOf(file.length()));
                result = true;
            }
            unchangedEntries.add(entry);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreviousChangeSetEmpty(int resourceId, DriftDefinition definition) throws IOException {
        boolean isEmpty;
        File changeSet = this.changeSetMgr.findChangeSet(resourceId, definition.getName(), DriftChangeSetCategory.DRIFT);
        if (!changeSet.exists()) {
            return true;
        }
        ChangeSetReader reader = null;
        try {
            reader = this.changeSetMgr.getChangeSetReader(changeSet);
            isEmpty = true;
            Iterator i$ = reader.iterator();
            if (i$.hasNext()) {
                FileEntry entry = (FileEntry)i$.next();
                isEmpty = false;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeltaSnapshot(DriftDetectionSummary summary, DriftDetectionSchedule schedule, List<FileEntry> deltaEntries, int newVersion, File oldSnapshot, File newSnapshot) throws IOException {
        ChangeSetWriter deltaWriter = null;
        try {
            Headers deltaHeaders = this.createHeaders(schedule, DriftChangeSetCategory.DRIFT, newVersion);
            File driftChangeSet = this.changeSetMgr.findChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), DriftChangeSetCategory.DRIFT);
            deltaWriter = this.changeSetMgr.getChangeSetWriter(driftChangeSet, deltaHeaders);
            summary.setDriftChangeSet(driftChangeSet);
            summary.setNewSnapshot(newSnapshot);
            summary.setOldSnapshot(oldSnapshot);
            for (FileEntry entry : deltaEntries) {
                deltaWriter.write(entry);
            }
        }
        finally {
            if (deltaWriter != null) {
                deltaWriter.close();
            }
        }
    }

    private File backupAndDeleteCurrentSnapshot(File currentSnapshot) throws IOException {
        File oldSnapshot = new File(currentSnapshot.getParentFile(), currentSnapshot.getName() + ".previous");
        FileUtil.copyFile((File)currentSnapshot, (File)oldSnapshot);
        currentSnapshot.delete();
        return oldSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updateCurrentSnapshot(DriftDetectionSchedule schedule, List<FileEntry> snapshotEntries, int newVersion) throws IOException {
        ChangeSetWriter newSnapshotWriter = null;
        try {
            Headers snapshotHeaders = this.createHeaders(schedule, DriftChangeSetCategory.COVERAGE, newVersion);
            File newSnapshot = this.changeSetMgr.findChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), DriftChangeSetCategory.COVERAGE);
            newSnapshotWriter = this.changeSetMgr.getChangeSetWriter(schedule.getResourceId(), snapshotHeaders);
            for (FileEntry entry : snapshotEntries) {
                newSnapshotWriter.write(entry);
            }
            File file = newSnapshot;
            return file;
        }
        finally {
            if (null != newSnapshotWriter) {
                newSnapshotWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updatePinnedSnapshot(DriftDetectionSchedule schedule, File pinnedSnapshot, List<FileEntry> snapshotEntries) throws IOException {
        ChangeSetWriter newSnapshotWriter = null;
        try {
            Headers snapshotHeaders = this.createHeaders(schedule, DriftChangeSetCategory.COVERAGE, 0);
            newSnapshotWriter = this.changeSetMgr.getChangeSetWriter(pinnedSnapshot, snapshotHeaders);
            for (FileEntry entry : snapshotEntries) {
                newSnapshotWriter.write(entry);
            }
            File file = pinnedSnapshot;
            return file;
        }
        finally {
            if (null != newSnapshotWriter) {
                newSnapshotWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSameAsPreviousChangeSet(List<FileEntry> entries, File currentSnapsotFile) throws IOException {
        HashMap<String, FileEntry> entriesMap = new HashMap<String, FileEntry>();
        for (FileEntry e : entries) {
            entriesMap.put(e.getFile(), e);
        }
        ChangeSetReader reader = null;
        try {
            File deltaChangeSet = new File(currentSnapsotFile.getParentFile(), FILE_CHANGESET_DELTA);
            reader = this.changeSetMgr.getChangeSetReader(deltaChangeSet);
            int numEntries = 0;
            for (FileEntry entry : reader) {
                FileEntry newEntry = (FileEntry)entriesMap.get(entry.getFile());
                if (newEntry == null) {
                    boolean bl = false;
                    return bl;
                }
                if (entry.getType() != newEntry.getType()) {
                    boolean bl = false;
                    return bl;
                }
                switch (entry.getType()) {
                    case FILE_ADDED: {
                        if (!entry.getNewSHA().equals(newEntry.getNewSHA())) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    case FILE_CHANGED: {
                        if (entry.getNewSHA().equals(newEntry.getNewSHA()) && entry.getOldSHA().equals(newEntry.getOldSHA())) break;
                        boolean bl = false;
                        return bl;
                    }
                }
                if (!entry.getOldSHA().equals(newEntry.getOldSHA())) {
                    boolean bl = false;
                    return bl;
                }
                ++numEntries;
            }
            boolean bl = numEntries == entriesMap.size();
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSnapshot(DriftDetectionSummary summary) throws IOException {
        DriftDetectionSchedule schedule = summary.getSchedule();
        DriftDefinition driftDef = schedule.getDriftDefinition();
        File basedir = new File(this.basedir(schedule.getResourceId(), driftDef));
        if (!basedir.exists()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("The base directory [" + basedir.getAbsolutePath() + "] for " + schedule + " does not " + "exist. You may want review the drift definition and verify that the value of the base " + "directory is in fact correct."));
            }
            summary.setBaseDirExists(false);
            return;
        }
        this.log.debug((Object)("Generating coverage change set for " + schedule));
        File snapshot = this.changeSetMgr.findChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), DriftChangeSetCategory.COVERAGE);
        ChangeSetWriter writer = null;
        try {
            writer = this.changeSetMgr.getChangeSetWriter(snapshot, this.createHeaders(schedule, DriftChangeSetCategory.COVERAGE, 0));
            if (basedir.isDirectory()) {
                this.doDirectoryScan(schedule, driftDef, basedir, writer);
                writer.close();
                writer = null;
            }
            if (schedule.getDriftDefinition().isPinned()) {
                FileUtil.copyFile((File)snapshot, (File)new File(snapshot.getParentFile(), FILE_SNAPSHOT_PINNED));
            }
            summary.setNewSnapshot(snapshot);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void doDirectoryScan(final DriftDetectionSchedule schedule, DriftDefinition driftDef, final File basedir, final ChangeSetWriter writer) {
        List includes = driftDef.getIncludes();
        List excludes = driftDef.getExcludes();
        for (File dir : DriftDetector.getScanDirectories(basedir, includes)) {
            FileUtil.forEachFile((File)dir, (FileVisitor)new FilterFileVisitor(basedir, includes, excludes, new FileVisitor(){

                public void visit(File file) {
                    try {
                        FileEntry addedFileEntry;
                        if (!file.canRead()) {
                            if (DriftDetector.this.log.isDebugEnabled()) {
                                DriftDetector.this.log.debug((Object)("Skipping " + file.getPath() + " since we do not have read access."));
                            }
                            return;
                        }
                        if (DriftDetector.this.log.isDebugEnabled()) {
                            DriftDetector.this.log.debug((Object)("Adding " + file.getPath() + " to coverage change set for " + schedule));
                        }
                        if (null != (addedFileEntry = DriftDetector.this.getAddedFileEntry(basedir, file))) {
                            writer.write(addedFileEntry);
                        }
                    }
                    catch (Throwable t) {
                        DriftDetector.this.log.error((Object)("An unexpected error occurred while generating a coverage change set for file " + file.getPath() + " in schedule " + schedule + ". Skipping file."), t);
                    }
                }
            }));
        }
    }

    private String relativePath(File basedir, File file) {
        if (basedir.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basedirPath = basedir.getAbsolutePath();
        int basedirLen = basedirPath.length();
        if (!basedirPath.endsWith(File.separator)) {
            ++basedirLen;
        }
        return filePath.substring(basedirLen);
    }

    private String sha256(File file) throws IOException {
        return this.digestGenerator.calcDigestString(file);
    }

    private String basedir(int resourceId, DriftDefinition driftDef) {
        return this.driftClient.getAbsoluteBaseDirectory(resourceId, driftDef).getAbsolutePath();
    }

    private Headers createHeaders(DriftDetectionSchedule schedule, DriftChangeSetCategory type, int version) {
        Headers headers = new Headers();
        headers.setResourceId(schedule.getResourceId());
        headers.setDriftDefinitionId(schedule.getDriftDefinition().getId());
        headers.setDriftDefinitionName(schedule.getDriftDefinition().getName());
        headers.setBasedir(this.basedir(schedule.getResourceId(), schedule.getDriftDefinition()));
        headers.setType(type);
        headers.setVersion(version);
        return headers;
    }

    private void revertSnapshot(DriftDetectionSummary summary) throws IOException {
        this.log.info((Object)("Reverting snapshot for " + summary.getSchedule()));
        DriftDetectionSchedule scheudle = summary.getSchedule();
        File newSnapshot = this.changeSetMgr.findChangeSet(scheudle.getResourceId(), scheudle.getDriftDefinition().getName(), DriftChangeSetCategory.COVERAGE);
        newSnapshot.delete();
        if (summary.getType() == DriftChangeSetCategory.DRIFT) {
            File oldSnapshotBackup = summary.getOldSnapshot();
            if (oldSnapshotBackup != null && oldSnapshotBackup.exists()) {
                FileUtil.copyFile((File)oldSnapshotBackup, (File)newSnapshot);
                oldSnapshotBackup.delete();
            } else {
                this.log.error((Object)("Cannot revert snapshot to previous version for " + summary.getSchedule() + ". Snapshot back up file not found."));
            }
        }
        this.deleteZipFiles(newSnapshot.getParentFile());
    }

    private void deleteZipFiles(File dir) {
        File[] files;
        for (File file : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        })) {
            file.delete();
        }
    }
}

