/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift.sync;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.pc.drift.DriftManager;
import org.rhq.core.pc.drift.sync.DriftSynchronizer;
import org.rhq.core.pc.drift.sync.DriftSynchronizerFactory;
import org.rhq.core.pc.inventory.InventoryManager;

public class DriftSyncManager {
    private final Log log = LogFactory.getLog(DriftSyncManager.class);
    private DriftServerService driftServer;
    private DriftManager driftMgr;
    private InventoryManager inventoryMgr;
    private File dataDir;

    public void setDriftServer(DriftServerService driftServer) {
        this.driftServer = driftServer;
    }

    public void setDriftManager(DriftManager driftManager) {
        this.driftMgr = driftManager;
    }

    public void setInventoryManager(InventoryManager inventoryManager) {
        this.inventoryMgr = inventoryManager;
    }

    public void setDataDirectory(File dataDirectory) {
        this.dataDir = dataDirectory;
    }

    public void syncWithServer(Set<Integer> resourceIds) {
        DriftSynchronizerFactory synchronizerFactory = new DriftSynchronizerFactory();
        DriftSynchronizer synchronizer = this.isStartUpSync() ? synchronizerFactory.getStartUpSynchronizer(this.inventoryMgr, this.dataDir) : synchronizerFactory.getRuntimeSynchronizer(this.driftMgr);
        this.syncDriftDefinitions(synchronizer, resourceIds);
        this.syncContent(synchronizer);
    }

    private void syncDriftDefinitions(DriftSynchronizer synchronizer, Set<Integer> resourceIds) {
        this.log.info((Object)"Starting server sync for drift definitions...");
        long startTime = System.currentTimeMillis();
        Map driftDefs = this.driftServer.getDriftDefinitions(resourceIds);
        DriftDefinitionComparator comparator = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.BOTH_BASE_INFO_AND_DIRECTORY_SPECIFICATIONS);
        int totalDeleted = 0;
        int totalAdded = 0;
        for (Integer resourceId : driftDefs.keySet()) {
            TreeSet<DriftDefinition> driftDefinitionsOnServer = new TreeSet<DriftDefinition>((Comparator<DriftDefinition>)comparator);
            driftDefinitionsOnServer.addAll((Collection)driftDefs.get(resourceId));
            List<DriftDefinition> deletedDefs = synchronizer.getDeletedDefinitions(resourceId, driftDefinitionsOnServer);
            totalDeleted += deletedDefs.size();
            synchronizer.purgeFromLocalInventory(resourceId, deletedDefs);
            List<DriftDefinition> addedDefs = synchronizer.getAddedDefinitions(resourceId, driftDefinitionsOnServer);
            totalAdded += addedDefs.size();
            synchronizer.addToLocalInventory(resourceId, addedDefs);
        }
        long endTime = System.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Finished server sync for drift definitions. " + totalAdded + " added and " + totalDeleted + " deleted in " + (endTime - startTime) + " ms"));
        }
    }

    private void syncContent(DriftSynchronizer synchronizer) {
        this.log.info((Object)"Starting drift content sync...");
        long startTime = System.currentTimeMillis();
        synchronizer.syncChangeSetContent();
        long endTime = System.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Finished drift content sync in " + (endTime - startTime) + " ms"));
        }
    }

    private boolean isStartUpSync() {
        return this.driftMgr == null || !this.driftMgr.isInitialized();
    }
}

