/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift.sync;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.pc.drift.sync.DriftSynchronizer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.util.file.FileUtil;

class StartupSynchronizer
implements DriftSynchronizer {
    private final Log log = LogFactory.getLog(StartupSynchronizer.class);
    private InventoryManager inventoryMgr;
    private File snapshotsDir;

    public StartupSynchronizer(InventoryManager inventoryManager, File dataDirectory) {
        this.inventoryMgr = inventoryManager;
        this.snapshotsDir = new File(dataDirectory, "changesets");
    }

    @Override
    public List<DriftDefinition> getDeletedDefinitions(int resourceId, Set<DriftDefinition> definitionsFromServer) {
        this.log.debug((Object)("Checking for drift definitions that need to be deleted for resource id " + resourceId));
        LinkedList<DriftDefinition> deleted = new LinkedList<DriftDefinition>();
        ResourceContainer container = this.inventoryMgr.getResourceContainer(resourceId);
        for (DriftDefinition c : container.getDriftDefinitions()) {
            if (definitionsFromServer.contains(c)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Detected stale drift definition that needs to be purged - " + this.toString(resourceId, c)));
            }
            deleted.add(c);
        }
        return deleted;
    }

    @Override
    public void purgeFromLocalInventory(int resourceId, List<DriftDefinition> definitions) {
        this.log.debug((Object)("Preparing to purge from local inventory drift definitions that have been deleted on the server for resource id " + resourceId));
        ResourceContainer container = this.inventoryMgr.getResourceContainer(resourceId);
        File resourceSnapshotsDir = new File(this.snapshotsDir, Integer.toString(resourceId));
        for (DriftDefinition c : definitions) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Purging " + this.toString(resourceId, c) + " from local inventory"));
            }
            container.removeDriftDefinition(c);
            File snapshotDir = new File(resourceSnapshotsDir, c.getName());
            if (!snapshotDir.exists()) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Puring snapshot directory " + snapshotDir.getPath()));
            }
            FileUtil.purge((File)snapshotDir, (boolean)true);
        }
    }

    @Override
    public List<DriftDefinition> getAddedDefinitions(int resourceId, Set<DriftDefinition> definitionsFromServer) {
        this.log.debug((Object)("Checking for drift definitions that need to be added for resource id " + resourceId));
        ResourceContainer container = this.inventoryMgr.getResourceContainer(resourceId);
        LinkedList<DriftDefinition> added = new LinkedList<DriftDefinition>();
        for (DriftDefinition c : definitionsFromServer) {
            if (container.containsDriftDefinition(c)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Detected new drift definition that needs to be added to local inventory - " + this.toString(resourceId, c)));
            }
            added.add(c);
        }
        return added;
    }

    @Override
    public void addToLocalInventory(int resourceId, List<DriftDefinition> definitions) {
        this.log.debug((Object)("Adding drift definitions to local inventory for resource id " + resourceId));
        ResourceContainer container = this.inventoryMgr.getResourceContainer(resourceId);
        for (DriftDefinition c : definitions) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding " + this.toString(resourceId, c) + " to local inventory"));
            }
            container.addDriftDefinition(c);
        }
    }

    @Override
    public void syncChangeSetContent() {
    }

    private String toString(int rid, DriftDefinition c) {
        return "DriftDefinition[id: " + c.getId() + ", name: " + c.getName() + ", resourceId: " + rid + "]";
    }
}

