/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.util.exception.ThrowableUtil;

public class AvailabilityExecutor
implements Runnable,
Callable<AvailabilityReport> {
    static final int GET_AVAILABILITY_TIMEOUT;
    private static final Random RANDOM;
    private final Log log = LogFactory.getLog(AvailabilityExecutor.class);
    private InventoryManager inventoryManager;
    private AtomicBoolean sendChangesOnlyReport;
    private final Object lock = new Object();
    private int scanHistorySize = 1;
    private LinkedList<Scan> scanHistory = new LinkedList();

    public AvailabilityExecutor(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
        this.sendChangesOnlyReport = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.lock;
            synchronized (object) {
                AvailabilityReport report = this.call();
                this.inventoryManager.handleReport(report);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Availability report collection failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AvailabilityReport call() throws Exception {
        AvailabilityReport availabilityReport;
        Object object = this.lock;
        synchronized (object) {
            Scan scan;
            long start;
            block15: {
                if (this.inventoryManager.getPlatform().getInventoryStatus() != InventoryStatus.COMMITTED) {
                    return null;
                }
                boolean changesOnly = this.sendChangesOnlyReport.get();
                availabilityReport = new AvailabilityReport(changesOnly, this.inventoryManager.getAgent().getName());
                if (!changesOnly) {
                    this.sendChangesOnlyReportNextTime();
                }
                start = System.currentTimeMillis();
                scan = new Scan(start, !changesOnly);
                this.log.info((Object)("Scan Starting: " + new Date(start)));
                if (this.log.isDebugEnabled()) {
                    // empty if block
                }
                try {
                    this.checkInventory(this.inventoryManager.getPlatform(), availabilityReport, AvailabilityType.UP, false, scan);
                }
                catch (RuntimeException e) {
                    if (!Thread.interrupted()) break block15;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Exception occurred during availability check, but this thread has been interrupted, so most likely the plugin container is shutting down: " + e));
                    }
                    return availabilityReport;
                }
            }
            scan.setEndTime(System.currentTimeMillis());
            this.log.info((Object)("Scan Ended   : " + new Date(scan.getEndTime()) + " : " + scan.toString()));
            if (this.log.isDebugEnabled()) {
                // empty if block
            }
            this.addScanHistory(scan);
            if (this.log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ObjectOutputStream oos = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(availabilityReport);
                    this.log.debug((Object)("Built availability report for [" + availabilityReport.getResourceAvailability().size() + "] resources with a size of [" + baos.size() + "] bytes in [" + (end - start) + "]ms"));
                }
                finally {
                    if (null != oos) {
                        oos.close();
                    }
                }
            }
        }
        return availabilityReport;
    }

    protected void checkInventory(Resource resource, AvailabilityReport availabilityReport, AvailabilityType parentAvailType, boolean isForced, Scan scan) {
        boolean availChanged;
        AvailabilityType current;
        AvailabilityFacet resourceComponent;
        if (resource.getId() == 0 || resource.getInventoryStatus() != InventoryStatus.COMMITTED) {
            return;
        }
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(resource);
        if (resourceContainer == null || resourceContainer.getSynchronizationState() != ResourceContainer.SynchronizationState.SYNCHRONIZED) {
            return;
        }
        try {
            resourceComponent = resourceContainer.createResourceComponentProxy(AvailabilityFacet.class, FacetLockType.NONE, GET_AVAILABILITY_TIMEOUT, true, false);
        }
        catch (PluginContainerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Could not create resource component proxy for " + resource + "."), (Throwable)e);
            }
            return;
        }
        ++scan.numResources;
        boolean checkAvail = false;
        boolean deferToParent = false;
        Long availabilityScheduleTime = resourceContainer.getAvailabilityScheduleTime();
        MeasurementScheduleRequest availScheduleRequest = resourceContainer.getAvailabilitySchedule();
        if (null == availabilityScheduleTime || isForced) {
            if (null == availScheduleRequest) {
                checkAvail = true;
            } else if (availScheduleRequest.isEnabled()) {
                int interval = (int)availScheduleRequest.getInterval();
                availabilityScheduleTime = scan.startTime + (long)RANDOM.nextInt(interval + 1);
                resourceContainer.setAvailabilityScheduleTime(availabilityScheduleTime);
                ++scan.numScheduledRandomly;
            } else {
                deferToParent = true;
            }
        } else {
            boolean bl = checkAvail = scan.startTime >= availabilityScheduleTime;
            if (checkAvail) {
                long interval = availScheduleRequest.getInterval();
                resourceContainer.setAvailabilityScheduleTime(scan.startTime + interval);
                ++scan.numPushedByInterval;
            }
        }
        Availability previous = this.inventoryManager.getAvailabilityIfKnown(resource);
        AvailabilityType availabilityType = current = null == previous ? AvailabilityType.UNKNOWN : previous.getAvailabilityType();
        if (deferToParent || AvailabilityType.DOWN == parentAvailType) {
            current = parentAvailType;
            ++scan.numDeferToParent;
        } else {
            if (!checkAvail && (isForced || scan.isFull && null == previous)) {
                checkAvail = true;
            }
            if (checkAvail) {
                block28: {
                    current = AvailabilityType.UNKNOWN;
                    try {
                        ++scan.numGetAvailabilityCalls;
                        if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                            current = this.safeGetAvailability(resourceComponent);
                        } else {
                            this.inventoryManager.activateResource(resource, resourceContainer, false);
                            if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                                current = this.safeGetAvailability(resourceComponent);
                            }
                        }
                    }
                    catch (Throwable t) {
                        ResourceError resourceError = new ResourceError(resource, ResourceErrorType.AVAILABILITY_CHECK, t.getLocalizedMessage(), ThrowableUtil.getStackAsString((Throwable)t), System.currentTimeMillis());
                        this.inventoryManager.sendResourceErrorToServer(resourceError);
                        if (!this.log.isDebugEnabled()) break block28;
                        if (t instanceof TimeoutException) {
                            this.log.debug((Object)("Failed to collect availability on " + resource + " (call timed out)"));
                        }
                        this.log.debug((Object)("Failed to collect availability on " + resource), t);
                    }
                }
                if (AvailabilityType.UNKNOWN == current) {
                    current = AvailabilityType.DOWN;
                }
            }
        }
        boolean bl = availChanged = null != current && AvailabilityType.UNKNOWN != current && (null == previous || current != previous.getAvailabilityType());
        if (availChanged || scan.isFull) {
            Availability availability;
            if (availChanged) {
                ++scan.numAvailabilityChanges;
                availability = this.inventoryManager.updateAvailability(resource, current);
                if (!isForced && AvailabilityType.UP == current) {
                    isForced = true;
                }
            } else {
                availability = new Availability(resource, current);
            }
            availabilityReport.addAvailability(availability);
        }
        for (Resource child : this.inventoryManager.getContainerChildren(resource, resourceContainer)) {
            this.checkInventory(child, availabilityReport, current, isForced, scan);
        }
    }

    private AvailabilityType safeGetAvailability(AvailabilityFacet component) {
        AvailabilityType availType = component.getAvailability();
        switch (availType) {
            case UP: {
                return AvailabilityType.UP;
            }
            case DOWN: {
                return AvailabilityType.DOWN;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ResourceComponent " + component + " getAvailability() returned " + availType + ". This is invalid and is being replaced with DOWN."));
        }
        return AvailabilityType.DOWN;
    }

    public void sendFullReportNextTime() {
        this.sendChangesOnlyReport.set(false);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("\nFull report requested by: " + AvailabilityExecutor.getSmallStackTrace(new Throwable())));
        }
    }

    private static String getSmallStackTrace(Throwable t) {
        StringBuilder smallStack = new StringBuilder();
        StackTraceElement[] stack = null == t ? new Exception().getStackTrace() : t.getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            if (!ste.getClassName().startsWith("org.rhq")) continue;
            smallStack.append(ste.toString());
            smallStack.append("\n");
        }
        return smallStack.toString();
    }

    public void sendChangesOnlyReportNextTime() {
        this.sendChangesOnlyReport.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanHistory(Scan scan) {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            if (this.scanHistory.size() == this.scanHistorySize) {
                this.scanHistory.removeLast();
            }
            this.scanHistory.push(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Scan> getScanHistory() {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            ArrayList<Scan> result = new ArrayList<Scan>(this.scanHistory.size());
            result.addAll(this.scanHistory);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scan getMostRecentScanHistory() {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            return this.scanHistory.isEmpty() ? null : this.scanHistory.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScanHistorySize(int scanHistorySize) {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            if (scanHistorySize < 1) {
                return;
            }
            while (this.scanHistory.size() > scanHistorySize) {
                this.scanHistory.removeLast();
            }
            this.scanHistorySize = scanHistorySize;
        }
    }

    static {
        int timeout;
        RANDOM = new Random();
        try {
            timeout = Integer.parseInt(System.getProperty("rhq.agent.plugins.availability-scan.timeout", "5000"));
        }
        catch (Throwable t) {
            timeout = 5000;
        }
        GET_AVAILABILITY_TIMEOUT = timeout;
    }

    public static class Scan {
        private long startTime;
        private long endTime;
        private long runtime;
        private boolean isFull = false;
        private boolean isForced = false;
        int numResources = 0;
        int numGetAvailabilityCalls = 0;
        int numScheduledRandomly = 0;
        int numPushedByInterval = 0;
        int numAvailabilityChanges = 0;
        int numDeferToParent = 0;

        public Scan(long startTime, boolean isFull) {
            this.startTime = startTime;
            this.isFull = isFull;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
            this.runtime = endTime - this.startTime;
        }

        public long getRuntime() {
            return this.runtime;
        }

        public boolean isFull() {
            return this.isFull;
        }

        public boolean isForced() {
            return this.isForced;
        }

        public void setForced(boolean isForced) {
            this.isForced = isForced;
        }

        public int getNumResources() {
            return this.numResources;
        }

        public int getNumGetAvailabilityCalls() {
            return this.numGetAvailabilityCalls;
        }

        public int getNumScheduledRandomly() {
            return this.numScheduledRandomly;
        }

        public int getNumPushedByInterval() {
            return this.numPushedByInterval;
        }

        public int getNumAvailabilityChanges() {
            return this.numAvailabilityChanges;
        }

        public int getNumDeferToParent() {
            return this.numDeferToParent;
        }

        public String toString() {
            return "Scan [startTime=" + this.startTime + ", endTime=" + this.endTime + ", runtime=" + this.runtime + ", isFull=" + this.isFull + ", isForced=" + this.isForced + ", numResources=" + this.numResources + ", numGetAvailabilityCalls=" + this.numGetAvailabilityCalls + ", numScheduledRandomly=" + this.numScheduledRandomly + ", numPushedByInterval=" + this.numPushedByInterval + ", numAvailabilityChanges=" + this.numAvailabilityChanges + ", numDeferToParent=" + this.numDeferToParent + "]";
        }
    }
}

