/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.operation;

import java.util.EnumSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.agent.operation.CancelResults;
import org.rhq.core.clientapi.agent.operation.OperationAgentService;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.operation.OperationInvocation;
import org.rhq.core.pc.operation.OperationThreadPoolGateway;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.util.exception.WrappedRemotingException;

public class OperationManager
extends AgentService
implements OperationAgentService,
ContainerService {
    private static final String SENDER_THREAD_POOL_NAME = "OperationManager.invoker";
    private final Log log = LogFactory.getLog(OperationManager.class);
    private PluginContainerConfiguration configuration;
    private Timer timer;
    private OperationThreadPoolGateway operationGateway;

    public OperationManager() {
        super(OperationAgentService.class);
    }

    @Override
    public void initialize() {
        this.timer = new Timer("OperationManager.invoker.timeout-timer");
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(10000);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(SENDER_THREAD_POOL_NAME, true);
        int maxPoolSize = this.configuration.getOperationInvokerThreadPoolSize();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(maxPoolSize, maxPoolSize, 1000L, TimeUnit.MILLISECONDS, queue, threadFactory);
        this.operationGateway = new OperationThreadPoolGateway(threadPool);
    }

    @Override
    public void shutdown() {
        this.timer.cancel();
        this.operationGateway.shutdown();
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void invokeOperation(@NotNull String jobId, int resourceId, @NotNull String operationName, @Nullable Configuration parameterConfig) throws PluginContainerException {
        this.invokeOperation(jobId, resourceId, operationName, parameterConfig, this.getOperationServerService());
    }

    protected void invokeOperation(String jobId, int resourceId, String operationName, Configuration parameterConfig, OperationServerService operationServerService) throws PluginContainerException {
        try {
            final OperationInvocation[] theJob = new OperationInvocation[1];
            long invocationTime = System.currentTimeMillis();
            OperationDefinition operationDefinition = this.getOperationDefinition(resourceId, operationName);
            if (operationDefinition != null && operationDefinition.getParametersConfigurationDefinition() != null && parameterConfig != null) {
                ConfigurationUtility.normalizeConfiguration((Configuration)parameterConfig, (ConfigurationDefinition)operationDefinition.getParametersConfigurationDefinition());
            }
            long operationTimeout = this.getOperationTimeout(operationDefinition, parameterConfig);
            long facetMethodTimeout = operationTimeout + 10000L;
            OperationFacet operationComponent = this.getOperationFacet(resourceId, facetMethodTimeout);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (theJob[0] != null) {
                        theJob[0].markAsTimedOut();
                    }
                }
            };
            this.timer.schedule(timerTask, operationTimeout);
            theJob[0] = new OperationInvocation(resourceId, invocationTime, timerTask, parameterConfig, jobId, operationName, operationComponent, operationServerService, this.operationGateway, operationDefinition);
            this.operationGateway.submit(theJob[0]);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to submit operation invocation request", (Throwable)e);
            throw new PluginContainerException("Failed to submit invocation request. resource=[" + resourceId + "], operation=[" + operationName + "], jobId=[" + jobId + "]", (Throwable)new WrappedRemotingException((Throwable)e));
        }
    }

    public CancelResults cancelOperation(String jobId) {
        OperationInvocation operation = this.operationGateway.getOperationInvocation(jobId);
        if (operation == null) {
            return new CancelResults(CancelResults.InterruptedState.FINISHED);
        }
        EnumSet<OperationInvocation.Status> interruptedStatus = operation.markAsCanceled();
        if (interruptedStatus.contains((Object)OperationInvocation.Status.FINISHED)) {
            return new CancelResults(CancelResults.InterruptedState.FINISHED);
        }
        if (interruptedStatus.contains((Object)OperationInvocation.Status.QUEUED)) {
            return new CancelResults(CancelResults.InterruptedState.QUEUED);
        }
        if (interruptedStatus.contains((Object)OperationInvocation.Status.RUNNING)) {
            return new CancelResults(CancelResults.InterruptedState.RUNNING);
        }
        return new CancelResults(CancelResults.InterruptedState.UNKNOWN);
    }

    protected OperationFacet getOperationFacet(int resourceId, long facetMethodTimeout) throws PluginContainerException {
        return ComponentUtil.getComponent(resourceId, OperationFacet.class, FacetLockType.WRITE, facetMethodTimeout, false, false);
    }

    protected ResourceType getResourceType(int resourceId) throws PluginContainerException {
        return ComponentUtil.getResourceType(resourceId);
    }

    private long getOperationTimeout(OperationDefinition operationDefinition, Configuration paramConfig) throws PluginContainerException {
        PropertySimple timeoutProperty;
        if (paramConfig != null && (timeoutProperty = paramConfig.getSimple("rhq.timeout")) != null) {
            try {
                paramConfig.remove(timeoutProperty.getName());
                Long timeout = timeoutProperty.getLongValue();
                if (timeout != null) {
                    return timeout * 1000L;
                }
            }
            catch (Exception e) {
                throw new PluginContainerException("The timeout specified in the configuration was invalid: " + timeoutProperty);
            }
        }
        if (operationDefinition != null && operationDefinition.getTimeout() != null) {
            return operationDefinition.getTimeout().longValue() * 1000L;
        }
        return this.configuration.getOperationInvocationTimeout() * 1000L;
    }

    @Nullable
    private OperationDefinition getOperationDefinition(int resourceId, String operationName) throws PluginContainerException {
        ResourceType resourceType = this.getResourceType(resourceId);
        Set operationDefinitions = resourceType.getOperationDefinitions();
        if (operationDefinitions != null) {
            for (OperationDefinition operationDefinition : operationDefinitions) {
                if (!operationDefinition.getName().equals(operationName)) continue;
                return operationDefinition;
            }
        }
        return null;
    }

    private OperationServerService getOperationServerService() {
        if (this.configuration.getServerServices() != null) {
            return this.configuration.getServerServices().getOperationServerService();
        }
        return null;
    }
}

