/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;

public class PluginDescriptorLoader {
    private final Log log = LogFactory.getLog(PluginDescriptorLoader.class);
    private final URL pluginJarUrl;
    private final ClassLoader pluginClassLoader;

    public PluginDescriptorLoader(URL pluginJarUrl, ClassLoader pluginClassLoader) throws PluginContainerException {
        this.pluginJarUrl = pluginJarUrl;
        this.pluginClassLoader = pluginClassLoader;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created " + this.toString()));
        }
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public PluginDescriptor loadPluginDescriptor() throws PluginContainerException {
        return AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)this.pluginJarUrl);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [pluginJarUrl=" + this.pluginJarUrl + ", pluginClassLoader=" + this.pluginClassLoader + "]";
    }
}

