/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.parser.sax;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxJBossXBParser
implements JBossXBParser {
    private static final Logger log = Logger.getLogger((Class)SaxJBossXBParser.class);
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private final XMLReader reader;
    private JBossXBParser.ContentHandler contentHandler;
    private DelegatingContentHandler delegateHandler;
    private boolean trace;

    private static void enableXInclude() {
        try {
            Class<?> clazz = saxFactory.getClass();
            Method method = clazz.getMethod("setXIncludeAware", Boolean.TYPE);
            method.invoke((Object)saxFactory, Boolean.TRUE);
        }
        catch (Exception e) {
            log.trace((Object)"Not setting XIncludeAware", (Throwable)e);
        }
    }

    public SaxJBossXBParser() throws JBossXBException {
        SAXParser parser;
        try {
            parser = saxFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to create a new SAX parser", e);
        }
        try {
            this.reader = parser.getXMLReader();
        }
        catch (SAXException e1) {
            throw new JBossXBRuntimeException("Failed to get parser's XMLReader", e1);
        }
        this.delegateHandler = new DelegatingContentHandler();
        this.reader.setContentHandler(this.delegateHandler);
        this.reader.setErrorHandler(MetaDataErrorHandler.INSTANCE);
        this.reader.setEntityResolver((EntityResolver)new JBossEntityResolver());
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.reader.setEntityResolver(entityResolver);
    }

    public void setProperty(String name, Object value) {
        try {
            this.reader.setProperty(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to set property on the XML reader", e);
        }
    }

    public void setFeature(String name, boolean value) {
        try {
            this.reader.setFeature(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to set feature on the XMLReader", e);
        }
    }

    public void parse(String systemId, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        this.trace = log.isTraceEnabled();
        try {
            this.reader.parse(systemId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JBossXBException("Failed to parse source: " + this.getLocationAsString(systemId), e);
        }
    }

    public void parse(InputStream is, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        this.trace = log.isTraceEnabled();
        try {
            this.reader.parse(new InputSource(is));
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
        }
    }

    public void parse(Reader reader, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        this.trace = log.isTraceEnabled();
        try {
            this.reader.parse(new InputSource(reader));
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
        }
    }

    public String getLocationAsString(String fileName) {
        Locator locator = this.delegateHandler.getDocumentLocator();
        if (locator == null) {
            return fileName;
        }
        JBossStringBuilder buffer = new JBossStringBuilder();
        String id = locator.getSystemId();
        if (id == null) {
            id = locator.getPublicId();
        }
        buffer.append(id).append('@');
        buffer.append(locator.getLineNumber());
        buffer.append(',');
        buffer.append(locator.getColumnNumber());
        return buffer.toString();
    }

    static {
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        SaxJBossXBParser.enableXInclude();
    }

    private static final class MetaDataErrorHandler
    implements ErrorHandler {
        public static final ErrorHandler INSTANCE = new MetaDataErrorHandler();

        private MetaDataErrorHandler() {
        }

        public void warning(SAXParseException exception) {
            log.warn((Object)this.formatMessage(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public String formatMessage(SAXParseException exception) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(exception.getMessage()).append(" @ ");
            String location = exception.getPublicId();
            if (location != null) {
                buffer.append(location);
            } else {
                location = exception.getSystemId();
                if (location != null) {
                    buffer.append(location);
                } else {
                    buffer.append("*unknown*");
                }
            }
            buffer.append('[');
            buffer.append(exception.getLineNumber()).append(',');
            buffer.append(exception.getColumnNumber()).append(']');
            return buffer.toString();
        }
    }

    private final class DelegatingContentHandler
    implements ContentHandler {
        Locator locator;

        private DelegatingContentHandler() {
        }

        public void endDocument() {
        }

        public void startDocument() {
        }

        public void characters(char[] ch, int start, int length) {
            SaxJBossXBParser.this.contentHandler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void endPrefixMapping(String prefix) {
            SaxJBossXBParser.this.contentHandler.endPrefixMapping(prefix);
        }

        public void skippedEntity(String name) {
        }

        public Locator getDocumentLocator() {
            return this.locator;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void processingInstruction(String target, String data) {
            SaxJBossXBParser.this.contentHandler.processingInstruction(target, data);
        }

        public void startPrefixMapping(String prefix, String uri) {
            SaxJBossXBParser.this.contentHandler.startPrefixMapping(prefix, uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endElement(String namespaceURI, String localName, String qName) {
            String name = null;
            if (SaxJBossXBParser.this.trace) {
                name = localName.length() == 0 ? qName : namespaceURI + ':' + localName;
                log.trace((Object)("Enter endElement " + name));
            }
            try {
                SaxJBossXBParser.this.contentHandler.endElement(namespaceURI, localName, qName);
            }
            finally {
                if (SaxJBossXBParser.this.trace) {
                    log.trace((Object)("Exit endElement  " + name));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String name = null;
            if (SaxJBossXBParser.this.trace) {
                name = localName.length() == 0 ? qName : namespaceURI + ':' + localName;
                log.trace((Object)("Enter startElement " + name));
            }
            try {
                SaxJBossXBParser.this.contentHandler.startElement(namespaceURI, localName, qName, atts, null);
            }
            finally {
                if (SaxJBossXBParser.this.trace) {
                    log.trace((Object)("Exit startElement  " + name));
                }
            }
        }
    }
}

