/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.yum;

import java.util.ArrayList;
import java.util.List;

class Summary {
    int added = 0;
    int updated = 0;
    int deleted = 0;
    long started = 0L;
    long ended = 0L;
    Object context;
    List<String> errors = new ArrayList<String>();

    Summary(Object context) {
        this.context = context;
    }

    void markStarted() {
        this.started = System.currentTimeMillis();
    }

    void markEnded() {
        this.ended = System.currentTimeMillis();
    }

    public String toString() {
        boolean failed = this.errors.size() > 0;
        StringBuilder sb = new StringBuilder();
        sb.append("Synchronization with yum repo - ");
        sb.append(failed ? "FAILED" : "SUCCEEDED");
        sb.append("\nLocation: " + this.context);
        sb.append("\nDuration: " + (this.ended - this.started) + " (ms)");
        sb.append("\nPackages:");
        sb.append("\n\tAdded: " + this.added);
        sb.append("\n\tUpdated: " + this.updated);
        sb.append("\n\tDeleted: " + this.deleted);
        sb.append("\n\tErrors: " + this.errors.size());
        for (String s : this.errors) {
            sb.append("\n\t\t");
            sb.append(s);
        }
        return sb.toString();
    }
}

