/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rhq.core.db.setup.Data;
import org.rhq.core.db.setup.DataSet;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlDataSet
extends DataSet {
    private Iterator m_iterator;
    private List m_listCurRow;

    protected XmlDataSet(Table table, Node nodeTable) {
        super(table.getName(), table.getDBSetup());
        ArrayList collRows = new ArrayList();
        NodeList listData = nodeTable.getChildNodes();
        for (int i = 0; i < listData.getLength(); ++i) {
            Node node = listData.item(i);
            if (!XmlDataSet.isDataSet(node)) continue;
            ArrayList<Data> listRow = new ArrayList<Data>();
            NamedNodeMap map = node.getAttributes();
            for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                listRow.add(new Data(map.item(iAttr)));
            }
            collRows.add(listRow);
        }
        this.m_iterator = collRows.iterator();
    }

    @Override
    protected int getNumberColumns() {
        return this.m_listCurRow == null ? 0 : this.m_listCurRow.size();
    }

    @Override
    protected Data getData(int columnIndex) {
        return (Data)this.m_listCurRow.get(columnIndex);
    }

    @Override
    protected boolean next() {
        boolean bResult = this.m_iterator.hasNext();
        this.m_listCurRow = bResult ? (List)this.m_iterator.next() : null;
        return bResult;
    }

    protected static boolean isDataSet(Node node) {
        String strTmp = node.getNodeName();
        return strTmp.equalsIgnoreCase("data");
    }
}

