/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.helpers.rtfilter.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.helpers.rtfilter.filter.RtFilterResponseWrapper;
import org.rhq.helpers.rtfilter.util.ServletUtility;

public class RtFilter
implements Filter {
    private static final String JAVA_IO_TMPDIR_SYSPROP = "java.io.tmpdir";
    private static final String JBOSS_HOME_DIR_SYSPROP = "jboss.home.dir";
    private static final String JBOSS_SERVER_LOG_DIR_SYSPROP = "jboss.server.log.dir";
    private static final String JBOSS_DOMAIN_LOG_DIR_SYSPROP = "jboss.domain.log.dir";
    private static final String CATALINA_HOME_SYSPROP = "catalina.home";
    private static final String TOMCAT_SERVER_LOG_SUBDIR = "logs";
    private static final String DEFAULT_LOG_FILE_PREFIX = "";
    private static final long DEFAULT_FLUSH_TIMEOUT = 60000L;
    private static final long DEFAULT_FLUSH_AFTER_LINES = 10L;
    private static final long DEFAULT_MAX_LOG_FILE_SIZE = 0x500000L;
    private static final boolean DEFAULT_CHOP_QUERY_STRING = true;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean initialized = false;
    private boolean fileDone = false;
    private long requestCount = 0L;
    private boolean chopUrl = true;
    private File logDirectory;
    private BufferedWriter writer;
    private Pattern dontLogPattern = null;
    private long timeBetweenFlushes = 60000L;
    private boolean matchOnUriOnly = true;
    private long flushAfterLines = 10L;
    private String logFilePrefix = "";
    private boolean flushingNeeded = false;
    private long t2;
    private File logFile;
    private long lastLogFileSize = 0L;
    private long maxLogFileSize = 0x500000L;
    private String contextName;
    private String myHostName;
    private String myCHostName;
    private final Object lock = new Object();
    private Properties vhostMappings = new Properties();
    private static final String HOST_TOKEN = "%HOST%";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        Object object;
        long t1 = 0L;
        HttpServletRequest hreq = (HttpServletRequest)req;
        RtFilterResponseWrapper hresp = new RtFilterResponseWrapper(resp);
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.initialized) {
                try {
                    t1 = System.currentTimeMillis();
                    ++this.requestCount;
                    if (this.requestCount > 1L && t1 > this.t2 + this.timeBetweenFlushes) {
                        this.flushingNeeded = true;
                    }
                }
                catch (Exception e) {
                    this.handleFatalError(e);
                }
            }
        }
        try {
            chain.doFilter(req, (ServletResponse)hresp);
            Object var12_10 = null;
            object = this.lock;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            Object object3 = this.lock;
            synchronized (object3) {
                if (this.initialized) {
                    try {
                        Matcher matcher;
                        this.t2 = System.currentTimeMillis();
                        int statusCode = hresp.getStatus();
                        if (statusCode < 200 || statusCode >= 400) {
                            return;
                        }
                        String uri = hreq.getRequestURI();
                        String url = RtFilter.getRequestURL(hreq);
                        if (this.dontLogPattern != null && (matcher = this.dontLogPattern.matcher(this.matchOnUriOnly ? uri : url)).matches()) {
                            return;
                        }
                        if (!this.fileDone) {
                            this.openFile(req.getServerName());
                        }
                        this.truncateLogFileIfMaxSizeExceeded();
                        this.writeLogEntry(req, hresp, uri, url, t1);
                    }
                    catch (Exception e) {
                        this.handleFatalError(e);
                    }
                }
            }
            throw throwable;
        }
        synchronized (object) {
            if (this.initialized) {
                try {
                    Matcher matcher;
                    this.t2 = System.currentTimeMillis();
                    int statusCode = hresp.getStatus();
                    if (statusCode < 200 || statusCode >= 400) {
                        return;
                    }
                    String uri = hreq.getRequestURI();
                    String url = RtFilter.getRequestURL(hreq);
                    if (this.dontLogPattern != null && (matcher = this.dontLogPattern.matcher(this.matchOnUriOnly ? uri : url)).matches()) {
                        return;
                    }
                    if (!this.fileDone) {
                        this.openFile(req.getServerName());
                    }
                    this.truncateLogFileIfMaxSizeExceeded();
                    this.writeLogEntry(req, hresp, uri, url, t1);
                }
                catch (Exception e) {
                    this.handleFatalError(e);
                }
            }
        }
    }

    private void openFile(String serverName) {
        String vhost = DEFAULT_LOG_FILE_PREFIX;
        boolean found = false;
        if ("localhost".equals(serverName) || "127.0.0.1".equals(serverName)) {
            vhost = DEFAULT_LOG_FILE_PREFIX;
            found = true;
        }
        if (!found && this.vhostMappings.containsKey(serverName)) {
            found = true;
            vhost = this.vhostMappings.getProperty(serverName);
            vhost = vhost == null || vhost.equals(DEFAULT_LOG_FILE_PREFIX) ? DEFAULT_LOG_FILE_PREFIX : vhost + "_";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Vhost determined from mapping >" + vhost + "<"));
            }
        }
        if (!found && this.vhostMappings.containsKey(HOST_TOKEN)) {
            vhost = this.vhostMappings.getProperty(HOST_TOKEN);
            if (this.myHostName.startsWith(serverName) || this.myCHostName.startsWith(serverName)) {
                vhost = vhost == null || vhost.equals(DEFAULT_LOG_FILE_PREFIX) ? DEFAULT_LOG_FILE_PREFIX : vhost + "_";
                found = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Vhost determined from %HOST% token >" + vhost + "<"));
                }
            }
        }
        if (!found) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                if (localHost.getHostName().equalsIgnoreCase(serverName) || localHost.getCanonicalHostName().equalsIgnoreCase(serverName) || localHost.getHostAddress().equals(serverName)) {
                    vhost = DEFAULT_LOG_FILE_PREFIX;
                    found = true;
                }
            }
            catch (Exception e) {
                found = false;
            }
        }
        if (!found) {
            vhost = serverName + "_";
        }
        String contextFileName = this.contextName.replace('/', '_');
        String logFileName = this.logFilePrefix + vhost + contextFileName + "_rt.log";
        this.logFile = new File(this.logDirectory, logFileName);
        this.log.info((Object)("-- Filter openFile: Writing response-time log for webapp with context root '" + this.contextName + "' to '" + this.logFile + "' (hashCode=" + this.hashCode() + ")..."));
        boolean append = true;
        try {
            this.openFileWriter(append);
            this.fileDone = true;
        }
        catch (Exception e) {
            this.initialized = false;
            this.log.warn((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.myHostName = InetAddress.getLocalHost().getHostName();
                this.myCHostName = InetAddress.getLocalHost().getCanonicalHostName();
                this.initializeParameters(filterConfig);
                ServletContext servletContext = filterConfig.getServletContext();
                this.contextName = ServletUtility.getContextRoot(servletContext);
                this.initialized = true;
                this.log.info((Object)("Initialized response-time filter for webapp with context root '" + this.contextName + "'."));
            }
        }
        catch (Exception e) {
            this.handleFatalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.log.info((Object)("-- Filter destroy: " + this.requestCount + " requests processed (hashCode=" + this.hashCode() + ")."));
            this.closeFileWriter();
            this.initialized = false;
        }
    }

    private void writeLogEntry(ServletRequest req, RtFilterResponseWrapper responseWrapper, String uri, String url, long t1) throws Exception {
        long duration = this.t2 - t1;
        if (duration < 0L) {
            this.log.error((Object)("Calculated response time for request to [" + url + "] (" + duration + " ms) is negative!"));
            return;
        }
        if (duration == 0L) {
            duration = 1L;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Request to [" + url + "] took " + duration + " ms"));
        }
        String remoteIp = req.getRemoteAddr();
        StringBuilder buf = new StringBuilder();
        buf.append(this.chopUrl ? uri : url).append(" ").append(this.t2).append(" ").append(duration).append(" ").append(responseWrapper.getStatus()).append(" ").append(remoteIp);
        this.rewindLogFileIfSizeDecreased();
        this.writer.append(buf);
        this.writer.newLine();
        if (this.flushingNeeded || this.requestCount % this.flushAfterLines == 0L) {
            this.writer.flush();
            this.flushingNeeded = false;
            this.lastLogFileSize = this.logFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeParameters(FilterConfig conf) throws UnavailableException {
        String vhostMappingFileString;
        String maxLogFileSizeString;
        String lines;
        String uriOnly;
        String flushTimeout;
        String dontLog;
        String logFilePrefixString;
        String logDirectoryPath;
        String chop = conf.getInitParameter("chopQueryString");
        if (chop != null) {
            this.chopUrl = Boolean.valueOf(chop.trim());
        }
        if ((logDirectoryPath = conf.getInitParameter("logDirectory")) != null) {
            this.logDirectory = new File(logDirectoryPath.trim());
        } else {
            File serverLogDir = null;
            String jbossHomeDir = System.getProperty(JBOSS_HOME_DIR_SYSPROP);
            if (jbossHomeDir != null) {
                this.log.debug((Object)"jboss.home.dir sysprop is set - assuming we are running inside JBoss AS.");
                String serverLogDirString = System.getProperty(JBOSS_SERVER_LOG_DIR_SYSPROP);
                if (serverLogDirString == null) {
                    serverLogDirString = System.getProperty(JBOSS_DOMAIN_LOG_DIR_SYSPROP);
                }
                if (serverLogDirString != null) {
                    serverLogDir = new File(serverLogDirString);
                }
            } else {
                String catalinaHome = System.getProperty(CATALINA_HOME_SYSPROP);
                if (catalinaHome != null) {
                    this.log.debug((Object)"catalina.home sysprop is set - assuming we are running inside Tomcat.");
                    serverLogDir = new File(catalinaHome, TOMCAT_SERVER_LOG_SUBDIR);
                }
            }
            if (serverLogDir != null) {
                this.logDirectory = new File(serverLogDir, "rt");
            } else {
                this.logDirectory = new File(System.getProperty(JAVA_IO_TMPDIR_SYSPROP), "rhq/rt");
                this.log.warn((Object)("The 'logDirectory' filter init param was not set. Also, the standard system properties were not set (jboss.server.log.dir, jboss.domain.log.dir, catalina.home); defaulting RT log directory to '" + this.logDirectory + "'."));
            }
        }
        if (this.logDirectory.exists()) {
            if (!this.logDirectory.isDirectory()) {
                throw new UnavailableException("Log directory '" + this.logDirectory + "' exists but is not a directory.");
            }
        } else {
            try {
                this.logDirectory.mkdirs();
            }
            catch (Exception e) {
                throw new UnavailableException("Unable to create log directory '" + this.logDirectory + "' - cause: " + e);
            }
            if (!this.logDirectory.exists()) {
                throw new UnavailableException("Unable to create log directory '" + this.logDirectory + "'.");
            }
        }
        if ((logFilePrefixString = conf.getInitParameter("logFilePrefix")) != null) {
            this.logFilePrefix = logFilePrefixString.trim();
        }
        if ((dontLog = conf.getInitParameter("dontLogRegEx")) != null) {
            this.dontLogPattern = Pattern.compile(dontLog.trim());
        }
        if ((flushTimeout = conf.getInitParameter("timeBetweenFlushesInSec")) != null) {
            try {
                this.timeBetweenFlushes = Long.parseLong(flushTimeout.trim()) * 1000L;
            }
            catch (NumberFormatException nfe) {
                this.timeBetweenFlushes = 60000L;
            }
        }
        if ((uriOnly = conf.getInitParameter("matchOnUriOnly")) != null) {
            this.matchOnUriOnly = Boolean.getBoolean(uriOnly.trim());
        }
        if ((lines = conf.getInitParameter("flushAfterLines")) != null) {
            try {
                this.flushAfterLines = Long.parseLong(lines.trim());
                if (this.flushAfterLines <= 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                this.log.error((Object)("Invalid 'flushAfterLines' init parameter: " + lines + " (value must be a positive integer) - using default."));
                this.flushAfterLines = 10L;
            }
        }
        if ((maxLogFileSizeString = conf.getInitParameter("maxLogFileSize")) != null) {
            try {
                this.maxLogFileSize = Long.parseLong(maxLogFileSizeString.trim());
                if (this.maxLogFileSize <= 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Invalid 'maxLogFileSize' init parameter: " + maxLogFileSizeString + " (value must be a positive integer) - using default."));
                this.maxLogFileSize = 0x500000L;
            }
        }
        if ((vhostMappingFileString = conf.getInitParameter("vHostMappingFile")) == null) return;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(vhostMappingFileString);
        if (stream != null) {
            this.vhostMappings.load(stream);
            Object var14_16 = null;
            if (stream == null) return;
            try {
                stream.close();
                return;
            }
            catch (Exception e2) {
                this.log.debug((Object)e2);
            }
            return;
            {
                catch (IOException e) {
                    this.log.warn((Object)("Can't read vhost mappings from " + vhostMappingFileString + " :" + e.getMessage()));
                    Object var14_17 = null;
                    if (stream == null) return;
                    try {
                        stream.close();
                        return;
                    }
                    catch (Exception e2) {
                        this.log.debug((Object)e2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    this.log.debug((Object)e2);
                }
                throw throwable;
            }
        }
        this.log.warn((Object)("Can't read vhost mappings from " + vhostMappingFileString));
    }

    private void openFileWriter(boolean append) throws Exception {
        if (!this.logFile.exists()) {
            boolean success;
            try {
                success = this.logFile.createNewFile();
            }
            catch (Exception e) {
                throw new Exception("Response time log '" + this.logFile + "' could not be created - cause: " + e);
            }
            if (!success) {
                throw new Exception("Response time log '" + this.logFile + "' could not be created.");
            }
        }
        if (!this.logFile.canWrite()) {
            throw new Exception("Response time log '" + this.logFile + "' is not writable.");
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(this.logFile, append));
        }
        catch (IOException e) {
            throw new Exception("Failed to open response time log '" + this.logFile + "' for writing - cause: " + e);
        }
        this.lastLogFileSize = this.logFile.length();
    }

    private void closeFileWriter() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.log.debug((Object)("Closed writer for response time log '" + this.logFile + "'."));
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to close writer for response time log '" + this.logFile + "'."));
            }
        }
    }

    private void truncateLogFileIfMaxSizeExceeded() throws Exception {
        if (this.logFile.length() > this.maxLogFileSize) {
            this.log.warn((Object)("Response time log '" + this.logFile + "' has exceeded maximum file size (" + this.maxLogFileSize + " bytes) - truncating it..."));
            this.closeFileWriter();
            boolean append = false;
            this.openFileWriter(append);
        }
    }

    private void rewindLogFileIfSizeDecreased() throws Exception {
        if (this.logFile.length() < this.lastLogFileSize) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Logfile " + this.logFile + " has been truncated (probably by RHQ Agent) - rewinding writer..."));
            }
            this.closeFileWriter();
            boolean append = true;
            this.openFileWriter(append);
        }
    }

    private static String getRequestURL(HttpServletRequest hreq) {
        String queryString = hreq.getQueryString();
        String url = hreq.getRequestURI();
        if (queryString != null) {
            url = url + "?" + queryString;
        }
        return url;
    }

    private void handleFatalError(Exception e) {
        this.initialized = false;
        this.log.fatal((Object)("RHQ response-time filter experienced an unrecoverable failure. Response-time collection is now disabled for context '" + this.contextName + "'."), (Throwable)e);
    }

    abstract class InitParams {
        public static final String CHOP_QUERY_STRING = "chopQueryString";
        public static final String LOG_DIRECTORY = "logDirectory";
        public static final String LOG_FILE_PREFIX = "logFilePrefix";
        public static final String DONT_LOG_REG_EX = "dontLogRegEx";
        public static final String TIME_BETWEEN_FLUSHES_IN_SEC = "timeBetweenFlushesInSec";
        public static final String MATCH_ON_URI_ONLY = "matchOnUriOnly";
        public static final String FLUSH_AFTER_LINES = "flushAfterLines";
        public static final String MAX_LOG_FILE_SIZE = "maxLogFileSize";
        public static final String VHOST_MAPPING_FILE = "vHostMappingFile";

        InitParams() {
        }
    }
}

