/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j;

import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.model.IUsesDublinCore;
import java.io.Serializable;

public class RssChannelImage
implements IUsesDublinCore,
Cloneable,
Serializable {
    private String imageTitle;
    private String imageUrl;
    private String imageLink;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private RssDublinCore dublinCore;

    public RssChannelImage() {
    }

    public RssChannelImage(String title, String url, String link) {
        this.imageTitle = title;
        this.imageUrl = url;
        this.imageLink = link;
    }

    public RssChannelImage(String title, String url, String link, int width, int height) {
        this.imageTitle = title;
        this.imageUrl = url;
        this.imageLink = link;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public void setImageTitle(String t) {
        this.imageTitle = t;
    }

    public String getImageTitle() {
        return this.imageTitle;
    }

    public void setImageUrl(String s) {
        this.imageUrl = s;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageLink(String l) {
        this.imageLink = l;
    }

    public String getImageLink() {
        return this.imageLink;
    }

    public void setImageWidth(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Image width cannot be negative");
        }
        this.imageWidth = i;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Image height cannot be negative");
        }
        this.imageHeight = i;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageDescription(String d) {
        if (this.dublinCore == null) {
            this.dublinCore = new RssDublinCore();
        }
        this.dublinCore.setDescription(d);
    }

    public String getImageDescription() {
        if (this.dublinCore != null) {
            return this.dublinCore.getDescription();
        }
        return null;
    }

    public void setDublinCore(RssDublinCore dc) {
        this.dublinCore = dc;
    }

    public RssDublinCore getDublinCore() {
        return this.dublinCore;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[title='" + this.imageTitle + "', url='" + this.imageUrl + "', link='" + this.imageLink);
        if (this.imageWidth > 0) {
            sb.append(" width: " + this.imageWidth);
        }
        if (this.imageHeight > 0) {
            sb.append(" height: " + this.imageHeight);
        }
        if (this.dublinCore != null) {
            sb.append(" dublinCore: " + this.dublinCore);
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int hc = this.imageTitle == null ? 0 : this.imageTitle.hashCode();
        hc = 31 * hc + (this.imageUrl == null ? 0 : this.imageUrl.hashCode());
        hc = 31 * hc + (this.imageLink == null ? 0 : this.imageLink.hashCode());
        hc = 31 * hc + this.imageWidth;
        hc = 31 * hc + this.imageHeight;
        hc = 31 * hc + (this.dublinCore == null ? 0 : this.dublinCore.hashCode());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RssChannelImage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.hashCode() == obj.hashCode();
    }

    public Object clone() {
        return this.clone();
    }
}

