/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.i18n;

import mazz.i18n.Msg;
import mazz.i18n.annotation.I18NMessage;
import mazz.i18n.annotation.I18NMessages;
import mazz.i18n.annotation.I18NResourceBundle;

@I18NResourceBundle(baseName="agent-setup", defaultLocale="en")
public interface AgentSetupInstructions {
    public static final Msg.BundleBaseName BASE_BUNDLE_NAME = new Msg.BundleBaseName("agent-setup");
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORT_PREF = "rhq.agent.server.transport";
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORT_DEFAULT = "servlet";
    @I18NMessages(value={@I18NMessage(value="RHQ Server Transport Protocol")})
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORT_PROMPT = "PromptCommand.setup.instruction.serveruri.transport.prompt";
    @I18NMessages(value={@I18NMessage(value="The transport used to send messages to the RHQ Server.\\n\\\nAcceptable values are either servlet or sslservlet. If you want this agent to\\n\\\ntalk to the server securely over an encrypted repo, use sslservlet.")})
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORT_HELP = "PromptCommand.setup.instruction.serveruri.transport.help";
    public static final String SETUP_INSTRUCTION_SERVERBINDADDR_PREF = "rhq.agent.server.bind-address";
    public static final String SETUP_INSTRUCTION_SERVERBINDADDR_DEFAULT = "127.0.0.1";
    @I18NMessages(value={@I18NMessage(value="RHQ Server Hostname or IP Address")})
    public static final String SETUP_INSTRUCTION_SERVERBINDADDR_PROMPT = "PromptCommand.setup.instruction.serveruri.bindaddr.prompt";
    @I18NMessages(value={@I18NMessage(value="The hostname or IP address the RHQ Server will bind to in order to\\n\\\nlisten for incoming messages from agents.")})
    public static final String SETUP_INSTRUCTION_SERVERBINDADDR_HELP = "PromptCommand.setup.instruction.serveruri.bindaddr.help";
    public static final String SETUP_INSTRUCTION_SERVERPORT_PREF = "rhq.agent.server.bind-port";
    public static final String SETUP_INSTRUCTION_SERVERPORT_DEFAULT = Integer.toString(7080);
    @I18NMessages(value={@I18NMessage(value="RHQ Server Port")})
    public static final String SETUP_INSTRUCTION_SERVERPORT_PROMPT = "PromptCommand.setup.instruction.serveruri.bindport.prompt";
    @I18NMessages(value={@I18NMessage(value="The port that the RHQ Server listens to for incoming messages from agents.")})
    public static final String SETUP_INSTRUCTION_SERVERPORT_HELP = "PromptCommand.setup.instruction.serveruri.bindport.help";
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORTPARAMS_PREF = "rhq.agent.server.transport-params";
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORTPARAMS_DEFAULT = "/jboss-remoting-servlet-invoker/ServerInvokerServlet";
    @I18NMessages(value={@I18NMessage(value="RHQ Server Transport Parameters")})
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORTPARAMS_PROMPT = "PromptCommand.setup.instruction.serveruri.transportparams.prompt";
    @I18NMessages(value={@I18NMessage(value="A set of transport parameters that is used to further configure\\n\\\nhow the agent connects to the server. Any value you provide here\\n\\\nwill overwrite (not augment) the current value.\\n\\\nSee the documentation for information on the format of this setting\\n\\\nand all the different values allowed for the specific transport being used.")})
    public static final String SETUP_INSTRUCTION_SERVERTRANSPORTPARAMS_HELP = "PromptCommand.setup.instruction.serveruri.transportparams.help";
    public static final String SETUP_INSTRUCTION_SERVERALIAS_PREF = "rhq.agent.server.alias";
    public static final String SETUP_INSTRUCTION_SERVERALIAS_DEFAULT = null;
    @I18NMessages(value={@I18NMessage(value="RHQ Server Alias")})
    public static final String SETUP_INSTRUCTION_SERVERALIAS_PROMPT = "PromptCommand.setup.instruction.serveralias.prompt";
    @I18NMessages(value={@I18NMessage(value="If the RHQ Server hostname or IP address was not set,\\n\\\nthis DNS alias name will be looked up and used as the RHQ Server host.\\n\\\nNot setting this preference will disable this DNS alias lookup feature")})
    public static final String SETUP_INSTRUCTION_SERVERALIAS_HELP = "PromptCommand.setup.instruction.serveralias.help";
    public static final String SETUP_INSTRUCTION_SERVERAUTODETECT_PREF = "rhq.agent.server-auto-detection";
    public static final String SETUP_INSTRUCTION_SERVERAUTODETECT_DEFAULT = Boolean.toString(false);
    @I18NMessages(value={@I18NMessage(value="Enable RHQ Server Auto-Detection?")})
    public static final String SETUP_INSTRUCTION_SERVERAUTODETECT_PROMPT = "PromptCommand.setup.instruction.serverautodetect.prompt";
    @I18NMessages(value={@I18NMessage(value="If true, the agent will attempt to auto-detect the RHQ Server\\n\\\ncoming online and going offline.  This is more efficient than\\n\\\nserver polling but it requires multicast traffic to be enabled on\\n\\\nyour network and also requires the multicast detector be enabled.")})
    public static final String SETUP_INSTRUCTION_SERVERAUTODETECT_HELP = "PromptCommand.setup.instruction.serverautodetect.help";
    public static final String SETUP_INSTRUCTION_SERVERPOLLING_PREF = "rhq.agent.client.server-polling-interval-msecs";
    public static final String SETUP_INSTRUCTION_SERVERPOLLING_DEFAULT = Long.toString(60000L);
    @I18NMessages(value={@I18NMessage(value="RHQ Server Polling Interval")})
    public static final String SETUP_INSTRUCTION_SERVERPOLLING_PROMPT = "PromptCommand.setup.instruction.serverpolling.prompt";
    @I18NMessages(value={@I18NMessage(value="If this value is larger than 0, it indicates the agent\\n\\\nshould periodically poll the RHQ Server to make sure it is still\\n\\\nup or (if it was down) see when it comes back up. The value is\\n\\\nthe number of milliseconds to wait in between polls.  If the\\n\\\nvalue is 0, server polling is disabled.  Server polling\\n\\\nis less efficient that the auto-detection mechanism,\\n\\\nbut server polling does not use multicasting, and thus might\\n\\\nbe the only way for the agent to detect the server.")})
    public static final String SETUP_INSTRUCTION_SERVERPOLLING_HELP = "PromptCommand.setup.instruction.serverpolling.help";
    public static final String SETUP_INSTRUCTION_AGENTDATADIR_PREF = "rhq.agent.data-directory";
    public static final String SETUP_INSTRUCTION_AGENTDATADIR_DEFAULT = "data";
    @I18NMessages(value={@I18NMessage(value="Data Directory")})
    public static final String SETUP_INSTRUCTION_AGENTDATADIR_PROMPT = "PromptCommand.setup.instruction.datadir.prompt";
    @I18NMessages(value={@I18NMessage(value="Directory location where the agent will persist its data.")})
    public static final String SETUP_INSTRUCTION_AGENTDATADIR_HELP = "PromptCommand.setup.instruction.datadir.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQSIZE_PREF = "rhq.agent.client.queue-size";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQSIZE_DEFAULT = Integer.toString(50000);
    @I18NMessages(value={@I18NMessage(value="Command Queue Size")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQSIZE_PROMPT = "PromptCommand.setup.instruction.sender.qsize.prompt";
    @I18NMessages(value={@I18NMessage(value="The maximum number of commands that can be queued for sending to the RHQ Server.\\n\\\nIf this is 0, then the queue is unbounded (be careful - setting this to 0\\n\\\ncould cause the agent to use up too much memory if, for some reason,\\n\\\ncommands are getting queued but are unable to be sent")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQSIZE_HELP = "PromptCommand.setup.instruction.sender.qsize.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXCONCURRENT_PREF = "rhq.agent.client.max-concurrent";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXCONCURRENT_DEFAULT = Integer.toString(5);
    @I18NMessages(value={@I18NMessage(value="Maximum Commands To Concurrently Send")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXCONCURRENT_PROMPT = "PromptCommand.setup.instruction.sender.maxconcurrent.prompt";
    @I18NMessages(value={@I18NMessage(value="The maximum number of commands that can be in the process\\n\\\nof being sent to the RHQ Server at any one time.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXCONCURRENT_HELP = "PromptCommand.setup.instruction.sender.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERTIMEOUT_PREF = "rhq.agent.client.command-timeout-msecs";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERTIMEOUT_DEFAULT = Long.toString(600000L);
    @I18NMessages(value={@I18NMessage(value="Command Send Timeout")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERTIMEOUT_PROMPT = "PromptCommand.setup.instruction.sender.timeout.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in milliseconds that the agent will wait\\n\\\nbefore aborting a command. This is the amount of time in\\n\\\nmilliseconds that the RHQ Server has in order to process commands.\\n\\\nThis value is only the default if a command has not specified\\n\\\nits own timeout.  A command can override this by setting its\\n\\\nown timeout in its command configuration, so this value may\\n\\\nnot be used for all commands that are sent. If this value is\\n\\\nless than or equal to 0, there will be no default timeout\\n\\\nand commands will therefore be allowed to take as long as they\\n\\\nneed (again, this is the default, individual commands may\\n\\\noverride this and set their own timeout).  While this infinite\\n\\\ntimeout default could conceivably cause a thread to hang\\n\\\nwaiting for a rogue command that never finishes, it also reduces\\n\\\nthe amount of short-lived threads created by the agent\\n\\\nand will increase throughput, dramatically in some cases.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERTIMEOUT_HELP = "PromptCommand.setup.instruction.sender.timeout.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERRETRYINTERVAL_PREF = "rhq.agent.client.retry-interval-msecs";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERRETRYINTERVAL_DEFAULT = Long.toString(15000L);
    @I18NMessages(value={@I18NMessage(value="Command Send Retry Interval")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERRETRYINTERVAL_PROMPT = "PromptCommand.setup.instruction.sender.retry.prompt";
    @I18NMessages(value={@I18NMessage(value="This is the minimum amount of time, in milliseconds, the agent\\n\\\nwill wait before trying to resend a guaranteed command\\n\\\nthat previously failed.  This is not a guarantee of when\\n\\\na command is retried - all that can be inferred is that a\\n\\\ncommand that fails to be sent will not be retried until at\\n\\\nleast this amount of time passes.\\n\\\nNote: if the agent is currently waiting in this retry pause\\n\\\nperiod, the agent will not be able to be shutdown until that\\n\\\nretry period is over. In other words, if the agent is asked\\n\\\nto shutdown, it will wait for those commands waiting in this\\n\\\nretry interval to wake up. This is to help ensure those\\n\\\ncommands are not lost.  Keep this time period short enough\\n\\\nto make agent shutdowns fairly responsive but long enough\\n\\\nto avoid spinning the agent with continuous resending of\\n\\\ncommands during periods of RHQ Server downtime. It is\\n\\\nrecommended to use auto-detection or server polling in order\\n\\\nto automatically stop the agent from continuously\\n\\\ntrying to retry commands during long periods of RHQ\\n\\\nServer downtime.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERRETRYINTERVAL_HELP = "PromptCommand.setup.instruction.sender.retry.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXRETRIES_PREF = "rhq.agent.client.max-retries";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXRETRIES_DEFAULT = Integer.toString(10);
    @I18NMessages(value={@I18NMessage(value="Command Send Max Retries")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXRETRIES_PROMPT = "PromptCommand.setup.instruction.sender.maxretries.prompt";
    @I18NMessages(value={@I18NMessage(value="If a guaranteed delivery message is sent, but the agent fails\\n\\\nto connect to the server and deliver the message, it will\\n\\\nalways be retried. However, if the error was something other\\n\\\nthan a 'cannot connect' error, the command will only be retried\\n\\\nthis amount of times before the command is dropped. When this\\n\\\nhappens, the guaranteed command will never be delivered. This\\n\\\nwill normally happen under very odd and rare circumstances.\\n\\\nAlso, this setting only effects asynchronous messages that are\\n\\\nsent with guaranteed delivery.  This setting has no effect\\n\\\non other messages.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERMAXRETRIES_HELP = "PromptCommand.setup.instruction.sender.maxretries.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSPOOLPARAMS_PREF = "rhq.agent.client.command-spool-file.params";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSPOOLPARAMS_DEFAULT = "10000000:75";
    @I18NMessages(value={@I18NMessage(value="Command Spool File Parameters")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSPOOLPARAMS_PROMPT = "PromptCommand.setup.instruction.sender.spoolfileparams.prompt";
    @I18NMessages(value={@I18NMessage(value="This defines the parameters for the command spool file.\\n\\\nThe spool file is where the agent persists commands that\\n\\\nare flagged for guaranteed delivery and need to be sent.\\n\\\nThe format is defined as 'max-file-size:purge-percentage'.\\n\\\nThe first number is the size, in bytes, of the maximum file\\n\\\nsize threshold.  If the spool file grows larger than this, a\\n\\\npurge will be triggered in order to shrink the file.\\n\\\nThe second number is the purge percentage which indicates how\\n\\\nlarge the file is allowed to be after a purge.  This is\\n\\\nspecified as a percentage of the first parameter - the max\\n\\\nfile size threshold.  For example, if the max file size is\\n\\\n100000 (i.e. 100KB) and the purge percentage is 90, then when\\n\\\nthe spool file grows larger than 100KB, a purge will be\\n\\\ntriggered and the file will be shrunk to no more than\\n\\\n90% of 100KB - which is 90KB.  In effect, 10KB will be freed\\n\\\nto allow room for new commands to be spooled.  When this\\n\\\noccurs, unused space is freed first and if that does not\\n\\\nfree up enough space, the oldest commands in the spool file\\n\\\nwill be sacrificed in order to make room for the newer\\n\\\ncommands.\\n\\\nThe maximum file size must be at least 10000 bytes.\\n\\\nThe purge percentage must be between 0 and 99.\\n\\\n")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSPOOLPARAMS_HELP = "PromptCommand.setup.instruction.sender.spoolfileparams.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERCOMPRESSSPOOL_PREF = "rhq.agent.client.command-spool-file.compressed";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERCOMPRESSSPOOL_DEFAULT = Boolean.toString(false);
    @I18NMessages(value={@I18NMessage(value="Compress the Spool File?")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERCOMPRESSSPOOL_PROMPT = "PromptCommand.setup.instruction.sender.compressspool.prompt";
    @I18NMessages(value={@I18NMessage(value="If this flag is true, the commands stored in the spool file\\n\\\nwill be compressed. This can potentially save about 30%-40% in\\n\\\ndisk space (give or take), however, it slows down the\\n\\\npersistence mechanism considerably. Recommended setting for\\n\\\nthis should be false unless something on the agent deployment\\n\\\nbox warrants disk-saving over persistence performance. The\\n\\\nperformance hit will only appear when unusual conditions occur,\\n\\\nsuch as shutting down while some guaranteed commands have not\\n\\\nbeen sent yet or if the RHQ Server is down. It will not affect\\n\\\nthe agent under normal conditions (while running with the RHQ\\n\\\nServer up and successfully communicating with the agent).\\n\\\nIn those unusual/rare conditions, having performance degradation\\n\\\nmay not be as important.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERCOMPRESSSPOOL_HELP = "PromptCommand.setup.instruction.sender.compressspool.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSENDTHROTTLING_PREF = "rhq.agent.client.send-throttling";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSENDTHROTTLING_DEFAULT = "100:1000";
    @I18NMessages(value={@I18NMessage(value="Send Throttling Parameters")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSENDTHROTTLING_PROMPT = "PromptCommand.setup.instruction.sender.sendthrottling.prompt";
    @I18NMessages(value={@I18NMessage(value="If this setting is defined, it will enable send throttling to\\n\\\noccur while sending commands to the server.  The format is\\n\\\ndefined as 'max-commands:quiet-period-milliseconds'\\n\\\nwhere the maximum commands defines the maximum number\\n\\\nof commands that will be sent before the start of a quiet\\n\\\nperiod.  The quiet period defines the number of milliseconds\\n\\\nin which no commands should be sent.  After this duration\\n\\\nexpires, commands can again be sent, up to the maximum defined.\\n\\\nNote that send throttling only affects those commands that\\n\\\nare throttle-able.  Some commands are sent as soon as\\n\\\npossible, regardless of the throttling settings.\\n\\\nTo disable send throttling, set this to its internal default.\\n\\\nThe maximum commands must be at least 1.\\n\\\nThe quiet period must be at least 100 milliseconds.\\n\\\n\\n\\\nThis affects sending commands synchronously and asynchronously.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERSENDTHROTTLING_HELP = "PromptCommand.setup.instruction.sender.sendthrottling.help";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQTHROTTLING_PREF = "rhq.agent.client.queue-throttling";
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQTHROTTLING_DEFAULT = "50:5000";
    @I18NMessages(value={@I18NMessage(value="Queue Throttling Parameters")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQTHROTTLING_PROMPT = "PromptCommand.setup.instruction.sender.qthrottling.prompt";
    @I18NMessages(value={@I18NMessage(value="If this setting is defined, it will enable queue throttling to\\n\\\noccur while sending commands to the server.  The format is\\n\\\ndefined as 'max-commands-per-burst:burst-period-milliseconds'\\n\\\nwhere the maximum commands per burst defines the maximum number\\n\\\nof commands that can be dequeued within a burst period.  The\\n\\\nburst period defines the number of milliseconds in which the\\n\\\ndefined maximum number of commands can be dequeued.  If more\\n\\\nthan the maximum number of commands are queued within this\\n\\\ntime period, they will wait until the next burst period starts\\n\\\nbefore being able to be dequeued.\\n\\\nThe maximum commands per burst must be at least 1.\\n\\\nThe burst period must be at least 100 milliseconds.\\n\\\n\\n\\\nThis does not affect sending commands synchronously.  It only\\n\\\neffects commands queued to be sent asynchronously.")})
    public static final String SETUP_INSTRUCTION_CLIENTSENDERQTHROTTLING_HELP = "PromptCommand.setup.instruction.sender.qthrottling.help";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTOR_PREF = "rhq.communications.multicast-detector.enabled";
    @I18NMessages(value={@I18NMessage(value="If true, a multicast detector will be started within the agent.\\n\\\nThis service will listen for new remote servers coming online\\n\\\ngoing offline.  This must be enabled if you enabled server auto-detection.\\n\\\nIf you enable this, your network must support multicast traffic.")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTOR_HELP = "PromptCommand.setup.instruction.multicastdetector.help";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORMCADDR_PREF = "rhq.communications.multicast-detector.multicast-address";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORMCADDR_DEFAULT = "224.16.16.16";
    @I18NMessages(value={@I18NMessage(value="Multicast Detector Multicast Address")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORMCADDR_PROMPT = "PromptCommand.setup.instruction.multicastdetector-mcaddr.prompt";
    @I18NMessages(value={@I18NMessage(value="The multicast address used to broadcast detection messages.\\n\\\nTo be more specific, it is the IP address of the multicast group\\n\\\nthe detector will join.")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORMCADDR_HELP = "PromptCommand.setup.instruction.multicastdetector-mcaddr.help";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORBINDADDR_PREF = "rhq.communications.multicast-detector.bind-address";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORBINDADDR_DEFAULT = "127.0.0.1";
    @I18NMessages(value={@I18NMessage(value="Multicast Detector Bind Address")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORBINDADDR_PROMPT = "PromptCommand.setup.instruction.multicastdetector-bindaddr.prompt";
    @I18NMessages(value={@I18NMessage(value="The IP address that is bound by the network interface")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORBINDADDR_HELP = "PromptCommand.setup.instruction.multicastdetector-bindaddr.help";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORPORT_PREF = "rhq.communications.multicast-detector.port";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORPORT_DEFAULT = "16162";
    @I18NMessages(value={@I18NMessage(value="Multicast Detector Port")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORPORT_PROMPT = "PromptCommand.setup.instruction.multicastdetector-port.prompt";
    @I18NMessages(value={@I18NMessage(value="The port that is used to broadcast detection messages on via multicast.")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORPORT_HELP = "PromptCommand.setup.instruction.multicastdetector-port.help";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORDEFAULTTIMEDELAY_PREF = "rhq.communications.multicast-detector.default-time-delay";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORDEFAULTTIMEDELAY_DEFAULT = "5000";
    @I18NMessages(value={@I18NMessage(value="Multicast Detector Server-Down Detection Default Time Delay")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORDEFAULTTIMEDELAY_PROMPT = "PromptCommand.setup.instruction.multicastdetector-defaulttimedelay.prompt";
    @I18NMessages(value={@I18NMessage(value="If no RHQ Server heartbeat message is received within this amount\\n\\\nof milliseconds, it will be assumed the RHQ Server has gone down.\\n\\\nThis setting affects the timeliness of the auto-detection mechanism.")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORDEFAULTTIMEDELAY_HELP = "PromptCommand.setup.instruction.multicastdetector-defaulttimedelay.help";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORHEARTBEATTIMEDELAY_PREF = "rhq.communications.multicast-detector.heartbeat-time-delay";
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORHEARTBEATTIMEDELAY_DEFAULT = "1000";
    @I18NMessages(value={@I18NMessage(value="Multicast Detector Heartbeat Time Delay")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORHEARTBEATTIMEDELAY_PROMPT = "PromptCommand.setup.instruction.multicastdetector-heartbeattimedelay.prompt";
    @I18NMessages(value={@I18NMessage(value="This is the time delay that the agent will wait before it\\n\\\nemits its own heartbeat message.")})
    public static final String SETUP_INSTRUCTION_MULTICASTDETECTORHEARTBEATTIMEDELAY_HELP = "PromptCommand.setup.instruction.multicastdetector-heartbeattimedelay.help";
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORT_PREF = "rhq.communications.connector.transport";
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORT_DEFAULT = "socket";
    @I18NMessages(value={@I18NMessage(value="Agent Transport Protocol")})
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORT_PROMPT = "PromptCommand.setup.instruction.connector.transport.prompt";
    @I18NMessages(value={@I18NMessage(value="The transport that the agent expects incoming messages to flow over.\\n\\\nTypical values are socket and sslsocket.")})
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORT_HELP = "PromptCommand.setup.instruction.connector.transport.help";
    public static final String SETUP_INSTRUCTION_CONNECTORBINDADDR_PREF = "rhq.communications.connector.bind-address";
    @I18NMessages(value={@I18NMessage(value="Agent Hostname or IP Address")})
    public static final String SETUP_INSTRUCTION_CONNECTORBINDADDR_PROMPT = "PromptCommand.setup.instruction.connector.bindaddr.prompt";
    @I18NMessages(value={@I18NMessage(value="The hostname or IP address the agent will bind to in order to\\n\\\nlisten for incoming messages. Usually, you will want to leave this undefined so\\n\\\nthe agent picks up its default local IP address as it is currently configured\\n\\\nin the operation system. If, for some reason, the operating system default IP\\n\\\naddress is not the one you want to use, then you can set an explicit value\\n\\\nhere. Realize that if you do this, and the agent later changes its assigned IP,\\n\\\nyou must reconfigure the agent to use the new IP; otherwise, the agent will not\\n\\\nbe able to communicate with the server.")})
    public static final String SETUP_INSTRUCTION_CONNECTORBINDADDR_HELP = "PromptCommand.setup.instruction.connector.bindaddr.help";
    public static final String SETUP_INSTRUCTION_CONNECTORPORT_PREF = "rhq.communications.connector.bind-port";
    public static final String SETUP_INSTRUCTION_CONNECTORPORT_DEFAULT = Integer.toString(16163);
    @I18NMessages(value={@I18NMessage(value="Agent Port")})
    public static final String SETUP_INSTRUCTION_CONNECTORPORT_PROMPT = "PromptCommand.setup.instruction.connector.bindport.prompt";
    @I18NMessages(value={@I18NMessage(value="The port that the agent listens to for incoming messages.")})
    public static final String SETUP_INSTRUCTION_CONNECTORPORT_HELP = "PromptCommand.setup.instruction.connector.bindport.help";
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORTPARAMS_PREF = "rhq.communications.connector.transport-params";
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORTPARAMS_DEFAULT = "numAcceptThreads=1&maxPoolSize=303&clientMaxPoolSize=304&socketTimeout=60000&enableTcpNoDelay=true&backlog=200";
    @I18NMessages(value={@I18NMessage(value="Agent Transport Parameters")})
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORTPARAMS_PROMPT = "PromptCommand.setup.instruction.connector.transportparams.prompt";
    @I18NMessages(value={@I18NMessage(value="A set of transport parameters that is used to further configure\\n\\\nthe agent listener. Any value you provide here will overwrite (not augment)\\n\\\nthe current value. See the documentation for information on\\n\\\nthe format of this setting and all the different values allowed\\n\\\nfor the specific transport being used.")})
    public static final String SETUP_INSTRUCTION_CONNECTORTRANSPORTPARAMS_HELP = "PromptCommand.setup.instruction.connector.transportparams.help";
    public static final String SETUP_INSTRUCTION_CONNECTORLEASE_PREF = "rhq.communications.connector.lease-period";
    public static final String SETUP_INSTRUCTION_CONNECTORLEASE_DEFAULT = "-1";
    @I18NMessages(value={@I18NMessage(value="Agent Listener Lease Period")})
    public static final String SETUP_INSTRUCTION_CONNECTORLEASE_PROMPT = "PromptCommand.setup.instruction.connector.leaseperiod.prompt";
    @I18NMessages(value={@I18NMessage(value="The number of milliseconds that the RHQ Server has before it\\n\\\nneeds to update its lease with this agent.  This lease is only\\n\\\nneeded during a single connection with the agent.  Once the RHQ\\n\\\nServer finishes sending the agent its message and closes its\\n\\\nconnection with the agent, the lease no longer needs updating.\\n\\\nIf this is 0 or less, the RHQ Server does not need a lease.")})
    public static final String SETUP_INSTRUCTION_CONNECTORLEASE_HELP = "PromptCommand.setup.instruction.connector.leaseperiod.help";
    public static final String SETUP_INSTRUCTION_STREAMIDLE_PREF = "rhq.communications.remote-stream-max-idle-time-msecs";
    public static final String SETUP_INSTRUCTION_STREAMIDLE_DEFAULT = Long.toString(300000L);
    @I18NMessages(value={@I18NMessage(value="Remote Stream Max Idle Time")})
    public static final String SETUP_INSTRUCTION_STREAMIDLE_PROMPT = "PromptCommand.setup.instruction.streamidle.prompt";
    @I18NMessages(value={@I18NMessage(value="The maximum amount of milliseconds a remoted stream\\n\\\nis allowed to be idle before it is automatically closed and\\n\\\nremoved from the agent listener. This means that the\\n\\\nRHQ Server must attempt to access the remoted stream\\n\\\nevery X milliseconds (where X is the value of this setting)\\n\\\nor that stream will no longer be available. Note that this\\n\\\ndoes not mean the RHQ Server must read or write the\\n\\\nentire stream in this amount of time, it only means\\n\\\nthe RHQ Server must make a request on the stream every\\n\\\nX milliseconds (be it to read or write one byte, see how many\\n\\\nbytes are available to be read, etc).")})
    public static final String SETUP_INSTRUCTION_STREAMIDLE_HELP = "PromptCommand.setup.instruction.streamidle.help";
    public static final String SETUP_INSTRUCTION_SERVERCLIENTAUTHMODE_PREF = "rhq.communications.connector.security.client-auth-mode";
    public static final String SETUP_INSTRUCTION_SERVERCLIENTAUTHMODE_DEFAULT = "none";
    @I18NMessages(value={@I18NMessage(value="Client Authentication Mode")})
    public static final String SETUP_INSTRUCTION_SERVERCLIENTAUTHMODE_PROMPT = "PromptCommand.setup.instruction.server-client-auth-mode.prompt";
    @I18NMessages(value={@I18NMessage(value="Client-auth mode determines if the agent should authenticate some or all\\n\\\nsenders of incoming messages sent to the agent. If authentication is to be\\n\\\nperformed, the agent must have a server-side truststore.\\n\\\nThis preference value must be one of the following: none, want, need")})
    public static final String SETUP_INSTRUCTION_SERVERCLIENTAUTHMODE_HELP = "PromptCommand.setup.instruction.server-client-auth-mode.help";
    public static final String SETUP_INSTRUCTION_CLIENTSERVERAUTHMODEENABLED_PREF = "rhq.agent.client.security.server-auth-mode-enabled";
    public static final String SETUP_INSTRUCTION_CLIENTSERVERAUTHMODEENABLED_DEFAULT = Boolean.toString(false);
    @I18NMessages(value={@I18NMessage(value="Server Authentication Mode Enabled?")})
    public static final String SETUP_INSTRUCTION_CLIENTSERVERAUTHMODEENABLED_PROMPT = "PromptCommand.setup.instruction.client-server-auth-mode-enabled.prompt";
    @I18NMessages(value={@I18NMessage(value="When server authentication mode is true, the agent will attempt to\\n\\\nauthenticate the RHQ Server everytime it sends a message to it. If\\n\\\nthis is true, the agent must have a client-side truststore.")})
    public static final String SETUP_INSTRUCTION_CLIENTSERVERAUTHMODEENABLED_HELP = "PromptCommand.setup.instruction.client-server-auth-mode-enabled.help";
    public static final String SETUP_INSTRUCTION_SERVERSECUREPROTOCOL_PREF = "rhq.communications.connector.security.secure-socket-protocol";
    public static final String SETUP_INSTRUCTION_SERVERSECUREPROTOCOL_DEFAULT = "TLS";
    @I18NMessages(value={@I18NMessage(value="Incoming Secure Socket Protocol")})
    public static final String SETUP_INSTRUCTION_SERVERSECUREPROTOCOL_PROMPT = "PromptCommand.setup.instruction.server-secure-protocol.prompt";
    @I18NMessages(value={@I18NMessage(value="The secure protocol required when receiving messages from the RHQ Server.")})
    public static final String SETUP_INSTRUCTION_SERVERSECUREPROTOCOL_HELP = "PromptCommand.setup.instruction.server-secure-protocol.help";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREFILE_PREF = "rhq.communications.connector.security.keystore.file";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREFILE_DEFAULT = "keystore.dat";
    @I18NMessages(value={@I18NMessage(value="Server-side Keystore File")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREFILE_PROMPT = "PromptCommand.setup.instruction.server-keystore-file.prompt";
    @I18NMessages(value={@I18NMessage(value="The agent server-side keystore file that contains a key that is sent to\\n\\\nthe RHQ Server when the server is sending a message to the agent.\\n\\\nThis keystore contains the key that identifies the agent and is\\n\\\nused if the RHQ Server has its \"server authentication mode\" enabled.\\n\\\nThis can be the same as the agent client-side keystore file.")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREFILE_HELP = "PromptCommand.setup.instruction.server-keystore-file.help";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALGORITHM_PREF = "rhq.communications.connector.security.keystore.algorithm";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALGORITHM_DEFAULT = "SunX509";
    @I18NMessages(value={@I18NMessage(value="Server-side Keystore Algorithm")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALGORITHM_PROMPT = "PromptCommand.setup.instruction.server-keystore-alg.prompt";
    @I18NMessages(value={@I18NMessage(value="The algorithm used to generate the server-side keystore key.")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALGORITHM_HELP = "PromptCommand.setup.instruction.server-keystore-alg.help";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTORETYPE_PREF = "rhq.communications.connector.security.keystore.type";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTORETYPE_DEFAULT = "JKS";
    @I18NMessages(value={@I18NMessage(value="Server-side Keystore Type")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTORETYPE_PROMPT = "PromptCommand.setup.instruction.server-keystore-type.prompt";
    @I18NMessages(value={@I18NMessage(value="Identifies the server-side keystore file format implementation.")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTORETYPE_HELP = "PromptCommand.setup.instruction.server-keystore-type.help";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREPASSWORD_PREF = "rhq.communications.connector.security.keystore.password";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREPASSWORD_DEFAULT = "rhqpwd";
    @I18NMessages(value={@I18NMessage(value="Server-side Keystore Password")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREPASSWORD_PROMPT = "PromptCommand.setup.instruction.server-keystore-pw.prompt";
    @I18NMessages(value={@I18NMessage(value="The password to access the server-side keystore.")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREPASSWORD_HELP = "PromptCommand.setup.instruction.server-keystore-pw.help";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREKEYPASSWORD_PREF = "rhq.communications.connector.security.keystore.key-password";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREKEYPASSWORD_DEFAULT = "rhqpwd";
    @I18NMessages(value={@I18NMessage(value="Server-side Keystore Key Password")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREKEYPASSWORD_PROMPT = "PromptCommand.setup.instruction.server-keystore-key-pw.prompt";
    @I18NMessages(value={@I18NMessage(value="The password to access the key in the server-side keystore.")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREKEYPASSWORD_HELP = "PromptCommand.setup.instruction.server-keystore-key-pw.help";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALIAS_PREF = "rhq.communications.connector.security.keystore.alias";
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALIAS_DEFAULT = "rhq";
    @I18NMessages(value={@I18NMessage(value="Server-side Keystore Key Alias")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALIAS_PROMPT = "PromptCommand.setup.instruction.server-keystore-alias.prompt";
    @I18NMessages(value={@I18NMessage(value="The alias of the key in the server-side keystore used to identify the agent.")})
    public static final String SETUP_INSTRUCTION_SERVERKEYSTOREALIAS_HELP = "PromptCommand.setup.instruction.server-keystore-alias.help";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREFILE_PREF = "rhq.communications.connector.security.truststore.file";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREFILE_DEFAULT = "truststore.dat";
    @I18NMessages(value={@I18NMessage(value="Server-side Truststore File")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREFILE_PROMPT = "PromptCommand.setup.instruction.server-truststore-file.prompt";
    @I18NMessages(value={@I18NMessage(value="The agent server-side truststore file contains keys of trusted\\n\\\nRHQ Servers that are allowed to send the agent incoming messages. This is\\n\\\nused if the agent's client-auth mode is set to something other than none.\\n\\\nThis can be the same as the agent client-side truststore file.")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREFILE_HELP = "PromptCommand.setup.instruction.server-truststore-file.help";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREALGORITHM_PREF = "rhq.communications.connector.security.truststore.algorithm";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREALGORITHM_DEFAULT = "SunX509";
    @I18NMessages(value={@I18NMessage(value="Server-side Truststore Algorithm")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREALGORITHM_PROMPT = "PromptCommand.setup.instruction.server-truststore-alg.prompt";
    @I18NMessages(value={@I18NMessage(value="The algorithm used to generate the server-side truststore keys.")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREALGORITHM_HELP = "PromptCommand.setup.instruction.server-truststore-alg.help";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTORETYPE_PREF = "rhq.communications.connector.security.truststore.type";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTORETYPE_DEFAULT = "JKS";
    @I18NMessages(value={@I18NMessage(value="Server-side Truststore Type")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTORETYPE_PROMPT = "PromptCommand.setup.instruction.server-truststore-type.prompt";
    @I18NMessages(value={@I18NMessage(value="Identifies the server-side truststore file format implementation.")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTORETYPE_HELP = "PromptCommand.setup.instruction.server-truststore-type.help";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREPASSWORD_PREF = "rhq.communications.connector.security.truststore.password";
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREPASSWORD_DEFAULT = "";
    @I18NMessages(value={@I18NMessage(value="Server-side Truststore Password")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREPASSWORD_PROMPT = "PromptCommand.setup.instruction.server-truststore-pw.prompt";
    @I18NMessages(value={@I18NMessage(value="The password used to access the server-side truststore.")})
    public static final String SETUP_INSTRUCTION_SERVERTRUSTSTOREPASSWORD_HELP = "PromptCommand.setup.instruction.server-truststore-pw.help";
    public static final String SETUP_INSTRUCTION_CLIENTSECUREPROTOCOL_PREF = "rhq.agent.client.security.secure-socket-protocol";
    public static final String SETUP_INSTRUCTION_CLIENTSECUREPROTOCOL_DEFAULT = "TLS";
    @I18NMessages(value={@I18NMessage(value="Outgoing Secure Socket Protocol")})
    public static final String SETUP_INSTRUCTION_CLIENTSECUREPROTOCOL_PROMPT = "PromptCommand.setup.instruction.client-secure-protocol.prompt";
    @I18NMessages(value={@I18NMessage(value="The secure protocol required when sending messages to the RHQ Server.")})
    public static final String SETUP_INSTRUCTION_CLIENTSECUREPROTOCOL_HELP = "PromptCommand.setup.instruction.client-secure-protocol.help";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREFILE_PREF = "rhq.agent.client.security.keystore.file";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREFILE_DEFAULT = "keystore.dat";
    @I18NMessages(value={@I18NMessage(value="Client-side Keystore File")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREFILE_PROMPT = "PromptCommand.setup.instruction.client-keystore-file.prompt";
    @I18NMessages(value={@I18NMessage(value="The agent client-side keystore file that contains a key that is sent to\\n\\\nthe RHQ Server when the agent sends a message to the server.\\n\\\nThis keystore contains the key that identifies the agent and is\\n\\\nused if the RHQ Server has its \"client authentication mode\" set.\\n\\\nThis can be the same as the agent server-side keystore file.")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREFILE_HELP = "PromptCommand.setup.instruction.client-keystore-file.help";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALGORITHM_PREF = "rhq.agent.client.security.keystore.algorithm";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALGORITHM_DEFAULT = "SunX509";
    @I18NMessages(value={@I18NMessage(value="Client-side Keystore Algorithm")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALGORITHM_PROMPT = "PromptCommand.setup.instruction.client-keystore-alg.prompt";
    @I18NMessages(value={@I18NMessage(value="The algorithm used to generate the client-side keystore key.")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALGORITHM_HELP = "PromptCommand.setup.instruction.client-keystore-alg.help";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTORETYPE_PREF = "rhq.agent.client.security.keystore.type";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTORETYPE_DEFAULT = "JKS";
    @I18NMessages(value={@I18NMessage(value="Client-side Keystore Type")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTORETYPE_PROMPT = "PromptCommand.setup.instruction.client-keystore-type.prompt";
    @I18NMessages(value={@I18NMessage(value="Identifies the client-side keystore file format implementation.")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTORETYPE_HELP = "PromptCommand.setup.instruction.client-keystore-type.help";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREPASSWORD_PREF = "rhq.agent.client.security.keystore.password";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREPASSWORD_DEFAULT = "rhqpwd";
    @I18NMessages(value={@I18NMessage(value="Client-side Keystore Password")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREPASSWORD_PROMPT = "PromptCommand.setup.instruction.client-keystore-pw.prompt";
    @I18NMessages(value={@I18NMessage(value="The password to access the client-side keystore.")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREPASSWORD_HELP = "PromptCommand.setup.instruction.client-keystore-pw.help";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREKEYPASSWORD_PREF = "rhq.agent.client.security.keystore.key-password";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREKEYPASSWORD_DEFAULT = "rhqpwd";
    @I18NMessages(value={@I18NMessage(value="Client-side Keystore Key Password")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREKEYPASSWORD_PROMPT = "PromptCommand.setup.instruction.client-keystore-key-pw.prompt";
    @I18NMessages(value={@I18NMessage(value="The password to access the key in the client-side keystore.")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREKEYPASSWORD_HELP = "PromptCommand.setup.instruction.client-keystore-key-pw.help";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALIAS_PREF = "rhq.agent.client.security.keystore.alias";
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALIAS_DEFAULT = "rhq";
    @I18NMessages(value={@I18NMessage(value="Client-side Keystore Key Alias")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALIAS_PROMPT = "PromptCommand.setup.instruction.client-keystore-alias.prompt";
    @I18NMessages(value={@I18NMessage(value="The alias of the key in the client-side keystore used to identify the agent.")})
    public static final String SETUP_INSTRUCTION_CLIENTKEYSTOREALIAS_HELP = "PromptCommand.setup.instruction.client-keystore-alias.help";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREFILE_PREF = "rhq.agent.client.security.truststore.file";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREFILE_DEFAULT = "truststore.dat";
    @I18NMessages(value={@I18NMessage(value="Client-side Truststore File")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREFILE_PROMPT = "PromptCommand.setup.instruction.client-truststore-file.prompt";
    @I18NMessages(value={@I18NMessage(value="The agent client-side truststore file contains keys of trusted\\n\\\nRHQ Servers to which the agent is allowed to send outgoing messages. This is\\n\\\nused if the agent's server authentication mode is enabled.\\n\\\nThis can be the same as the agent server-side truststore file.")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREFILE_HELP = "PromptCommand.setup.instruction.client-truststore-file.help";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREALGORITHM_PREF = "rhq.agent.client.security.truststore.algorithm";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREALGORITHM_DEFAULT = "SunX509";
    @I18NMessages(value={@I18NMessage(value="Client-side Truststore Algorithm")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREALGORITHM_PROMPT = "PromptCommand.setup.instruction.client-truststore-alg.prompt";
    @I18NMessages(value={@I18NMessage(value="The algorithm used to generate the client-side truststore keys.")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREALGORITHM_HELP = "PromptCommand.setup.instruction.client-truststore-alg.help";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTORETYPE_PREF = "rhq.agent.client.security.truststore.type";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTORETYPE_DEFAULT = "JKS";
    @I18NMessages(value={@I18NMessage(value="Client-side Truststore Type")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTORETYPE_PROMPT = "PromptCommand.setup.instruction.client-truststore-type.prompt";
    @I18NMessages(value={@I18NMessage(value="Identifies the client-side truststore file format implementation.")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTORETYPE_HELP = "PromptCommand.setup.instruction.client-truststore-type.help";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREPASSWORD_PREF = "rhq.agent.client.security.truststore.password";
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREPASSWORD_DEFAULT = "";
    @I18NMessages(value={@I18NMessage(value="Client-side Truststore Password")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREPASSWORD_PROMPT = "PromptCommand.setup.instruction.client-truststore-pw.prompt";
    @I18NMessages(value={@I18NMessage(value="The password used to access the client-side truststore.")})
    public static final String SETUP_INSTRUCTION_CLIENTTRUSTSTOREPASSWORD_HELP = "PromptCommand.setup.instruction.client-truststore-pw.help";
    public static final String SETUP_INSTRUCTION_PLUGINSDIR_PREF = "rhq.agent.plugins.directory";
    public static final String SETUP_INSTRUCTION_PLUGINSDIR_DEFAULT = "plugins";
    @I18NMessages(value={@I18NMessage(value="Plugins Directory")})
    public static final String SETUP_INSTRUCTION_PLUGINSDIR_PROMPT = "PromptCommand.setup.instruction.plugins.directory.prompt";
    @I18NMessages(value={@I18NMessage(value="The directory location where the plugins can be found.")})
    public static final String SETUP_INSTRUCTION_PLUGINSDIR_HELP = "PromptCommand.setup.instruction.plugins.directory.help";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYPERIOD_PREF = "rhq.agent.plugins.server-discovery.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYPERIOD_DEFAULT = Long.toString(900L);
    @I18NMessages(value={@I18NMessage(value="Server Discovery Scan Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.server-discovery-period.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds that defines how often a server discovery\\n\\\nscan is performed. A server discovery looks for new servers\\n\\\nthat can be imported into inventory.")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYPERIOD_HELP = "PromptCommand.setup.instruction.plugins.server-discovery-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYINITIALDELAY_PREF = "rhq.agent.plugins.server-discovery.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYINITIALDELAY_DEFAULT = Long.toString(10L);
    @I18NMessages(value={@I18NMessage(value="Server Discovery Scan Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.server-discovery-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial server discovery scan is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVERDISCOVERYINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.server-discovery-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYPERIOD_PREF = "rhq.agent.plugins.service-discovery.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYPERIOD_DEFAULT = Long.toString(86400L);
    @I18NMessages(value={@I18NMessage(value="Service Discovery Scan Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.service-discovery-period.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds that defines how often a service discovery scan is\\n\\\nperformed. A service discovery scan looks for resources that were\\n\\\nadded or removed from existing platform and server resources.")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYPERIOD_HELP = "PromptCommand.setup.instruction.plugins.service-discovery-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYINITIALDELAY_PREF = "rhq.agent.plugins.service-discovery.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYINITIALDELAY_DEFAULT = Long.toString(20L);
    @I18NMessages(value={@I18NMessage(value="Service Discovery Scan Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.service-discovery-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial service discovery scan is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSSERVICEDISCOVERYINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.service-discovery-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANPERIOD_PREF = "rhq.agent.plugins.availability-scan.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANPERIOD_DEFAULT = Long.toString(30L);
    @I18NMessages(value={@I18NMessage(value="Availability Scan Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.avail-scan-period.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds that defines how often an availability scan is\\n\\\nperformed. An availability scan looks to determine what resources\\n\\\nare up and running and what resources have gone down.")})
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANPERIOD_HELP = "PromptCommand.setup.instruction.plugins.avail-scan-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANINITIALDELAY_PREF = "rhq.agent.plugins.availability-scan.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANINITIALDELAY_DEFAULT = Long.toString(5L);
    @I18NMessages(value={@I18NMessage(value="Availability Scan Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.avail-scan-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial availability scan is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSAVAILSCANINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.avail-scan-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSMEASUREMENTCOLLINITIALDELAY_PREF = "rhq.agent.plugins.measurement-collection.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSMEASUREMENTCOLLINITIALDELAY_DEFAULT = Long.toString(30L);
    @I18NMessages(value={@I18NMessage(value="Measurement Collection Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSMEASUREMENTCOLLINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.meas-coll-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial measurement collection is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSMEASUREMENTCOLLINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.meas-coll-initialdelay.help";
    public static final String SETUP_INSTRUCTION_REGISTERWITHSERVERATSTARTUP_PREF = "rhq.agent.register-with-server-at-startup";
    public static final String SETUP_INSTRUCTION_REGISTERWITHSERVERATSTARTUP_DEFAULT = Boolean.toString(true);
    @I18NMessages(value={@I18NMessage(value="Register With RHQ Server at Startup")})
    public static final String SETUP_INSTRUCTION_REGISTERWITHSERVERATSTARTUP_PROMPT = "PromptCommand.setup.instruction.registerwithserver.prompt";
    @I18NMessages(value={@I18NMessage(value="If true, the agent will automatically attempt to register\\n\\\nitself with the RHQ Server when the agent starts up.\\n\\\nIf false, you must ensure the agent is either already registered\\n\\\nor will be manually registered (see the register prompt command).")})
    public static final String SETUP_INSTRUCTION_REGISTERWITHSERVERATSTARTUP_HELP = "PromptCommand.setup.instruction.registerwithserver.help";
    public static final String SETUP_INSTRUCTION_WAITFORSERVERATSTARTUPMSECS_PREF = "rhq.agent.wait-for-server-at-startup-msecs";
    public static final String SETUP_INSTRUCTION_WAITFORSERVERATSTARTUPMSECS_DEFAULT = Long.toString(60000L);
    @I18NMessages(value={@I18NMessage(value="Wait Time for RHQ Server at Startup")})
    public static final String SETUP_INSTRUCTION_WAITFORSERVERATSTARTUPMSECS_PROMPT = "PromptCommand.setup.instruction.waitforservermsecs.prompt";
    @I18NMessages(value={@I18NMessage(value="This defines how many milliseconds the agent should wait at\\n\\\nstartup for the RHQ Server to be detected. If the RHQ Server\\n\\\nhas not started up in the given amount of time, the agent will\\n\\\ncontinue initializing and expect the server to come up later.\\n\\\nIf this is 0, the agent will not wait at all.")})
    public static final String SETUP_INSTRUCTION_WAITFORSERVERATSTARTUPMSECS_HELP = "PromptCommand.setup.instruction.waitforservermsecs.help";
    public static final String SETUP_INSTRUCTION_PRIMARYSERVERSWITCHOVERCHECKINTERVAL_PREF = "rhq.agent.primary-server-switchover-check-interval-msecs";
    public static final String SETUP_INSTRUCTION_PRIMARYSERVERSWITCHOVERCHECKINTERVAL_DEFAULT = Long.toString(3600000L);
    @I18NMessages(value={@I18NMessage(value="Primary Server Switchover Check Interval:")})
    public static final String SETUP_INSTRUCTION_PRIMARYSERVERSWITCHOVERCHECKINTERVAL_PROMPT = "PromptCommand.setup.instruction.primaryserverswitchovercheckinterval.prompt";
    @I18NMessages(value={@I18NMessage(value="The agent will periodically check to ensure that the server\\n\\\nit is connected to is its primary server (as opposed to one\\n\\\nof its failover servers). This preference defines how many\\n\\\nmilliseconds the agent should wait in between these checks.\\n\\\nIf 0, this check is never performed.\\n\\\n")})
    public static final String SETUP_INSTRUCTION_PRIMARYSERVERSWITCHOVERCHECKINTERVAL_HELP = "PromptCommand.setup.instruction.primaryserverswitchovercheckinterval.help";
    public static final String SETUP_INSTRUCTION_DISABLENATIVESYSTEM_PREF = "rhq.agent.disable-native-system";
    public static final String SETUP_INSTRUCTION_DISABLENATIVESYSTEM_DEFAULT = Boolean.toString(false);
    @I18NMessages(value={@I18NMessage(value="Disable Native System")})
    public static final String SETUP_INSTRUCTION_DISABLENATIVESYSTEM_PROMPT = "PromptCommand.setup.instruction.disablenativesystem.prompt";
    @I18NMessages(value={@I18NMessage(value="This will allow you to tell the agent to disable the native system,\\n\\\nthus turning off the usage of the native libraries (if they are\\n\\\navailable on the agent platform).  In fact, disabling the native system\\n\\\nwill ensure that the native JNI libraries are not even loaded into the\\n\\\nagent's Java VM. You normally do not want to disable the native system\\n\\\nunless you have a good reason to do so. Disabling the native system will\\n\\\nturn off the ability of the plugins to perform auto-discovery using\\n\\\nprocess table scans and will not allow the plugins to obtain\\n\\\nany information from the low-level operating system resources.")})
    public static final String SETUP_INSTRUCTION_DISABLENATIVESYSTEM_HELP = "PromptCommand.setup.instruction.disablenativesystem.help";
    public static final String SETUP_INSTRUCTION_UPDATEPLUGINSATSTARTUP_PREF = "rhq.agent.update-plugins-at-startup";
    public static final String SETUP_INSTRUCTION_UPDATEPLUGINSATSTARTUP_DEFAULT = Boolean.toString(true);
    @I18NMessages(value={@I18NMessage(value="Update Plugins at Startup")})
    public static final String SETUP_INSTRUCTION_UPDATEPLUGINSATSTARTUP_PROMPT = "PromptCommand.setup.instruction.updateplugins.prompt";
    @I18NMessages(value={@I18NMessage(value="If true, the agent will attempt to update its current set of plugins to their\\n\\\nlatest versions at startup. If false, the agent will not automatically update\\n\\\nthe plugins; the agent will use its current plugins.")})
    public static final String SETUP_INSTRUCTION_UPDATEPLUGINSATSTARTUP_HELP = "PromptCommand.setup.instruction.updateplugins.help";
    public static final String SETUP_INSTRUCTION_TESTFAILOVERLISTATSTARTUP_PREF = "rhq.agent.test-failover-list-at-startup";
    public static final String SETUP_INSTRUCTION_TESTFAILOVERLISTATSTARTUP_DEFAULT = Boolean.toString(false);
    @I18NMessages(value={@I18NMessage(value="Test Failover List at Startup")})
    public static final String SETUP_INSTRUCTION_TESTFAILOVERLISTATSTARTUP_PROMPT = "PromptCommand.setup.instruction.testfailoverlist.prompt";
    @I18NMessages(value={@I18NMessage(value="If true, the agent will attempt to connect to all servers found\\n\\\nin its failover list. Warning messages will be logged if errors occur while\\n\\\nattempting to connect to one or more servers.")})
    public static final String SETUP_INSTRUCTION_TESTFAILOVERLISTATSTARTUP_HELP = "PromptCommand.setup.instruction.testfailoverlist.help";
    public static final String SETUP_INSTRUCTION_AGENTUPDATEENABLED_PREF = "rhq.agent.agent-update.enabled";
    public static final String SETUP_INSTRUCTION_AGENTUPDATEENABLED_DEFAULT = Boolean.toString(true);
    @I18NMessages(value={@I18NMessage(value="Enable Agent Updates")})
    public static final String SETUP_INSTRUCTION_AGENTUPDATEENABLED_PROMPT = "PromptCommand.setup.instruction.agentupdateenabled.prompt";
    @I18NMessages(value={@I18NMessage(value="If true, the agent will be allowed to apply agent updates to itself.\\n\\\nIf false, the agent will never apply updates; therefore any agent updates\\n\\\nmust be done manually.")})
    public static final String SETUP_INSTRUCTION_AGENTUPDATEENABLED_HELP = "PromptCommand.setup.instruction.agentupdateenabled.help";
    public static final String SETUP_INSTRUCTION_AGENTUPDATEVERSIONURL_PREF = "rhq.agent.agent-update.version-url";
    public static final String SETUP_INSTRUCTION_AGENTUPDATEVERSIONURL_DEFAULT = null;
    @I18NMessages(value={@I18NMessage(value="Agent Update Version URL")})
    public static final String SETUP_INSTRUCTION_AGENTUPDATEVERSIONURL_PROMPT = "PromptCommand.setup.instruction.agentupdateversionurl.prompt";
    @I18NMessages(value={@I18NMessage(value="If this is defined, it will be the URL the agent uses when it\\n\\\nneeds to retrieve information about the latest available\\n\\\nagent update binary.  If this is not defined (i.e. left as 'null'),\\n\\\nthe default will be a URL to the server the agent is currently\\n\\\nconnected to at the time the version request is initiated. If you have\\n\\\nthis set but wish to revert back to the default behavior,\\n\\\nenter !* at the prompt.")})
    public static final String SETUP_INSTRUCTION_AGENTUPDATEVERSIONURL_HELP = "PromptCommand.setup.instruction.agentupdateversionurl.help";
    public static final String SETUP_INSTRUCTION_AGENTUPDATEDOWNLOADURL_PREF = "rhq.agent.agent-update.download-url";
    public static final String SETUP_INSTRUCTION_AGENTUPDATEDOWNLOADURL_DEFAULT = null;
    @I18NMessages(value={@I18NMessage(value="Agent Update Download URL")})
    public static final String SETUP_INSTRUCTION_AGENTUPDATEDOWNLOADURL_PROMPT = "PromptCommand.setup.instruction.agentupdatedownloadurl.prompt";
    @I18NMessages(value={@I18NMessage(value="If this is defined, it will be the URL the agent uses when it\\n\\\nneeds to download the latest available agent update binary.\\n\\\nIf this is not defined (i.e. left as 'null'), the default will be\\n\\\na URL to the server the agent is currently connected to at the time the\\n\\\ndownload is initiated. If you have this set but wish to revert back\\n\\\nto the default behavior, enter !* at the prompt.")})
    public static final String SETUP_INSTRUCTION_AGENTUPDATEDOWNLOADURL_HELP = "PromptCommand.setup.instruction.agentupdatedownloadurl.help";
    public static final String SETUP_INSTRUCTION_AGENTNAME_PREF = "rhq.agent.name";
    @I18NMessages(value={@I18NMessage(value="Agent Name")})
    public static final String SETUP_INSTRUCTION_AGENTNAME_PROMPT = "PromptCommand.setup.instruction.agentname.prompt";
    @I18NMessages(value={@I18NMessage(value="The name that this agent is to be known as.  This must be unique across\\n\\\nall agents.  The default is the fully qualified domain name of the host\\n\\\nthat this agent is running on. However, you can name it anything you\\n\\\nwant, as long as it is unique among all other agents in the system.")})
    public static final String SETUP_INSTRUCTION_AGENTNAME_HELP = "PromptCommand.setup.instruction.agentname.help";
    public static final String SETUP_INSTRUCTION_PCMEASUREMENTTHREADCOUNT_PREF = "rhq.agent.plugins.measurement-collection.threadpool-size";
    public static final String SETUP_INSTRUCTION_PCMEASUREMENTTHREADCOUNT_DEFAULT = Integer.toString(5);
    @I18NMessages(value={@I18NMessage(value="Measurement Collection Thread Pool Size")})
    public static final String SETUP_INSTRUCTION_PCMEASUREMENTTHREADCOUNT_PROMPT = "PromptCommand.setup.instruction.measurementthreadcount.prompt";
    @I18NMessages(value={@I18NMessage(value="This defines the number of threads within the plugin container's measurement\\n\\\ncollection thread pool.  The higher the number, the more measurements that\\n\\\ncan be collected concurrently.")})
    public static final String SETUP_INSTRUCTION_PCMEASUREMENTTHREADCOUNT_HELP = "PromptCommand.setup.instruction.measurementthreadcount.help";
    public static final String SETUP_INSTRUCTION_PCOPERATIONTHREADCOUNT_PREF = "rhq.agent.plugins.operation-invoker.threadpool-size";
    public static final String SETUP_INSTRUCTION_PCOPERATIONTHREADCOUNT_DEFAULT = Integer.toString(10);
    @I18NMessages(value={@I18NMessage(value="Operation Invoker Thread Pool Size")})
    public static final String SETUP_INSTRUCTION_PCOPERATIONTHREADCOUNT_PROMPT = "PromptCommand.setup.instruction.operationthreadcount.prompt";
    @I18NMessages(value={@I18NMessage(value="This defines the number of threads within the plugin container's operation\\n\\\ninvoker thread pool.  The higher the number, the more operations that\\n\\\ncan be concurrently invoked.")})
    public static final String SETUP_INSTRUCTION_PCOPERATIONTHREADCOUNT_HELP = "PromptCommand.setup.instruction.operationthreadcount.help";
    public static final String SETUP_INSTRUCTION_PCOPINVOCATIONTIMEOUT_PREF = "rhq.agent.plugins.operation-invocation-timeout-secs";
    public static final String SETUP_INSTRUCTION_PCOPINVOCATIONTIMEOUT_DEFAULT = Long.toString(600L);
    @I18NMessages(value={@I18NMessage(value="Operation Invocation Timeout")})
    public static final String SETUP_INSTRUCTION_PCOPINVOCATIONTIMEOUT_PROMPT = "PromptCommand.setup.instruction.opinvocationtimeout.prompt";
    @I18NMessages(value={@I18NMessage(value="This is the default timeout used for operation invocations. When a plugin\\n\\\ninvokes an operation on a managed resource, and that invocation does not\\n\\\nfinish with this amount of seconds, the invocation will be aborted.\\n\\\nNote that this is only a default; a plugin may actually override this value\\n\\\nby defining its own timeouts within its plugin descriptor.")})
    public static final String SETUP_INSTRUCTION_PCOPINVOCATIONTIMEOUT_HELP = "PromptCommand.setup.instruction.opinvocationtimeout.help";
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONPERIOD_PREF = "rhq.agent.plugins.drift-detection.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONPERIOD_DEFAULT = Long.toString(60L);
    @I18NMessages(value={@I18NMessage(value="Drift Detection Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.driftdetection-period.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds that defines how often drift detection scans are run.\\n\\\nIf 0 or less, drift discovery scans are disabled.")})
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONPERIOD_HELP = "PromptCommand.setup.instruction.plugins.driftdiscovery-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONINITIALDELAY_PREF = "rhq.agent.plugins.drift-detection.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONINITIALDELAY_DEFAULT = Long.toString(30L);
    @I18NMessages(value={@I18NMessage(value="Drift Detection Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.driftdetection-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial drift detection scan is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSDRIFTDETECTIONINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.driftdetection-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYTHREADCOUNT_PREF = "rhq.agent.plugins.content-discovery.threadpool-size";
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYTHREADCOUNT_DEFAULT = Integer.toString(10);
    @I18NMessages(value={@I18NMessage(value="Content Discovery Thread Pool Size")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYTHREADCOUNT_PROMPT = "PromptCommand.setup.instruction.contentdiscoverythreadcount.prompt";
    @I18NMessages(value={@I18NMessage(value="This defines the number of threads within the plugin container's content\\n\\\ndiscovery thread pool. The higher the number, the more content discoveries\\n\\\nthat can be collected concurrently.")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYTHREADCOUNT_HELP = "PromptCommand.setup.instruction.contentdiscoverythreadcount.help";
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYPERIOD_PREF = "rhq.agent.plugins.content-discovery.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYPERIOD_DEFAULT = Long.toString(30L);
    @I18NMessages(value={@I18NMessage(value="Content Discovery Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.contentdiscovery-period.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds that defines how often content discoveries are run.\\n\\\nIf 0 or less, content discovery is disabled.")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYPERIOD_HELP = "PromptCommand.setup.instruction.plugins.contentdiscovery-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYINITIALDELAY_PREF = "rhq.agent.plugins.content-discovery.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYINITIALDELAY_DEFAULT = Long.toString(60L);
    @I18NMessages(value={@I18NMessage(value="Content Discovery Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.contentdiscovery-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial content discovery is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONTENTDISCOVERYINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.contentdiscovery-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYPERIOD_PREF = "rhq.agent.plugins.configuration-discovery.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYPERIOD_DEFAULT = Long.toString(3600L);
    @I18NMessages(value={@I18NMessage(value="Configuration Discovery Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.configurationdiscovery-period.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds that defines how often configuration discoveries are run.\\n\\\nIf 0 or less, configuration discovery is disabled.")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYPERIOD_HELP = "PromptCommand.setup.instruction.plugins.configurationdiscovery-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYINITIALDELAY_PREF = "rhq.agent.plugins.configuration-discovery.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYINITIALDELAY_DEFAULT = Long.toString(300L);
    @I18NMessages(value={@I18NMessage(value="Configuration Discovery Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.configurationdiscovery-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in seconds before the initial configuration discovery is performed.")})
    public static final String SETUP_INSTRUCTION_PLUGINSCONFIGURATIONDISCOVERYINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.configurationdiscovery-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERPERIOD_PREF = "rhq.agent.plugins.event-sender.period-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERPERIOD_DEFAULT = Long.toString(30L);
    @I18NMessages(value={@I18NMessage(value="Event Sender Period")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERPERIOD_PROMPT = "PromptCommand.setup.instruction.plugins.eventsender-period.prompt";
    @I18NMessages(value={@I18NMessage(value="Defines how often event reports get sent to the server (in seconds).")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERPERIOD_HELP = "PromptCommand.setup.instruction.plugins.eventsender-period.help";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERINITIALDELAY_PREF = "rhq.agent.plugins.event-sender.initial-delay-secs";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERINITIALDELAY_DEFAULT = Long.toString(30L);
    @I18NMessages(value={@I18NMessage(value="Event Sender Initial Delay")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERINITIALDELAY_PROMPT = "PromptCommand.setup.instruction.plugins.eventsender-initialdelay.prompt";
    @I18NMessages(value={@I18NMessage(value="The delay, in seconds, before the first event report gets sent to the server.")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTSENDERINITIALDELAY_HELP = "PromptCommand.setup.instruction.plugins.eventsender-initialdelay.help";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXPERSRC_PREF = "rhq.agent.plugins.event-report.max-per-source";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXPERSRC_DEFAULT = Integer.toString(200);
    @I18NMessages(value={@I18NMessage(value="Event Report Max Per Source")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXPERSRC_PROMPT = "PromptCommand.setup.instruction.plugins.eventreport-maxpersrc.prompt";
    @I18NMessages(value={@I18NMessage(value="The maximum number of events for any given event source that can be placed\\n\\\nin a single event report that is sent up to the server. If this number is\\n\\\nlarger than the max-total setting, then this setting is ignored.")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXPERSRC_HELP = "PromptCommand.setup.instruction.plugins.eventreport-maxpersrc.help";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXTOTAL_PREF = "rhq.agent.plugins.event-report.max-total";
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXTOTAL_DEFAULT = Integer.toString(400);
    @I18NMessages(value={@I18NMessage(value="Event Report Max Total")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXTOTAL_PROMPT = "PromptCommand.setup.instruction.plugins.eventreport-maxtotal.prompt";
    @I18NMessages(value={@I18NMessage(value="The total maximum number of events that can be placed in a single event\\n\\\nreport that is sent up to the server.")})
    public static final String SETUP_INSTRUCTION_PLUGINSEVENTREPORTMAXTOTAL_HELP = "PromptCommand.setup.instruction.plugins.eventreport-maxtotal.help";
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKINTERVAL_PREF = "rhq.agent.vm-health-check.interval-msecs";
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKINTERVAL_DEFAULT = Long.toString(5000L);
    @I18NMessages(value={@I18NMessage(value="VM Health Check Interval")})
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKINTERVAL_PROMPT = "PromptCommand.setup.instruction.vm-health-check.interval.prompt";
    @I18NMessages(value={@I18NMessage(value="The time in milliseconds in between checking the VM's health.")})
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKINTERVAL_HELP = "PromptCommand.setup.instruction.vm-health-check.interval.help";
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWHEAPMEMTHRESHOLD_PREF = "rhq.agent.vm-health-check.low-heap-mem-threshold";
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWHEAPMEMTHRESHOLD_DEFAULT = Float.toString(0.9f);
    @I18NMessages(value={@I18NMessage(value="VM Health Check Low Heap Mem Threshold")})
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWHEAPMEMTHRESHOLD_PROMPT = "PromptCommand.setup.instruction.vm-health-check.low-heap-mem-threshold.prompt";
    @I18NMessages(value={@I18NMessage(value="The threshold percentage that must be crossed if the agent's VM health check\\n\\\nis to consider the JVM with critically low memory. This value is a percentage\\n\\\nof used heap memory out of the maximum heap size.")})
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWHEAPMEMTHRESHOLD_HELP = "PromptCommand.setup.instruction.vm-health-check.low-heap-mem-threshold.help";
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWNONHEAPMEMTHRESHOLD_PREF = "rhq.agent.vm-health-check.low-nonheap-mem-threshold";
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWNONHEAPMEMTHRESHOLD_DEFAULT = Float.toString(0.9f);
    @I18NMessages(value={@I18NMessage(value="VM Health Check Low Non-Heap Mem Threshold")})
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWNONHEAPMEMTHRESHOLD_PROMPT = "PromptCommand.setup.instruction.vm-health-check.low-nonheap-mem-threshold.prompt";
    @I18NMessages(value={@I18NMessage(value="The threshold percentage that must be crossed if the agent's VM health check\\n\\\nis to consider the JVM with critically low memory. This value is a percentage\\n\\\nof used nonheap memory out of the maximum nonheap size.")})
    public static final String SETUP_INSTRUCTION_VMHEALTHCHECKLOWNONHEAPMEMTHRESHOLD_HELP = "PromptCommand.setup.instruction.vm-health-check.low-nonheap-mem-threshold.help";
}

