/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import mazz.i18n.Msg;
import org.apache.log4j.LogManager;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.util.CommandTraceUtil;

public class DebugPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.debug", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        this.processArguments(agent, args);
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.debug.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.debug.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.debug.detailed-help", new Object[0]);
    }

    private void processArguments(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        if (args.length <= 1) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        String sopts = "tdec:f:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("comm", 1, null, 99), new LongOpt("threaddump", 0, null, 116), new LongOpt("enable", 0, null, 101), new LongOpt("disable", 0, null, 100), new LongOpt("file", 1, null, 102)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        block16: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 99: {
                    String flag = getopt.getOptarg();
                    boolean flagBoolean = Boolean.parseBoolean(flag);
                    agent.agentServerCommunicationsTrace(flagBoolean);
                    if (flagBoolean) {
                        out.println(MSG.getMsg("PromptCommand.debug.cmd-tracing-enabled", new Object[]{CommandTraceUtil.getSettingTraceCommandConfig(), CommandTraceUtil.getSettingTraceCommandResponseResults(), CommandTraceUtil.getSettingTraceCommandSizeThreshold(), CommandTraceUtil.getSettingTraceCommandResponseSizeThreshold()}));
                        break;
                    }
                    out.println(MSG.getMsg("PromptCommand.debug.cmd-tracing-disabled", new Object[0]));
                    break;
                }
                case 100: {
                    String file = "log4j.xml";
                    try {
                        agent.hotDeployLogConfigurationFile(file);
                        out.println(MSG.getMsg("PromptCommand.debug.log-file-loaded", new Object[]{file, LogManager.getRootLogger().getLevel()}));
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.debug.cannot-load-log-file", new Object[]{file, ThrowableUtil.getAllMessages((Throwable)e)}));
                    }
                    break;
                }
                case 101: {
                    String file = "log4j-debug.xml";
                    try {
                        agent.hotDeployLogConfigurationFile(file);
                        out.println(MSG.getMsg("PromptCommand.debug.log-file-loaded", new Object[]{file, LogManager.getRootLogger().getLevel()}));
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.debug.cannot-load-log-file", new Object[]{file, ThrowableUtil.getAllMessages((Throwable)e)}));
                    }
                    break;
                }
                case 102: {
                    String file = getopt.getOptarg();
                    try {
                        agent.hotDeployLogConfigurationFile(file);
                        out.println(MSG.getMsg("PromptCommand.debug.log-file-loaded", new Object[]{file, LogManager.getRootLogger().getLevel()}));
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.debug.cannot-load-log-file", new Object[]{file, ThrowableUtil.getAllMessages((Throwable)e)}));
                    }
                    break;
                }
                case 116: {
                    try {
                        ThreadInfo[] allInfo;
                        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                        long[] allIds = threadMXBean.getAllThreadIds();
                        for (ThreadInfo threadInfo : allInfo = threadMXBean.getThreadInfo(allIds, 256)) {
                            if (threadInfo == null) continue;
                            out.println(threadInfo);
                        }
                        continue block16;
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.debug.cannot-dump-threads", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
                    }
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
    }
}

