/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import mazz.i18n.Msg;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class ExecutePromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.execute", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length <= 1) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        this.processCommand(realArgs, out);
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.execute.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.execute.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.execute.detailed-help", new Object[0]);
    }

    private void processCommand(String[] args, PrintWriter out) {
        int i;
        int code;
        boolean capture = false;
        long waitTime = 30000L;
        LinkedHashMap<String, String> environmentVars = null;
        String executable = null;
        String workingDir = null;
        boolean killOnTimeout = false;
        String sopts = "-cd:E:kw:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("capture", 0, null, 99), new LongOpt("killOnTimeout", 0, null, 107), new LongOpt("wait", 1, null, 119), new LongOpt("directory", 1, null, 100)};
        Getopt getopt = new Getopt("execute", args, sopts, lopts);
        while (executable == null && (code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    return;
                }
                case 1: {
                    executable = getopt.getOptarg();
                    break;
                }
                case 99: {
                    capture = true;
                    break;
                }
                case 100: {
                    workingDir = getopt.getOptarg();
                    break;
                }
                case 107: {
                    killOnTimeout = true;
                    break;
                }
                case 119: {
                    String waitArg = getopt.getOptarg();
                    try {
                        waitTime = Long.parseLong(waitArg);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        out.println(MSG.getMsg("PromptCommand.execute.bad-wait-arg", new Object[]{waitArg}));
                        return;
                    }
                }
                case 69: {
                    String value;
                    String name;
                    String envvar;
                    if (environmentVars == null) {
                        environmentVars = new LinkedHashMap<String, String>();
                    }
                    if ((i = (envvar = getopt.getOptarg()).indexOf("=")) == -1) {
                        name = envvar;
                        value = "true";
                    } else {
                        name = envvar.substring(0, i);
                        value = envvar.substring(i + 1, envvar.length());
                    }
                    environmentVars.put(name, value);
                    break;
                }
            }
        }
        if (executable == null) {
            out.println(MSG.getMsg("PromptCommand.execute.missing-executable", new Object[0]));
            return;
        }
        ArrayList<String> procArgList = new ArrayList<String>();
        for (i = getopt.getOptind(); i < args.length; ++i) {
            procArgList.add(args[i]);
        }
        String[] procArgArray = procArgList.toArray(new String[procArgList.size()]);
        out.println(MSG.getMsg("PromptCommand.execute.executing", new Object[]{executable, procArgList}));
        if (environmentVars != null) {
            out.println(MSG.getMsg("PromptCommand.execute.env", new Object[]{environmentVars}));
        }
        if (workingDir != null) {
            out.println(MSG.getMsg("PromptCommand.execute.dir", new Object[]{workingDir}));
        }
        out.println(MSG.getMsg("PromptCommand.execute.will-wait", new Object[]{waitTime}));
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        ProcessExecution processExecution = new ProcessExecution(executable);
        processExecution.setArguments(procArgArray);
        processExecution.setEnvironmentVariables(environmentVars);
        processExecution.setWorkingDirectory(workingDir);
        processExecution.setWaitForCompletion(waitTime);
        processExecution.setCaptureOutput(capture);
        processExecution.setKillOnTimeout(killOnTimeout);
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        Integer exitCode = results.getExitCode();
        Throwable error = results.getError();
        String output = results.getCapturedOutput();
        if (exitCode != null) {
            out.println(MSG.getMsg("PromptCommand.execute.exit-code", new Object[]{exitCode}));
        }
        if (error != null) {
            out.println(MSG.getMsg("PromptCommand.execute.error", new Object[]{ThrowableUtil.getAllMessages((Throwable)error)}));
        }
        if (output != null) {
            out.println(MSG.getMsg("PromptCommand.execute.output", new Object[]{output}));
        }
    }
}

