/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.naming.JNDIBinding;
import org.jboss.naming.JNDIBindings;
import org.jboss.naming.Util;

public class JNDIBindingService {
    private JNDIBindings bindings;
    private String rootName;

    public JNDIBindings getBindings() {
        return this.bindings;
    }

    public void setBindings(JNDIBindings bindings) {
        this.bindings = bindings;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void addBindings() throws NamingException {
        Context ctx = new InitialContext();
        if (this.rootName != null) {
            ctx = (Context)ctx.lookup(this.rootName);
        }
        JNDIBinding[] values = this.bindings.getBindings();
        for (int n = 0; n < values.length; ++n) {
            Object value;
            String name = values[n].getName();
            try {
                value = values[n].getValue();
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to obtain value from binding: " + name);
                ne.setRootCause(e);
                throw ne;
            }
            Util.bind((Context)ctx, (String)name, (Object)value);
        }
        ctx.close();
    }

    public void removeBindings() throws NamingException {
        Context ctx = new InitialContext();
        if (this.rootName != null) {
            ctx = (Context)ctx.lookup(this.rootName);
        }
        JNDIBinding[] values = this.bindings.getBindings();
        for (int n = 0; n < values.length; ++n) {
            String name = values[n].getName();
            Util.unbind((Context)ctx, (String)name);
        }
        ctx.close();
    }

    public void start() throws Exception {
        this.addBindings();
    }

    public void stop() throws Exception {
        this.removeBindings();
    }
}

