/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.perftest.resource;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.perftest.resource.ResourceFactory;
import org.rhq.plugins.perftest.scenario.SimpleResourceGenerator;

public class SimpleResourceFactory
implements ResourceFactory {
    private SimpleResourceGenerator generator;
    private final Log log = LogFactory.getLog(this.getClass());

    public SimpleResourceFactory(SimpleResourceGenerator generator) {
        this.generator = generator;
    }

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        int numResources = this.getNumberOfResources();
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(numResources);
        for (int ii = 0; ii < numResources; ++ii) {
            String resourceKey;
            ResourceType resourceType = context.getResourceType();
            String resourceName = resourceKey = context.getResourceType().getName() + "-" + ii;
            String resourceVersion = "1.0";
            String resourceDescription = resourceKey + " description";
            Configuration pluginConfiguration = new Configuration();
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, resourceVersion, resourceDescription, pluginConfiguration, null);
            discoveredResources.add(details);
        }
        return discoveredResources;
    }

    private int getNumberOfResources() {
        String propertyName = this.generator.getProperty();
        if (propertyName != null) {
            String propertyString = System.getProperty(propertyName);
            if (propertyString != null) {
                return Integer.parseInt(propertyString);
            }
            this.log.warn((Object)("Property was specified but no value was set. Property: " + propertyName));
        }
        return this.generator.getNumberOfResources();
    }
}

