/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;

public class ApachePluginLifecycleListener
implements PluginLifecycleListener {
    private static final Log log = LogFactory.getLog(ApachePluginLifecycleListener.class);
    private static final String LENS_NAME = "httpd.aug";
    protected String dataPath;

    public void initialize(PluginContext context) throws Exception {
        try {
            File tempDirectory = context.getDataDirectory();
            if (!tempDirectory.exists() && !tempDirectory.mkdir()) {
                log.error((Object)"Failed to create a temporary folder for augeas lens.");
            }
            this.dataPath = tempDirectory.getAbsolutePath();
            this.copyTheLens(this.dataPath);
        }
        catch (Exception e) {
            log.error((Object)"Copy of augeas lens to temporary folder failed.", (Throwable)e);
        }
    }

    public void shutdown() {
        File[] files;
        File tempDirectory = new File(this.dataPath);
        for (File file : files = tempDirectory.listFiles()) {
            if (!file.getName().matches(".*.aug") || file.delete()) continue;
            log.error((Object)("Failed to delete augeas lens: " + file.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(InputStream in, File destination) throws Exception {
        if (!destination.canWrite()) {
            throw new Exception("Creating of temporary file for lens failed. Destination file " + destination.getAbsolutePath() + " is not accessible.");
        }
        FileOutputStream out = new FileOutputStream(destination);
        try {
            int length;
            byte[] buf = new byte[1024];
            while ((length = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, length);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTheLens(String tempDirectory) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(LENS_NAME);
        String tempFile = url.getFile();
        File file = new File(tempFile);
        String modName = Character.toLowerCase(file.getName().charAt(0)) + file.getName().substring(1);
        File destinationFile = new File(tempDirectory, modName);
        if (!destinationFile.exists() && destinationFile.createNewFile()) {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream(LENS_NAME);
            try {
                this.copyFile(input, destinationFile);
            }
            finally {
                input.close();
            }
        }
    }
}

