/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.proxy.compiler.IIOPStubCompiler;
import org.jboss.util.NestedRuntimeException;
import org.jboss.web.WebClassLoader;

public class WebCL
extends WebClassLoader {
    static Logger logger = Logger.getLogger(WebCL.class);
    private Map loadedStubMap = Collections.synchronizedMap(new WeakHashMap());

    public WebCL(ObjectName container, RepositoryClassLoader parent) {
        super(container, parent);
        logger.debug((Object)("Constructed WebCL " + ((Object)((Object)this)).toString()));
        logger.debug((Object)("           parent " + parent.toString()));
        this.standard = true;
    }

    public String getKey() {
        String className = ((Object)((Object)this)).getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        String jndiName = this.getContainer().getKeyProperty("jndiName");
        String key = className + '[' + jndiName + ']';
        return key;
    }

    public byte[] getBytes(Class clz) {
        byte[] code = (byte[])this.loadedStubMap.get(clz);
        return code == null ? null : (byte[])code.clone();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("findClass(" + name + ") called"));
        }
        if (name.endsWith("_Stub")) {
            int start = name.lastIndexOf(46) + 1;
            if (name.charAt(start) == '_') {
                String pkg = name.substring(0, start);
                String interfaceName = pkg + name.substring(start + 1, name.length() - 5);
                if (interfaceName.startsWith("org.omg.stub.com.sun.")) {
                    interfaceName = interfaceName.substring(13);
                }
                Class intf = super.loadClass(interfaceName);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("loaded class " + interfaceName));
                }
                try {
                    byte[] code = IIOPStubCompiler.compile(intf, name);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("compiled stub class for " + interfaceName));
                    }
                    Class clz = this.defineClass(name, code, 0, code.length);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("defined stub class for " + interfaceName));
                    }
                    this.resolveClass(clz);
                    try {
                        clz.newInstance();
                    }
                    catch (Throwable t) {
                        throw new NestedRuntimeException(t);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("resolved stub class for " + interfaceName));
                    }
                    this.loadedStubMap.put(clz, code);
                    return clz;
                }
                catch (RuntimeException e) {
                    logger.error((Object)("failed finding class " + name), (Throwable)e);
                    return super.findClass(name);
                }
            }
            return super.findClass(name);
        }
        return super.findClass(name);
    }
}

