/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;

public class DatasourceOrConnectionFactoryComponent
extends ManagedComponentComponent {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        this.getValues(this.getManagedComponent(), report, metrics);
    }

    @Override
    protected void getValues(ManagedComponent managedComponent, MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        HashSet<MeasurementScheduleRequest> uncollectedMetrics = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : metrics) {
            String metricName = request.getName();
            if (metricName.equals("custom.connectionAvailable")) {
                try {
                    Configuration parameters = new Configuration();
                    OperationResult result = this.invokeOperation(managedComponent, "testConnection", parameters);
                    PropertySimple resultProp = result.getComplexResults().getSimple("result");
                    boolean connectionAvailable = resultProp.getBooleanValue();
                    MeasurementDataTrait trait = new MeasurementDataTrait(request, connectionAvailable ? "yes" : "no");
                    report.addData(trait);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to collect trait [" + metricName + "]."), (Throwable)e);
                }
                continue;
            }
            uncollectedMetrics.add(request);
        }
        super.getValues(managedComponent, report, uncollectedMetrics);
    }
}

