/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.jndi.context;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.rhq.jndi.AllowRhqServerInternalsAccessPermission;
import org.rhq.jndi.context.ContextDecorator;

public class AccessCheckingContextDecorator
implements Context,
ContextDecorator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AllowRhqServerInternalsAccessPermission PERM = new AllowRhqServerInternalsAccessPermission();
    private Context original;
    private List<String> checkedSchemes;

    public AccessCheckingContextDecorator(String ... checkedSchemes) {
        this.checkedSchemes = Arrays.asList(checkedSchemes);
    }

    public AccessCheckingContextDecorator(Context original, String ... checkedSchemes) {
        this.original = original;
        this.checkedSchemes = Arrays.asList(checkedSchemes);
    }

    @Override
    public void init(Context ctx) {
        this.original = ctx;
    }

    protected Context getOriginal() {
        return this.original;
    }

    protected static void check() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERM);
        }
    }

    private void checkScheme(String scheme) {
        if (scheme == null || this.checkedSchemes.contains(scheme)) {
            AccessCheckingContextDecorator.check();
        }
    }

    protected void check(String name) {
        this.checkScheme(AccessCheckingContextDecorator.getURLScheme(name));
    }

    protected void check(Name name) {
        if (name.size() == 0) {
            AccessCheckingContextDecorator.check();
        } else {
            String first = name.get(0);
            this.checkScheme(AccessCheckingContextDecorator.getURLScheme(first));
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        this.check(name);
        return this.original.lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        this.check(name);
        return this.original.lookup(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.check(name);
        this.original.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.check(name);
        this.original.bind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.check(name);
        this.original.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.check(name);
        this.original.rebind(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.check(name);
        this.original.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.check(name);
        this.original.unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.check(oldName);
        this.check(newName);
        this.original.rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.check(oldName);
        this.check(newName);
        this.original.rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        this.check(name);
        return this.original.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        this.check(name);
        return this.original.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        this.check(name);
        return this.original.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        this.check(name);
        return this.original.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.check(name);
        this.original.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.check(name);
        this.original.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.check(name);
        return this.original.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        this.check(name);
        return this.original.createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        this.check(name);
        return this.original.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        this.check(name);
        return this.original.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        this.check(name);
        return this.original.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        this.check(name);
        return this.original.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        this.check(name);
        return this.original.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        this.check(name);
        return this.original.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        AccessCheckingContextDecorator.check();
        return this.original.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        AccessCheckingContextDecorator.check();
        return this.original.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        AccessCheckingContextDecorator.check();
        return this.original.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        AccessCheckingContextDecorator.check();
        this.original.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        AccessCheckingContextDecorator.check();
        return this.original.getNameInNamespace();
    }

    private static String getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }

    public int hashCode() {
        return this.getOriginal() == null ? super.hashCode() : this.getOriginal().hashCode();
    }

    public boolean equals(Object o) {
        return this.getOriginal() == null ? super.equals(o) : this.getOriginal().equals(o);
    }
}

