/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.jndi.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.rhq.jndi.util.DecoratorPicker;

public class DecoratingInvocationHandler<Type, Decorator extends Type>
implements InvocationHandler {
    private final List<DecoratorPicker<Type, Decorator>> pickers;
    private Type object;

    public DecoratingInvocationHandler(List<DecoratorPicker<Type, Decorator>> pickers, Type object) {
        this.pickers = pickers;
        this.object = object;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Type target = this.object;
        Class<?> methodClass = method.getDeclaringClass();
        for (DecoratorPicker<Type, Decorator> picker : this.pickers) {
            target = picker.decorate(target, methodClass);
        }
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }
}

