/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.agent;

import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsInvocationException;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.support.SnapshotReportRequest;
import org.rhq.core.pluginapi.support.SnapshotReportResults;
import org.rhq.core.pluginapi.support.SupportFacet;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;
import org.rhq.enterprise.agent.AgentManagement;
import org.rhq.enterprise.agent.AgentManagementMBean;
import org.rhq.plugins.agent.AgentDiscoveryComponent;
import org.rhq.plugins.agent.AgentSnapshotReport;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.JMXServerComponent;

public class AgentServerComponent<T extends ResourceComponent<?>>
extends JMXServerComponent<T>
implements JMXComponent<T>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet,
SupportFacet {
    private static Log log = LogFactory.getLog(AgentServerComponent.class);
    private static final String TRAIT_INDICATOR = "Trait.";
    private static final String SIGAR_VERSION_METRIC_SUFFIX = "SigarVersion";
    private static final String REASON_FOR_LAST_RESTART_METRIC_SUFFIX = "ReasonForLastRestart";
    private static final String AGENT_HOME_DIRECTORY_METRIC_SUFFIX = "AgentHomeDirectory";
    private String sigarVersion;
    private LogFileEventResourceComponentHelper logFileEventDelegate;

    public void start(ResourceContext resourceContext) throws Exception {
        super.start(resourceContext);
        this.sigarVersion = SystemInfoFactory.getNativeSystemInfoVersion();
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(resourceContext);
        this.logFileEventDelegate.startLogFileEventPollers();
    }

    public void stop() {
        this.logFileEventDelegate.stopLogFileEventPollers();
        super.stop();
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    protected EmsBean getAgentBean() {
        return this.getEmsConnection().getBean(AgentManagement.singletonObjectName.getCanonicalName());
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        for (MeasurementScheduleRequest metric_request : metrics) {
            String metric_name = metric_request.getName();
            if (metric_name.startsWith(TRAIT_INDICATOR)) {
                try {
                    Object reason;
                    if (metric_name.endsWith(SIGAR_VERSION_METRIC_SUFFIX)) {
                        report.addData(new MeasurementDataTrait(metric_request, this.sigarVersion));
                        continue;
                    }
                    if (metric_name.endsWith(REASON_FOR_LAST_RESTART_METRIC_SUFFIX)) {
                        reason = this.getAgentBean().getAttribute(REASON_FOR_LAST_RESTART_METRIC_SUFFIX).refresh();
                        report.addData(new MeasurementDataTrait(metric_request, reason.toString()));
                        continue;
                    }
                    if (metric_name.endsWith(AGENT_HOME_DIRECTORY_METRIC_SUFFIX)) {
                        reason = this.getAgentBean().getAttribute(AGENT_HOME_DIRECTORY_METRIC_SUFFIX).refresh();
                        report.addData(new MeasurementDataTrait(metric_request, reason.toString()));
                        continue;
                    }
                    log.error((Object)("Being asked to collect an unknown trait measurement: " + metric_name));
                }
                catch (Exception skip) {
                    log.debug((Object)skip);
                }
                continue;
            }
            try {
                Number metric_value = (Number)this.getAgentBean().getAttribute(metric_name).refresh();
                report.addData(new MeasurementDataNumeric(metric_request, Double.valueOf(metric_value.doubleValue())));
            }
            catch (Exception e) {
                log.error((Object)("Failed to obtain metric [" + metric_name + "]. Cause: " + e));
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration params) {
        OperationResult result;
        block12: {
            result = null;
            try {
                if (params == null || params.getProperties().size() == 0) {
                    result = (OperationResult)this.getAgentBean().getOperation(name).invoke(new Object[0]);
                    break block12;
                }
                if (name.equals("retrievePluginInfo")) {
                    String pluginToUpdate = params.getSimple("pluginName").getStringValue();
                    result = (OperationResult)this.getAgentBean().getOperation(name).invoke(new Object[]{pluginToUpdate});
                    break block12;
                }
                if (name.equals("executeAvailabilityScan")) {
                    Boolean changesOnly = params.getSimple("changesOnly").getBooleanValue();
                    result = (OperationResult)this.getAgentBean().getOperation(name).invoke(new Object[]{changesOnly});
                    break block12;
                }
                if (name.equals("retrieveCurrentDateTime")) {
                    String timeZone = params.getSimple("timeZone").getStringValue();
                    result = new OperationResult();
                    result.getComplexResults().put((Property)new PropertySimple("dateTime", this.getAgentBean().getOperation(name).invoke(new Object[]{timeZone})));
                    break block12;
                }
                if (name.equals("setDebugMode")) {
                    Boolean enabled = params.getSimple("enabled").getBooleanValue();
                    Boolean traceMessaging = params.getSimple("traceMessaging").getBooleanValue();
                    result = new OperationResult();
                    this.getAgentBean().getOperation(name).invoke(new Object[]{enabled, traceMessaging});
                    break block12;
                }
                if (name.equals("executePromptCommand")) {
                    String command = params.getSimple("command").getStringValue();
                    result = new OperationResult();
                    try {
                        Object output = this.getAgentBean().getOperation(name).invoke(new Object[]{command});
                        result.getComplexResults().put((Property)new PropertySimple("output", output));
                        break block12;
                    }
                    catch (EmsInvocationException eie) {
                        if (eie.getCause() instanceof MBeanException && eie.getCause().getCause() instanceof ExecutionException) {
                            ExecutionException ee = (ExecutionException)eie.getCause().getCause();
                            String output = ee.getMessage();
                            CharArrayWriter caw = new CharArrayWriter();
                            ee.getCause().printStackTrace(new PrintWriter(caw));
                            String error = caw.toString();
                            result.getComplexResults().put((Property)new PropertySimple("output", (Object)output));
                            result.getComplexResults().put((Property)new PropertySimple("error", (Object)error));
                            break block12;
                        }
                        throw eie;
                    }
                }
                if (name.equals("switchToServer")) {
                    String server = params.getSimpleValue("server", null);
                    this.getAgentBean().getOperation(name).invoke(new Object[]{server});
                    break block12;
                }
                throw new IllegalArgumentException("Operation [" + name + "] does not support params");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke operation [" + name + "]", e);
            }
        }
        return result;
    }

    public Configuration loadResourceConfiguration() {
        AgentManagementMBean mbean = AgentDiscoveryComponent.getAgentManagementMBean();
        Properties agent_prefs = mbean.getAgentConfiguration();
        Configuration config = new Configuration();
        for (Map.Entry<Object, Object> pref : agent_prefs.entrySet()) {
            config.put((Property)new PropertySimple(pref.getKey().toString(), pref.getValue()));
        }
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport request) {
        Configuration configuration = request.getConfiguration();
        Collection config_names = configuration.getNames();
        Properties prefsToMerge = new Properties();
        ArrayList<String> prefsToRemove = new ArrayList<String>();
        for (String config_name : config_names) {
            String config_value = configuration.getSimple(config_name).getStringValue();
            if (config_value != null) {
                prefsToMerge.setProperty(config_name, config_value);
                continue;
            }
            prefsToRemove.add(config_name);
        }
        try {
            AgentManagementMBean mbean = AgentDiscoveryComponent.getAgentManagementMBean();
            mbean.mergeIntoAgentConfiguration(prefsToMerge);
            mbean.removeFromAgentConfiguration(prefsToRemove);
            request.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            request.setErrorMessage(new ExceptionPackage(Severity.Severe, (Throwable)e).toString());
        }
    }

    public SnapshotReportResults getSnapshotReport(SnapshotReportRequest request) throws Exception {
        AgentManagementMBean mbean = AgentDiscoveryComponent.getAgentManagementMBean();
        ResourceContext resourceContext = this.getResourceContext();
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        String installDir = mbean.getAgentHomeDirectory();
        Properties config = mbean.getAgentConfiguration();
        String tmpDir = resourceContext.getTemporaryDirectory().getAbsolutePath();
        String name = request.getName();
        String description = request.getDescription();
        AgentSnapshotReport report = new AgentSnapshotReport(name, description, pluginConfig, installDir, config, tmpDir);
        File reportFile = report.generate();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(reportFile));
        SnapshotReportResults results = new SnapshotReportResults((InputStream)inputStream);
        return results;
    }
}

