/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.event.log;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.log.MultiLineLogEntryProcessor;

public class Log4JLogEntryProcessor
extends MultiLineLogEntryProcessor {
    private static final String REGEX;
    private static final Pattern PATTERN;
    private static final String ISO8601_DATE_PATTERN = "yyyy-MM-dd kk:mm:ss,SSS";
    private static final DateFormat ISO8601_DATE_FORMAT;
    private static final String ABSOLUTE_DATE_PATTERN = "kk:mm:ss,SSS";
    private static final DateFormat ABSOLUTE_DATE_FORMAT;
    private static final String DATE_DATE_PATTERN = "dd MMM yyyy kk:mm:ss,SSS";
    private static final DateFormat DATE_DATE_FORMAT;
    private static final Map<Priority, EventSeverity> PRIORITY_TO_SEVERITY_MAP;

    public Log4JLogEntryProcessor(String eventType, File logFile) {
        super(eventType, logFile);
    }

    @Override
    protected Pattern getPattern() {
        return PATTERN;
    }

    @Override
    protected MultiLineLogEntryProcessor.LogEntry processPrimaryLine(Matcher matcher) throws MultiLineLogEntryProcessor.ParseException {
        Priority priority;
        String dateString = matcher.group(1);
        Date timestamp = this.parseDateString(dateString);
        String priorityString = matcher.group(2);
        try {
            priority = Priority.valueOf(priorityString);
        }
        catch (IllegalArgumentException e) {
            throw new MultiLineLogEntryProcessor.ParseException("Unknown priority: " + priorityString);
        }
        EventSeverity severity = PRIORITY_TO_SEVERITY_MAP.get((Object)priority);
        String detail = matcher.group(3);
        return new MultiLineLogEntryProcessor.LogEntry(timestamp, severity, detail);
    }

    @Override
    protected DateFormat getDefaultDateFormat() {
        return ISO8601_DATE_FORMAT;
    }

    @Override
    protected Date parseDateString(String dateString) throws MultiLineLogEntryProcessor.ParseException {
        Date timestamp;
        try {
            timestamp = super.parseDateString(dateString);
        }
        catch (MultiLineLogEntryProcessor.ParseException e) {
            try {
                timestamp = DATE_DATE_FORMAT.parse(dateString);
            }
            catch (ParseException e1) {
                try {
                    timestamp = ABSOLUTE_DATE_FORMAT.parse(dateString);
                }
                catch (ParseException e2) {
                    throw new MultiLineLogEntryProcessor.ParseException("Unable to parse date '" + dateString + "' using either ISO8601, DATE, or ABSOLUTE date formats. Please specify a date format.");
                }
            }
        }
        Log4JLogEntryProcessor.setDateIfNotSet(timestamp);
        return timestamp;
    }

    static {
        ISO8601_DATE_FORMAT = new SimpleDateFormat(ISO8601_DATE_PATTERN);
        ABSOLUTE_DATE_FORMAT = new SimpleDateFormat(ABSOLUTE_DATE_PATTERN);
        DATE_DATE_FORMAT = new SimpleDateFormat(DATE_DATE_PATTERN);
        PRIORITY_TO_SEVERITY_MAP = new LinkedHashMap<Priority, EventSeverity>();
        String regex = System.getProperty("rhq.agent.event.log4j.regex");
        REGEX = null != regex ? regex : "(.*?) [\\[\\(]??\\s*(TRACE|DEBUG|INFO|WARN|ERROR|FATAL)\\s*[\\]\\)]?? (.*)";
        PATTERN = Pattern.compile(REGEX);
        PRIORITY_TO_SEVERITY_MAP.put(Priority.TRACE, EventSeverity.DEBUG);
        PRIORITY_TO_SEVERITY_MAP.put(Priority.DEBUG, EventSeverity.DEBUG);
        PRIORITY_TO_SEVERITY_MAP.put(Priority.INFO, EventSeverity.INFO);
        PRIORITY_TO_SEVERITY_MAP.put(Priority.WARN, EventSeverity.WARN);
        PRIORITY_TO_SEVERITY_MAP.put(Priority.ERROR, EventSeverity.ERROR);
        PRIORITY_TO_SEVERITY_MAP.put(Priority.FATAL, EventSeverity.FATAL);
    }

    private static enum Priority {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

