/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.Recoverable;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.server.JMSServerInterceptor;

public class JMSServerInterceptorSupport
implements JMSServerInterceptor,
Recoverable {
    protected Logger log = Logger.getLogger((String)this.getClass().getName());
    protected JMSServerInterceptor nextInterceptor = null;

    public void setNext(JMSServerInterceptor server) {
        this.nextInterceptor = server;
    }

    public JMSServerInterceptor getNext() {
        return this.nextInterceptor;
    }

    public ThreadGroup getThreadGroup() {
        return this.nextInterceptor.getThreadGroup();
    }

    public String getID() throws JMSException {
        String ID = this.nextInterceptor.getID();
        return ID;
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException {
        return this.nextInterceptor.getTemporaryTopic(dc);
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException {
        return this.nextInterceptor.getTemporaryQueue(dc);
    }

    public void connectionClosing(ConnectionToken dc) throws JMSException {
        this.nextInterceptor.connectionClosing(dc);
    }

    public void checkID(String ID) throws JMSException {
        this.nextInterceptor.checkID(ID);
    }

    public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException {
        this.nextInterceptor.addMessage(dc, message);
    }

    public Queue createQueue(ConnectionToken dc, String dest) throws JMSException {
        return this.nextInterceptor.createQueue(dc, dest);
    }

    public Topic createTopic(ConnectionToken dc, String dest) throws JMSException {
        return this.nextInterceptor.createTopic(dc, dest);
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException {
        this.nextInterceptor.deleteTemporaryDestination(dc, dest);
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        this.nextInterceptor.transact(dc, t);
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException {
        this.nextInterceptor.acknowledge(dc, item);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException {
        return this.nextInterceptor.browse(dc, dest, selector);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws JMSException {
        return this.nextInterceptor.receive(dc, subscriberId, wait);
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException {
        this.nextInterceptor.setEnabled(dc, enabled);
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionId) throws JMSException {
        this.nextInterceptor.unsubscribe(dc, subscriptionId);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException {
        this.nextInterceptor.destroySubscription(dc, id);
    }

    public String checkUser(String userName, String password) throws JMSException {
        return this.nextInterceptor.checkUser(userName, password);
    }

    public String authenticate(String userName, String password) throws JMSException {
        return this.nextInterceptor.authenticate(userName, password);
    }

    public void subscribe(ConnectionToken dc, Subscription s) throws JMSException {
        this.nextInterceptor.subscribe(dc, s);
    }

    public void ping(ConnectionToken dc, long clientTime) throws JMSException {
        this.nextInterceptor.ping(dc, clientTime);
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        return this.nextInterceptor.getDurableTopic(sub);
    }

    public Subscription getSubscription(ConnectionToken dc, int subscriberId) throws JMSException {
        return this.nextInterceptor.getSubscription(dc, subscriberId);
    }

    public Xid[] recover(ConnectionToken dc, int flags) throws Exception {
        JMSServerInterceptor next;
        for (next = this.nextInterceptor; next != null && !(next instanceof Recoverable); next = next.getNext()) {
        }
        if (next == null) {
            throw new IllegalStateException("No interceptor implements " + Recoverable.class.getName());
        }
        Recoverable recoverable = (Recoverable)((Object)next);
        return recoverable.recover(dc, flags);
    }
}

