/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.script.BaseRhqSchemeScriptSourceProvider;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.ServerDetails;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RhqDownloadsScriptSourceProvider
extends BaseRhqSchemeScriptSourceProvider {
    private static final Log LOG = LogFactory.getLog(RhqDownloadsScriptSourceProvider.class);
    private static final String AUTHORITY = "downloads";
    private SystemManagerLocal systemManager;
    private SubjectManagerLocal subjectManager;

    public RhqDownloadsScriptSourceProvider() {
        this(LookupUtil.getSystemManager(), LookupUtil.getSubjectManager());
    }

    public RhqDownloadsScriptSourceProvider(SystemManagerLocal systemManager, SubjectManagerLocal subjectManager) {
        super(AUTHORITY);
        this.systemManager = systemManager;
        this.subjectManager = subjectManager;
    }

    protected Reader doGetScriptSource(URI scriptUri) {
        String path = scriptUri.getPath().substring(1);
        Subject overlord = this.subjectManager.getOverlord();
        ServerDetails serverDetails = this.systemManager.getServerDetails(overlord);
        String serverHomeDir = (String)serverDetails.getDetails().get(ServerDetails.Detail.SERVER_HOME_DIR);
        File downloads = new File(serverHomeDir, "deploy/rhq.ear/rhq-downloads/script-modules");
        File file = new File(downloads, path);
        try {
            return new InputStreamReader(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)("Failed to locate the download file: " + scriptUri), (Throwable)e);
            return null;
        }
    }
}

