/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting.interceptors.invoker;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.remoting.interceptors.marshall.MarshallInterceptor;
import org.jboss.aspects.remoting.interceptors.transport.TransportInterceptor;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;

public class RemotingInterceptorFactory {
    public static final String REMOTING = "REMOTING";
    public static final String INVOKER_LOCATOR = "INVOKER_LOCATOR";
    public static final String SUBSYSTEM = "SUBSYSTEM";
    public static final String MARSHALLER = "MARSHALLER";
    public static final String LOADER = "LOADER";

    public static Invocation injectRemotingInterceptors(Invocation invocation) {
        Client client;
        ArrayList<Object> interceptorList;
        Interceptor[] newInterceptor;
        Invocation newInvocation = null;
        InvokerLocator locator = (InvokerLocator)invocation.getMetaData((Object)REMOTING, (Object)INVOKER_LOCATOR);
        if (locator != null) {
            newInterceptor = null;
            interceptorList = new ArrayList<Object>();
            String dataType = (String)invocation.getMetaData((Object)REMOTING, (Object)"datatype");
            if (dataType == null) {
                dataType = RemotingInterceptorFactory.getDataType(locator);
            }
            if (dataType != null) {
                Marshaller marshaller = MarshalFactory.getMarshaller((String)dataType);
                MarshallInterceptor marshallInterceptor = new MarshallInterceptor(marshaller);
                interceptorList.add(marshallInterceptor);
            }
            ClassLoader loader = (ClassLoader)invocation.getMetaData((Object)REMOTING, (Object)LOADER);
            String subsystem = (String)invocation.getMetaData((Object)REMOTING, (Object)SUBSYSTEM);
            client = null;
            try {
                if (loader != null) {
                    client = new Client(loader, locator, subsystem, null);
                }
                client = new Client(locator, subsystem);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create remoting client.", e);
            }
        } else {
            throw new RuntimeException("Require InvokerLocator to make remote invocations.");
        }
        TransportInterceptor transportInterceptor = new TransportInterceptor(client);
        interceptorList.add(transportInterceptor);
        newInterceptor = interceptorList.toArray(new Interceptor[interceptorList.size()]);
        newInvocation = invocation.getWrapper(newInterceptor);
        return newInvocation;
    }

    private static String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            type = (String)params.get("datatype");
        }
        return type;
    }
}

