/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.startup;

import java.io.File;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.rhq.enterprise.startup.StartupSubsystemDefinition;

public class StartupExtension
implements Extension {
    public static final String NAMESPACE = "urn:org.rhq:startup:1.0";
    public static final String SUBSYSTEM_NAME = "rhq-startup";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"rhq-startup");
    static final String DEPLOYMENT_APP_EAR = "rhq.ear";
    private static final int API_MAJOR_VERSION = 1;
    private static final int API_MINOR_VERSION = 0;
    private static final String RESOURCE_NAME = StartupExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final StartupSubsystemParser parser = new StartupSubsystemParser();
    private static final String RHQ_SERVER_HOME_ENVVAR = "RHQ_SERVER_HOME";
    private static final String RHQ_SERVER_HOME_SYSPROP = "rhq.server.home";

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, StartupExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)parser);
    }

    public void initialize(ExtensionContext context) {
        File modulesDir;
        String serverHome = System.getProperty(RHQ_SERVER_HOME_SYSPROP);
        if (serverHome == null) {
            serverHome = System.getenv(RHQ_SERVER_HOME_ENVVAR);
            if (serverHome == null) {
                try {
                    serverHome = new File(System.getProperty("jboss.home.dir"), "..").getCanonicalPath();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to locate server home", e);
                }
            }
            System.setProperty(RHQ_SERVER_HOME_SYSPROP, serverHome);
        }
        if (!(modulesDir = new File(serverHome, "modules")).isDirectory()) {
            throw new IllegalStateException("Invalid RHQ server home dir: " + serverHome);
        }
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)StartupSubsystemDefinition.INSTANCE);
        registration.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    private static class StartupSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private StartupSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            list.add(StartupSubsystemParser.createAddSubsystemOperation());
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private static ModelNode createAddSubsystemOperation() {
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").add("subsystem", StartupExtension.SUBSYSTEM_NAME);
            return subsystem;
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(StartupExtension.NAMESPACE, false);
            writer.writeEndElement();
        }
    }
}

