/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.storage;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.cassandra.util.KeyspaceService;

public class StorageNodeComponent
extends CassandraNodeComponent
implements OperationFacet {
    private Log log = LogFactory.getLog(StorageNodeComponent.class);
    private static final String SYSTEM_AUTH_KEYSPACE = "system_auth";
    private static final String RHQ_KEYSPACE = "rhq";

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("addNodeMaintenance")) {
            return this.nodeAdded(parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult nodeAdded(Configuration params) {
        boolean runRepair = params.getSimple("runRepair").getBooleanValue();
        boolean updateSeedsList = params.getSimple("updateSeedsList").getBooleanValue();
        EmsConnection emsConnection = this.getEmsConnection();
        KeyspaceService keyspaceService = new KeyspaceService(emsConnection);
        boolean hasErrors = false;
        OperationResult result = new OperationResult();
        Configuration resultConfig = result.getComplexResults();
        PropertyList resultsList = new PropertyList("results");
        OpResult opResult = null;
        if (runRepair) {
            opResult = this.repairKeyspace(keyspaceService, SYSTEM_AUTH_KEYSPACE);
            if (!opResult.succeeded) {
                hasErrors = true;
            }
            resultsList.add((Property)this.toPropertyMap(opResult));
        }
        opResult = this.cleanupKeyspace(keyspaceService, SYSTEM_AUTH_KEYSPACE);
        if (!opResult.succeeded) {
            hasErrors = true;
        }
        resultsList.add((Property)this.toPropertyMap(opResult));
        if (runRepair) {
            opResult = this.repairKeyspace(keyspaceService, RHQ_KEYSPACE);
            if (!opResult.succeeded) {
                hasErrors = true;
            }
            resultsList.add((Property)this.toPropertyMap(opResult));
        }
        opResult = this.cleanupKeyspace(keyspaceService, RHQ_KEYSPACE);
        if (!opResult.succeeded) {
            hasErrors = true;
        }
        resultsList.add((Property)this.toPropertyMap(opResult));
        if (updateSeedsList) {
            List addresses = this.getAddresses(params.getList("seedsList"));
            try {
                opResult = new OpResult();
                opResult.operation = "Update seeds list";
                this.updateSeedsList(addresses);
                opResult.succeeded = true;
            }
            catch (Exception e) {
                this.log.error((Object)("An error occurred while updating the seeds lists for " + this.getResourceContext().getResourceKey()), (Throwable)e);
                opResult.succeeded = false;
                Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
                opResult.details = "An error occurred while updating the seeds list: " + ThrowableUtil.getStackAsString((Throwable)rootCause);
            }
            resultsList.add((Property)this.toPropertyMap(opResult));
        }
        resultConfig.put((Property)resultsList);
        if (hasErrors) {
            result.setErrorMessage("One or more tasks failed to complete successfully.");
        }
        return result;
    }

    private OpResult repairKeyspace(KeyspaceService keyspaceService, String keyspace) {
        OpResult result = new OpResult();
        result.operation = "repair " + keyspace + " keyspace";
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Running repair on " + keyspace + " keyspace"));
            }
            long start = System.currentTimeMillis();
            keyspaceService.repairPrimaryRange(keyspace, new String[0]);
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finsihed repair on " + keyspace + " keyspace in " + (end - start) + " ms"));
            }
            result.succeeded = true;
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while running repair on " + keyspace), (Throwable)e);
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            result.succeeded = false;
            result.details = "An error occurred while running repair: " + ThrowableUtil.getStackAsString((Throwable)rootCause);
        }
        return result;
    }

    private OpResult cleanupKeyspace(KeyspaceService keyspaceService, String keyspace) {
        OpResult result = new OpResult();
        result.operation = "cleanup " + keyspace + " keyspace";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Running cleanup on " + keyspace + " keyspace"));
        }
        long start = System.currentTimeMillis();
        try {
            keyspaceService.cleanup(keyspace);
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished cleanup on " + keyspace + " keyspace in " + (end - start) + " ms"));
            }
            result.succeeded = true;
        }
        catch (Exception e) {
            this.log.error((Object)("An error occurred while running cleanup on " + keyspace + " keyspace"), (Throwable)e);
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            result.succeeded = false;
            result.details = "An error occurred while running cleanup: " + ThrowableUtil.getStackAsString((Throwable)rootCause);
        }
        return result;
    }

    private PropertyMap toPropertyMap(OpResult opResult) {
        PropertyMap map = new PropertyMap("resultsMap");
        map.put((Property)new PropertySimple("task", (Object)opResult.operation));
        map.put((Property)new PropertySimple("succeeded", (Object)opResult.succeeded));
        map.put((Property)new PropertySimple("details", (Object)opResult.details));
        return map;
    }

    private static class OpResult {
        String operation;
        boolean succeeded;
        String details;

        private OpResult() {
        }
    }
}

