/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.util.LinkedHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;

public class ConfigurationClassBuilder {
    public static LinkedHashMap<String, CtClass> translateParameters(ClassPool cp, ConfigurationDefinition def) throws NotFoundException {
        LinkedHashMap<String, CtClass> result = new LinkedHashMap<String, CtClass>();
        if (def == null || def.getPropertyDefinitions() == null) {
            return result;
        }
        for (PropertyDefinition pd : def.getPropertyDefinitions().values()) {
            if (!(pd instanceof PropertyDefinitionSimple)) continue;
            PropertyDefinitionSimple simple = (PropertyDefinitionSimple)pd;
            String name = pd.getName();
            CtClass paramType = ConfigurationClassBuilder.getSimpleTypeClass(cp, simple);
            result.put(name, paramType);
        }
        return result;
    }

    private static CtClass getSimpleTypeClass(ClassPool cp, PropertyDefinitionSimple simple) throws NotFoundException {
        Class paramType = null;
        switch (simple.getType()) {
            case STRING: 
            case LONG_STRING: 
            case PASSWORD: 
            case FILE: 
            case DIRECTORY: {
                paramType = String.class;
                break;
            }
            case BOOLEAN: {
                paramType = Boolean.TYPE;
                break;
            }
            case INTEGER: {
                paramType = Integer.TYPE;
                break;
            }
            case LONG: {
                paramType = Long.TYPE;
                break;
            }
            case FLOAT: {
                paramType = Float.TYPE;
                break;
            }
            case DOUBLE: {
                paramType = Double.TYPE;
            }
        }
        return cp.get(paramType.getName());
    }

    public static CtClass translateConfiguration(ClassPool cp, ConfigurationDefinition def) throws NotFoundException {
        if (def == null) {
            return CtClass.voidType;
        }
        if (def.getPropertyDefinitionSimple("operationResult") != null) {
            return ConfigurationClassBuilder.getSimpleTypeClass(cp, def.getPropertyDefinitionSimple("operationResult"));
        }
        return cp.get(Configuration.class.getName());
    }

    private static String simpleName(String name) {
        return ConfigurationClassBuilder.decapitalize(name.replaceAll("\\W", ""));
    }

    private static String decapitalize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length());
    }

    public static Configuration translateParametersToConfig(ClassPool cp, ConfigurationDefinition parametersConfigurationDefinition, Object[] args) throws NotFoundException {
        LinkedHashMap<String, CtClass> translateParameters = ConfigurationClassBuilder.translateParameters(cp, parametersConfigurationDefinition);
        Configuration config = new Configuration();
        int index = 0;
        for (String key : translateParameters.keySet()) {
            config.put((Property)new PropertySimple(key, args[index++]));
        }
        return config;
    }

    public static Object translateResults(ClassPool cp, ConfigurationDefinition resultsConfigurationDefinition, Configuration result) throws NotFoundException {
        CtClass expectedReturn = ConfigurationClassBuilder.translateConfiguration(cp, resultsConfigurationDefinition);
        if (expectedReturn.equals(cp.get(Configuration.class.getName()))) {
            return result;
        }
        if (result == null) {
            return result;
        }
        PropertySimple simple = result.getSimple("operationResult");
        if (simple != null) {
            if (expectedReturn.getName().equals(String.class.getName())) {
                return simple.getStringValue();
            }
            if (expectedReturn.getName().equals(Boolean.class.getName()) || expectedReturn.getName().equals(Boolean.TYPE.getName())) {
                return simple.getBooleanValue();
            }
            if (expectedReturn.getName().equals(Integer.class.getName()) || expectedReturn.getName().equals(Integer.TYPE.getName())) {
                return simple.getIntegerValue();
            }
            if (expectedReturn.getName().equals(Long.class.getName()) || expectedReturn.getName().equals(Long.TYPE.getName())) {
                return simple.getLongValue();
            }
            if (expectedReturn.getName().equals(Float.class.getName()) || expectedReturn.getName().equals(Float.TYPE.getName())) {
                return simple.getFloatValue();
            }
            if (expectedReturn.getName().equals(Double.class.getName()) || expectedReturn.getName().equals(Double.TYPE.getName())) {
                return simple.getDoubleValue();
            }
            if (expectedReturn.getName().equals(Boolean.class.getName()) || expectedReturn.getName().equals(Boolean.TYPE.getName())) {
                return simple.getBooleanValue();
            }
        }
        return null;
    }
}

