/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.upgrade;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceUpgradeReport;

public class ResourceUpgradeRequest
extends ResourceUpgradeReport {
    private static final long serialVersionUID = 1L;
    private final int resourceId;
    private String upgradeErrorMessage;
    private String upgradeErrorStackTrace;
    private long timestamp;

    public ResourceUpgradeRequest(int resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceUpgradeRequest(int resourceId, ResourceUpgradeReport report) {
        this.resourceId = resourceId;
        this.fillInFromReport(report);
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public String getUpgradeErrorMessage() {
        return this.upgradeErrorMessage;
    }

    public void setUpgradeErrorMessage(String upgradeErrorMessage) {
        this.upgradeErrorMessage = upgradeErrorMessage;
    }

    public String getUpgradeErrorStackTrace() {
        return this.upgradeErrorStackTrace;
    }

    public void setUpgradeErrorStackTrace(String upgradeErrorStackTrace) {
        this.upgradeErrorStackTrace = upgradeErrorStackTrace;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setErrorProperties(Throwable t) {
        this.upgradeErrorMessage = null;
        this.upgradeErrorStackTrace = null;
        for (Throwable p = t; this.upgradeErrorMessage == null && p != null; p = p.getCause()) {
            this.upgradeErrorMessage = p.getMessage();
            if (this.upgradeErrorMessage != null) continue;
            this.upgradeErrorMessage = p.getLocalizedMessage();
        }
        if (this.upgradeErrorMessage == null) {
            if (t.getClass().getCanonicalName() != null) {
                this.upgradeErrorMessage = t.getClass().getCanonicalName();
            } else if (t.getClass().getName() != null) {
                this.upgradeErrorMessage = t.getClass().getName();
            }
        }
        StringWriter string = new StringWriter();
        PrintWriter w = new PrintWriter(string);
        t.printStackTrace(w);
        w.close();
        this.upgradeErrorStackTrace = string.toString();
    }

    public void fillInFromReport(ResourceUpgradeReport report) {
        this.setNewDescription(report.getNewDescription());
        this.setNewName(report.getNewName());
        this.setNewResourceKey(report.getNewResourceKey());
        this.setNewPluginConfiguration(report.getNewPluginConfiguration());
    }

    public void fillInFromResource(Resource resource) {
        this.setNewDescription(resource.getDescription());
        this.setNewName(resource.getName());
        this.setNewResourceKey(resource.getResourceKey());
        this.setNewPluginConfiguration(resource.getPluginConfiguration());
    }

    public void updateResource(Resource resource) {
        if (this.getNewResourceKey() != null) {
            resource.setResourceKey(this.getNewResourceKey());
        }
        if (this.getNewName() != null) {
            resource.setName(this.getNewName());
        }
        if (this.getNewDescription() != null) {
            resource.setDescription(this.getNewDescription());
        }
        if (this.getNewPluginConfiguration() != null) {
            resource.setPluginConfiguration(this.getNewPluginConfiguration());
        }
    }

    public void clearUpgradeData() {
        this.setNewDescription(null);
        this.setNewName(null);
        this.setNewResourceKey(null);
        this.setNewPluginConfiguration(null);
    }

    public boolean hasSomethingToUpgrade() {
        return super.hasSomethingToUpgrade() || this.upgradeErrorMessage != null || this.upgradeErrorStackTrace != null;
    }

    public int hashCode() {
        return 31 * this.resourceId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResourceUpgradeRequest)) {
            return false;
        }
        ResourceUpgradeRequest r = (ResourceUpgradeRequest)((Object)other);
        return r.getResourceId() == this.resourceId;
    }

    public String toString() {
        return "ResourceUpgradeRequest[resourceId = '" + this.resourceId + "', newResourceKey = '" + this.getNewResourceKey() + "', newName = '" + this.getNewName() + "', newDescription = '" + this.getNewDescription() + "', hasNewPluginConfig = '" + (null != this.getNewPluginConfiguration()) + "', upgradeErrorMessage = '" + this.upgradeErrorMessage + "', upgradeErrorStackTrace = '" + this.upgradeErrorStackTrace + "']";
    }
}

