/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.CpuInformation;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

public class CpuDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) {
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>();
        SystemInfo sysInfo = discoveryContext.getSystemInformation();
        if (!sysInfo.isNative()) {
            this.log.debug((Object)("Skipping " + discoveryContext.getResourceType().getName() + " discovery, since native system info is not available."));
            return results;
        }
        int numberOfCpus = sysInfo.getNumberOfCpus();
        for (int i = 0; i < numberOfCpus; ++i) {
            CpuInformation cpuInfo = sysInfo.getCpu(i);
            DiscoveredResourceDetails details = new DiscoveredResourceDetails(discoveryContext.getResourceType(), String.valueOf(i), "CPU " + i, cpuInfo.getCpuInfo().getModel(), cpuInfo.getCpuInfo().getVendor() + ' ' + cpuInfo.getCpuInfo().getModel(), null, null);
            results.add(details);
        }
        return results;
    }
}

