/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.concurrent.locks.ReentrantLock;
import org.rhq.plugins.platform.content.yum.Content;
import org.rhq.plugins.platform.content.yum.Primary;
import org.rhq.plugins.platform.content.yum.Request;

public class Repomd
extends Content {
    private static ReentrantLock lock = new ReentrantLock();

    public Repomd(Request request) {
        super(request);
    }

    @Override
    public InputStream openStream() throws Exception {
        return new FileInputStream(this.file());
    }

    @Override
    public void writeHeader(OutputStream ostr) throws Exception {
        PrintWriter writer = new PrintWriter(ostr);
        writer.printf("HTTP/1.1 200\n", new Object[0]);
        writer.println("Server: Ackbar (Red Hat)");
        writer.println("Content-Type: text/xml; charset=utf-8");
        writer.printf("Content-Length: %d\n\n", this.length());
        writer.flush();
    }

    @Override
    public void writeContent(OutputStream ostr) throws Exception {
        InputStream istr = this.openStream();
        this.transfer(istr, ostr);
        istr.close();
    }

    @Override
    public long length() throws Exception {
        return this.file().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        lock.lock();
        try {
            new File(this.filepath()).delete();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File file() throws Exception {
        lock.lock();
        try {
            File file = new File(this.filepath());
            if (!file.exists()) {
                this.create(file);
            }
            File file2 = file;
            return file2;
        }
        finally {
            lock.unlock();
        }
    }

    String filepath() {
        return new File(this.context().getTemporaryDirectory(), "repomd.xml").getAbsolutePath();
    }

    private void create(File file) throws Exception {
        PrintWriter writer = new PrintWriter(file);
        writer.append("<repomd xmlns=\"http://linux.duke.edu/metadata/repo\">");
        this.writeEntry(writer, "other", 0L, "0");
        this.writeEntry(writer, "filelists", 0L, "0");
        Primary primary = new Primary(this.request);
        long ts = primary.file().lastModified();
        String checksum = this.sha(primary.openStream());
        this.writeEntry(writer, "primary", ts, checksum);
        writer.append("</repomd>");
        writer.flush();
        writer.close();
    }

    private void writeEntry(PrintWriter writer, String type, long ts, String sum) {
        writer.printf("\t<data type=\"%s\">", type);
        writer.printf("\t<location href=\"repodata/%s.xml\"/>", type);
        writer.printf("\t<checksum type=\"sha\">%s</checksum>", sum);
        writer.printf("\t<timestamp>%d</timestamp>", ts);
        writer.append("\t</data>");
    }

    String sha(InputStream istr) throws Exception {
        byte[] bfr = new byte[10240];
        MessageDigest md = MessageDigest.getInstance("SHA");
        DigestInputStream mdistr = new DigestInputStream(istr, md);
        while (mdistr.read(bfr) != -1) {
        }
        mdistr.close();
        byte[] b = md.digest();
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

