/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.util;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;

public class ClusterBuilder {
    private Cluster.Builder builder = Cluster.builder();
    private ProtocolOptions.Compression compression;

    public ClusterBuilder addContactPoints(String ... addresses) {
        this.builder.addContactPoints(addresses);
        return this;
    }

    public PoolingOptions poolingOptions() {
        return this.builder.poolingOptions();
    }

    public ClusterBuilder withCredentials(String username, String password) {
        this.builder.withCredentials(username, password);
        return this;
    }

    public ClusterBuilder withCompression(ProtocolOptions.Compression compression) {
        if (this.isIBMJRE() && compression == ProtocolOptions.Compression.SNAPPY) {
            throw new IllegalArgumentException(compression.name() + " compression cannot be used with an IBM JRE. " + "See https://bugzilla.redhat.com/show_bug.cgi?id=907485 for details.");
        }
        this.compression = compression;
        this.builder.withCompression(compression);
        return this;
    }

    public ClusterBuilder withPort(int port) {
        this.builder.withPort(port);
        return this;
    }

    public Cluster build() {
        if (this.compression == null && !this.isIBMJRE()) {
            this.builder.withCompression(ProtocolOptions.Compression.SNAPPY);
        }
        return this.builder.build();
    }

    private boolean isIBMJRE() {
        return System.getProperty("java.vm.vendor").startsWith("IBM");
    }
}

