/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.content;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.FileContentDelegate;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.file.JarContentFileInfo;

public class JarContentDelegate
extends FileContentDelegate {
    private static final String MIME_TYPE_JAR = "application/java-archive";
    private final String packageTypeName;

    public JarContentDelegate(File directory, String packageTypeName) {
        super(directory, ".jar");
        this.packageTypeName = packageTypeName;
    }

    public String getPackageTypeName() {
        return this.packageTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        File[] files;
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        for (File file : files = this.getDirectory().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(JarContentDelegate.this.getFileEnding()) && pathname.isFile();
            }
        })) {
            String manifestVersion = null;
            ZipFile jf = null;
            try {
                Configuration config = new Configuration();
                jf = new JarFile(file);
                Manifest manifest = ((JarFile)jf).getManifest();
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    manifestVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    config.put((Property)new PropertySimple("version", (Object)manifestVersion));
                    config.put((Property)new PropertySimple("title", (Object)attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)));
                    config.put((Property)new PropertySimple("url", (Object)attributes.getValue(Attributes.Name.IMPLEMENTATION_URL)));
                    config.put((Property)new PropertySimple("vendor", (Object)attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)));
                    config.put((Property)new PropertySimple("classpath", (Object)attributes.getValue(Attributes.Name.CLASS_PATH)));
                    config.put((Property)new PropertySimple("sealed", (Object)attributes.getValue(Attributes.Name.SEALED)));
                }
                String sha256 = null;
                try {
                    sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(file);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ResourcePackageDetails details = new ResourcePackageDetails(new PackageDetailsKey(file.getName(), this.getVersion(sha256), this.getPackageTypeName(), "noarch"));
                packages.add(details);
                details.setFileCreatedDate(Long.valueOf(file.lastModified()));
                details.setFileName(file.getName());
                details.setFileSize(Long.valueOf(file.length()));
                details.setClassification(MIME_TYPE_JAR);
                details.setSHA256(sha256);
                details.setDisplayVersion(this.getDisplayVersion(file));
                details.setExtraProperties(config);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (jf != null) {
                        jf.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return packages;
    }

    private String getVersion(String sha256) {
        return "[sha256=" + sha256 + "]";
    }

    private String getDisplayVersion(File file) {
        JarContentFileInfo contentFileInfo = new JarContentFileInfo(file);
        return contentFileInfo.getVersion(null);
    }
}

