/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SelectiveSkippingEntityResolver
implements EntityResolver {
    private static final Log LOG = LogFactory.getLog(SelectiveSkippingEntityResolver.class);
    private static SelectiveSkippingEntityResolver dtdAndXsdSkippingInstance;
    private Pattern systemIdsToSkipPattern;

    public SelectiveSkippingEntityResolver(String systemIdsToSkipRegex) {
        if (systemIdsToSkipRegex != null) {
            this.systemIdsToSkipPattern = Pattern.compile(systemIdsToSkipRegex);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.systemIdsToSkipPattern != null && systemId != null && this.systemIdsToSkipPattern.matcher(systemId).find()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping resolution of entity [publicID=" + publicId + ", systemID=" + systemId + "]..."));
            }
            StringReader emptyStringReader = new StringReader("");
            return new InputSource(emptyStringReader);
        }
        return null;
    }

    public static SelectiveSkippingEntityResolver getDtdAndXsdSkippingInstance() {
        if (dtdAndXsdSkippingInstance == null) {
            dtdAndXsdSkippingInstance = new SelectiveSkippingEntityResolver("\\.(dtd|xsd)$");
        }
        return dtdAndXsdSkippingInstance;
    }
}

