/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.StringUtil;
import org.rhq.plugins.netservices.HTTPNetServiceComponentConfiguration;

public class HTTPNetServiceComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log LOG = LogFactory.getLog(HTTPNetServiceComponent.class);
    private ResourceContext resourceContext;
    private Configuration pluginConfig;
    private HTTPNetServiceComponentConfiguration componentConfig;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.pluginConfig = resourceContext.getPluginConfiguration();
        this.componentConfig = HTTPNetServiceComponent.createComponentConfiguration(this.pluginConfig);
    }

    static HTTPNetServiceComponentConfiguration createComponentConfiguration(Configuration pluginConfig) {
        URL endPointUrl = null;
        String configUrl = pluginConfig.getSimpleValue("url", "");
        if (StringUtil.isBlank((String)configUrl)) {
            throw new InvalidPluginConfigurationException("Endpoint URL is not defined");
        }
        try {
            endPointUrl = new URL(configUrl);
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginConfigurationException(configUrl + " is not a valid URL");
        }
        String protocol = endPointUrl.getProtocol();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new InvalidPluginConfigurationException(configUrl + "does not point to an http(s) resource");
        }
        HttpMethod httpMethod = null;
        String configMethod = pluginConfig.getSimpleValue("method", "");
        try {
            httpMethod = HttpMethod.valueOf(configMethod);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPluginConfigurationException("Invalid http method: " + configMethod);
        }
        Pattern responseValidationPattern = null;
        String configValidateResponsePattern = pluginConfig.getSimpleValue("validateResponsePattern");
        if (configValidateResponsePattern != null) {
            if (httpMethod.equals((Object)HttpMethod.HEAD)) {
                throw new InvalidPluginConfigurationException("Cannot validate response content with HEAD request");
            }
            try {
                responseValidationPattern = Pattern.compile(configValidateResponsePattern);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidPluginConfigurationException("Invalid pattern: " + configValidateResponsePattern);
            }
        }
        return new HTTPNetServiceComponentConfiguration(endPointUrl, httpMethod, responseValidationPattern);
    }

    public void stop() {
        this.resourceContext = null;
        this.pluginConfig = null;
        this.componentConfig = null;
    }

    public AvailabilityType getAvailability() {
        try {
            return this.getValuesOrAvailability(null, null) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        this.getValuesOrAvailability(report, metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getValuesOrAvailability(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        SimpleHttpConnectionManager httpConnectionManager = new SimpleHttpConnectionManager();
        HttpClient client = new HttpClient((HttpConnectionManager)httpConnectionManager);
        String userName = this.pluginConfig.getSimpleValue("user", "");
        if (StringUtil.isNotBlank((String)userName)) {
            String password = this.pluginConfig.getSimpleValue("password", "");
            String realm = this.pluginConfig.getSimpleValue("realm", AuthScope.ANY_REALM);
            client.getState().setCredentials(new AuthScope(this.componentConfig.getEndPointUrl().getHost(), this.componentConfig.getEndPointUrl().getPort(), realm), (Credentials)new UsernamePasswordCredentials(userName, password));
        }
        GetMethod method = null;
        switch (this.componentConfig.getHttpMethod()) {
            case GET: {
                method = new GetMethod(this.componentConfig.getEndPointUrl().toExternalForm());
                break;
            }
            case HEAD: {
                method = new HeadMethod(this.componentConfig.getEndPointUrl().toExternalForm());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported http method: '" + (Object)((Object)this.componentConfig.getHttpMethod()) + "'");
            }
        }
        Boolean followRedirects = this.pluginConfig.getSimple("followRedirects").getBooleanValue();
        method.setFollowRedirects(followRedirects == null ? false : followRedirects);
        try {
            Date contentDate;
            long start = System.currentTimeMillis();
            int responseCode = client.executeMethod((org.apache.commons.httpclient.HttpMethod)method);
            long connectTime = System.currentTimeMillis() - start;
            boolean success = this.pluginConfig.getSimple("validateResponseCode").getBooleanValue() == false || responseCode >= 200 && responseCode <= 299;
            success = success && (this.componentConfig.getResponseValidationPattern() == null || this.componentConfig.getResponseValidationPattern().matcher(method.getResponseBodyAsString()).find());
            long readTime = System.currentTimeMillis() - start;
            Header dateHeader = method.getResponseHeader("Date");
            Date date = contentDate = dateHeader == null ? new Date(System.currentTimeMillis()) : DateUtil.parseDate((String)dateHeader.getValue());
            if (metrics != null) {
                for (MeasurementScheduleRequest request : metrics) {
                    if (request.getName().equals("connectTime")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(connectTime)));
                        continue;
                    }
                    if (request.getName().equals("readTime")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(readTime)));
                        continue;
                    }
                    if (request.getName().equals("contentLength")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(method.getResponseContentLength())));
                        continue;
                    }
                    if (!request.getName().equals("contentAge")) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(System.currentTimeMillis() - contentDate.getTime())));
                }
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        finally {
            method.releaseConnection();
            httpConnectionManager.closeIdleConnections(0L);
        }
        return false;
    }

    public static enum HttpMethod {
        GET,
        HEAD;

    }

    public static final class ConfigKeys {
        public static final String URL = "url";
        public static final String USER = "user";
        public static final String PASSWORD = "password";
        public static final String REALM = "realm";
        public static final String METHOD = "method";
        public static final String FOLOW_REDIRECTS = "followRedirects";
        public static final String VALIDATE_RESPONSE_CODE = "validateResponseCode";
        public static final String VALIDATE_RESPONSE_PATTERN = "validateResponsePattern";

        private ConfigKeys() {
        }
    }
}

