/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.iis;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.Win32Exception;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.iis.util.Win32ServiceControlDelegate;

public class IISServerComponent<T extends ResourceComponent<?>>
implements ResourceComponent<T>,
MeasurementFacet,
OperationFacet {
    private static final String WINDOWS_SERVICE_NAME = "W3SVC";
    private static final long SERVICE_CONTROL_TIMEOUT = 30000L;
    private Log log = LogFactory.getLog(IISServerComponent.class);
    private ResourceContext resourceContext;
    private Service service;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    private Service getIISService() throws Win32Exception {
        if (this.service == null) {
            this.service = new Service(WINDOWS_SERVICE_NAME);
        }
        return this.service;
    }

    public AvailabilityType getAvailability() {
        try {
            return this.getIISService().getStatus() == 4 ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Win32Exception e) {
            this.log.warn((Object)"Unable to check status of IIS Windows service.");
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        String propertyBase = "\\Web Service(_Total)\\";
        Pdh pdh = new Pdh();
        for (MeasurementScheduleRequest request : metrics) {
            double value = pdh.getRawValue(propertyBase + request.getName());
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(value)));
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        OperationResult result;
        block5: {
            result = null;
            try {
                if (parameters == null || parameters.getProperties().size() == 0) {
                    if (name.equals("start")) {
                        this.getControlDelegate(null).start();
                        break block5;
                    }
                    if (name.equals("stop")) {
                        this.getControlDelegate(null).stop();
                        break block5;
                    }
                    throw new IllegalArgumentException("Operation [" + name + "] is not yet supported by this plugin");
                }
                throw new IllegalArgumentException("Operation [" + name + "] does not support params");
            }
            catch (Exception e) {
                this.resourceContext.getAvailabilityContext().requestAvailabilityCheck();
                throw new RuntimeException("Failed to invoke operation [" + name + "]", e);
            }
        }
        this.resourceContext.getAvailabilityContext().requestAvailabilityCheck();
        return result;
    }

    private Win32ServiceControlDelegate getControlDelegate(Long timeout) throws Win32Exception {
        Service iisService = this.getIISService();
        String serviceName = iisService.getConfig().getName();
        List<String> serviceDependencies = Arrays.asList(iisService.getConfig().getDependencies());
        long serviceTimeout = timeout == null ? 30000L : timeout;
        return new Win32ServiceControlDelegate(serviceName, serviceDependencies, null, serviceTimeout);
    }
}

