/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class HostComponent
extends BaseComponent<HostControllerComponent<?>>
implements MeasurementFacet {
    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("startTime")) {
                String path = this.getPath();
                path = path.replace("server-config", "server");
                Address address = new Address(path);
                address.add("core-service", "platform-mbean");
                address.add("type", "runtime");
                ReadAttribute op = new ReadAttribute(address, "start-time");
                Result res = this.getASConnection().execute(op);
                if (!res.isSuccess()) continue;
                Long startTime = (Long)res.getResult();
                MeasurementDataTrait data = new MeasurementDataTrait(request, new Date(startTime).toString());
                report.addData(data);
                continue;
            }
            leftovers.add(request);
        }
        if (!leftovers.isEmpty()) {
            super.getValues(report, leftovers);
        }
    }
}

