/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class WebRuntimeComponent
extends BaseComponent<BaseComponent<?>> {
    private static final String RESPONSE_TIME_METRIC = "responseTime";
    private ResponseTimeLogParser responseTimeLogParser;

    @Override
    public void start(ResourceContext<BaseComponent<?>> resourceContext) throws InvalidPluginConfigurationException, Exception {
        super.start(resourceContext);
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        ResponseTimeConfiguration responseTimeConfig = new ResponseTimeConfiguration(pluginConfig);
        File logFile = responseTimeConfig.getLogFile();
        if (logFile == null) {
            logFile = this.findLogFile();
        }
        if (logFile != null) {
            if (this.log.isDebugEnabled()) {
                if (logFile.isFile()) {
                    this.log.debug((Object)("[" + resourceContext.getResourceKey() + "] is using the response time log file [" + logFile + "]"));
                } else {
                    this.log.debug((Object)("The response time log file [" + logFile + "] for [" + resourceContext.getResourceKey() + "] does not exist yet."));
                }
            }
            this.responseTimeLogParser = new ResponseTimeLogParser(logFile);
            this.responseTimeLogParser.setExcludes(responseTimeConfig.getExcludes());
            this.responseTimeLogParser.setTransforms(responseTimeConfig.getTransforms());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cannot monitor response time for [" + resourceContext.getResourceKey() + "] - unknown log file location"));
        }
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> origReqs) throws Exception {
        HashSet<MeasurementScheduleRequest> requests = new HashSet<MeasurementScheduleRequest>(origReqs.size());
        requests.addAll(origReqs);
        Iterator iterator = requests.iterator();
        while (iterator.hasNext()) {
            MeasurementScheduleRequest request = (MeasurementScheduleRequest)iterator.next();
            if (!request.getName().equals(RESPONSE_TIME_METRIC)) continue;
            iterator.remove();
            if (this.responseTimeLogParser != null) {
                try {
                    CallTimeData callTimeData = new CallTimeData(request);
                    this.responseTimeLogParser.parseLog(callTimeData);
                    report.addData(callTimeData);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to retrieve call-time metric 'responseTime' for " + this.context.getResourceType() + " Resource with key [" + this.context.getResourceKey() + "]."), (Throwable)e);
                }
                break;
            }
            this.log.error((Object)("The 'responseTime' metric is enabled for " + this.context.getResourceType() + " Resource with key [" + this.context.getResourceKey() + "], but no value is defined for the '" + "responseTimeLogFile" + "' connection property."));
            break;
        }
        super.getValues(report, requests);
    }

    private File findLogFile() {
        File logFile = null;
        ServerPluginConfiguration serverPluginConfig = this.getServerComponent().getServerPluginConfiguration();
        File logDir = serverPluginConfig.getLogDir();
        if (logDir != null && logDir.isDirectory()) {
            try {
                String virtualHost = this.readAttribute("virtual-host");
                if (virtualHost != null) {
                    String contextRoot = this.readAttribute("context-root");
                    if (contextRoot != null) {
                        if (contextRoot.startsWith("/")) {
                            contextRoot = contextRoot.equals("/") ? "ROOT" : contextRoot.substring(1);
                        }
                        contextRoot = contextRoot.replace('/', '_');
                        virtualHost = virtualHost.equals("default-host") ? "" : virtualHost + "_";
                        String logFileName = String.format("rt/%s%s_rt.log", virtualHost, contextRoot);
                        logFile = new File(logDir, logFileName);
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Unknown context root for: " + this.getAddress()));
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unknown virtual host for: " + this.getAddress()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return logFile;
    }
}

