/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.model.RssVersion;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class RssDocument
implements RssVersion,
Cloneable,
Serializable {
    private Vector channels = new Vector();
    private String version;
    private Vector warnings = new Vector();

    public RssDocument() {
    }

    public RssDocument(String version) {
        this.setVersion(version);
    }

    public void addChannel(RssChannel channel) {
        this.channels.addElement(channel);
    }

    public Enumeration channels() {
        return this.channels.elements();
    }

    public void setVersion(String s) {
        if (s.equals("0.9") || s.equals(".90") || s.equals(".9")) {
            s = "0.90";
        }
        if (s.equals(".91")) {
            s = "0.91";
        }
        if (s.equals("1.00")) {
            s = "1.0";
        }
        if (!("0.90".equals(s) || "0.91".equals(s) || "1.0".equals(s))) {
            throw new IllegalArgumentException("Invalid RSS version: '" + s + "' - must be one of 0.90|0.91|1.0");
        }
        this.version = s;
    }

    public String getVersion() {
        return this.version;
    }

    public void addWarning(String s) {
        if (!this.warnings.contains(s)) {
            this.warnings.addElement(s);
        }
    }

    public Enumeration warnings() {
        return this.warnings.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("RSS Document: version " + this.version + " Channels: " + this.channels.size() + "\n");
        Enumeration enumeration = this.channels.elements();
        while (enumeration.hasMoreElements()) {
            sb.append(" " + enumeration.nextElement());
        }
        return sb.toString();
    }

    public int hashCode() {
        int hc = 31;
        Enumeration e1 = this.channels.elements();
        while (e1.hasMoreElements()) {
            Object obj = e1.nextElement();
            if (obj == null) continue;
            hc = 31 * hc + obj.hashCode();
        }
        hc = 31 * hc + (this.version == null ? 0 : this.version.hashCode());
        return hc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RssDocument that = (RssDocument)o;
        if (this.channels != null ? !this.channels.equals(that.channels) : that.channels != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.warnings != null ? !this.warnings.equals(that.warnings) : that.warnings != null);
    }

    public Object clone() {
        return this.clone();
    }
}

