/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.postgres.PostgresDiscoveryComponent;
import org.rhq.plugins.postgres.PostgresUserComponent;
import org.rhq.plugins.postgres.util.PostgresqlConfFile;

public class PostgresServerComponent<T extends ResourceComponent<?>>
implements DatabaseComponent<T>,
ConfigurationFacet,
MeasurementFacet,
OperationFacet,
CreateChildResourceFacet {
    private static Log log = LogFactory.getLog(PostgresServerComponent.class);
    private Connection connection;
    private AggregateProcessInfo aggregateProcessInfo;
    private ResourceContext resourceContext;
    static final String DEFAULT_CONFIG_FILE_NAME = "postgresql.conf";
    private static final String[] CONFIG_FILE_PROPERTIES = new String[]{"port", "max_connections", "shared_buffers", "max_fsm_pages", "log_destination", "redirect_stderr", "stats_start_collector", "stats_block_level", "stats_row_level", "autovacuum"};

    public void start(ResourceContext context) throws SQLException {
        this.resourceContext = context;
        Configuration config = context.getPluginConfiguration();
        JDBCUtil.safeClose((Connection)this.connection);
        this.connection = PostgresDiscoveryComponent.buildConnection(config, true);
        ProcessInfo processInfo = this.resourceContext.getNativeProcess();
        if (processInfo != null) {
            this.aggregateProcessInfo = processInfo.getAggregateProcessTree();
        } else {
            this.findProcessInfo();
        }
    }

    public void stop() {
        this.resourceContext = null;
        JDBCUtil.safeClose((Connection)this.connection);
        this.connection = null;
    }

    protected String getJDBCUrl() {
        return PostgresDiscoveryComponent.buildUrl(this.resourceContext.getPluginConfiguration());
    }

    public AvailabilityType getAvailability() {
        this.getConnection();
        AvailabilityType type = this.connection == null ? AvailabilityType.DOWN : AvailabilityType.UP;
        return type;
    }

    ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = PostgresDiscoveryComponent.buildConnection(this.resourceContext.getPluginConfiguration(), true);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.connection;
    }

    public void removeConnection() {
        JDBCUtil.safeClose((Connection)this.connection);
        this.connection = null;
    }

    protected PostgresqlConfFile getConfigurationFile() throws IOException {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String dataDirPath = pluginConfig.getSimpleValue("pgdataDir", null);
        String configFilePath = pluginConfig.getSimpleValue("configFile", null);
        File configFile = configFilePath != null ? new File(configFilePath) : new File(dataDirPath, DEFAULT_CONFIG_FILE_NAME);
        return new PostgresqlConfFile(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        PostgresqlConfFile confFile = this.getConfigurationFile();
        for (String propName : CONFIG_FILE_PROPERTIES) {
            String value = confFile.getProperty(propName);
            PropertyDefinitionSimple propDef = configDef.getPropertyDefinitionSimple(propName);
            PropertySimple prop = this.createProperty(value, propDef);
            config.put((Property)prop);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery("show all");
            PropertyMap runtimeSettings = new PropertyMap("runtimeSettings");
            PropertyDefinitionMap mapDef = configDef.getPropertyDefinitionMap("runtimeSettings");
            config.put((Property)runtimeSettings);
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                String setting = resultSet.getString("setting");
                PropertyDefinitionSimple pd = mapDef.getPropertyDefinitionSimple(name);
                if (pd != null && pd.getType() == PropertySimpleType.BOOLEAN) {
                    runtimeSettings.put((Property)new PropertySimple(name, (Object)"on".equalsIgnoreCase(setting)));
                    continue;
                }
                if (setting == null) continue;
                runtimeSettings.put((Property)new PropertySimple(name, (Object)setting));
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Statement)statement, resultSet);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            ConfigurationDefinition def = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (PropertySimple prop : report.getConfiguration().getSimpleProperties().values()) {
                PropertyDefinitionSimple pd = def.getPropertyDefinitionSimple(prop.getName());
                if ("configFile".equals(pd.getPropertyGroupDefinition().getName())) {
                    String value = this.getPostgresParameterValue(prop, pd);
                    parameters.put(prop.getName(), value);
                    continue;
                }
                if (pd.isReadOnly()) continue;
            }
            PostgresqlConfFile confFile = this.getConfigurationFile();
            confFile.setProperties(parameters);
        }
        catch (IOException e) {
            log.error((Object)"Unable to update postgres configuration file", (Throwable)e);
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        for (MeasurementScheduleRequest request : metrics) {
            String property = request.getName();
            if (property.startsWith("Process.")) {
                if (this.aggregateProcessInfo == null) continue;
                this.aggregateProcessInfo.refresh();
                Object val = this.lookupAttributeProperty(this.aggregateProcessInfo, property.substring("Process.".length()));
                if (val == null || !(val instanceof Number)) continue;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(((Number)val).doubleValue())));
                continue;
            }
            if (!property.startsWith("Database")) continue;
            try {
                ResultSet rs;
                if (property.endsWith("startTime")) {
                    rs = this.getConnection().createStatement().executeQuery("SELECT pg_postmaster_start_time()");
                    try {
                        if (!rs.next()) continue;
                        report.addData(new MeasurementDataTrait(request, rs.getTimestamp(1).toString()));
                        continue;
                    }
                    finally {
                        rs.close();
                        continue;
                    }
                }
                if (!property.endsWith("backends")) continue;
                rs = this.getConnection().createStatement().executeQuery("select count(*) from pg_stat_activity");
                try {
                    if (!rs.next()) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(rs.getLong(1))));
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.warn((Object)("Can not collect property: " + property + ": " + e.getLocalizedMessage()));
            }
        }
    }

    private Double getProcessProperty(String property) {
        if ((property = property.substring("Process.".length())).startsWith("Memory.")) {
            property = property.substring("Memory.".length());
            return this.getObjectProperty(this.aggregateProcessInfo.getMemory(), property);
        }
        return this.getObjectProperty(this.aggregateProcessInfo, property);
    }

    protected Object lookupAttributeProperty(Object value, String property) {
        String[] ps = property.split("\\.", 2);
        String searchProperty = ps[0];
        try {
            PropertyDescriptor[] pds;
            for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                if (!pd.getName().equals(searchProperty)) continue;
                value = pd.getReadMethod().invoke(value, new Object[0]);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Unable to read property from measurement attribute [" + searchProperty + "] not found on [" + this.resourceContext.getResourceKey() + "]"));
        }
        if (ps.length > 1) {
            value = this.lookupAttributeProperty(value, ps[1]);
        }
        return value;
    }

    public double getObjectProperty(Object object, String name) {
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                return ((Number)pd.getReadMethod().invoke(object, new Object[0])).doubleValue();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while retrieving property '" + name + "' from object [" + object + "]"), (Throwable)e);
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (name.equals("listProcessStatistics")) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.getConnection().createStatement();
                rs = stmt.executeQuery("SELECT * FROM pg_stat_activity ORDER BY current_query desc");
                PropertyList procList = new PropertyList("processList");
                while (rs.next()) {
                    PropertyMap pm = new PropertyMap("process");
                    pm.put((Property)new PropertySimple("pid", (Object)rs.getInt("procpid")));
                    pm.put((Property)new PropertySimple("userName", (Object)rs.getString("usename")));
                    pm.put((Property)new PropertySimple("query", (Object)rs.getString("current_query")));
                    pm.put((Property)new PropertySimple("address", (Object)rs.getString("client_addr")));
                    pm.put((Property)new PropertySimple("port", (Object)rs.getInt("client_port")));
                    procList.add((Property)pm);
                }
                OperationResult result = new OperationResult();
                result.getComplexResults().put((Property)procList);
                OperationResult operationResult = result;
                return operationResult;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        Configuration userConfig = report.getResourceConfiguration();
        String user = userConfig.getSimpleValue("user", null);
        Statement statement = null;
        String sql = PostgresUserComponent.getUserSQL(userConfig, PostgresUserComponent.UpdateType.CREATE);
        try {
            statement = this.getConnection().createStatement();
            statement.executeUpdate(sql);
            report.setResourceKey(user);
            report.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (SQLException e) {
            report.setException((Throwable)e);
        }
        finally {
            JDBCUtil.safeClose((Statement)statement);
        }
        return report;
    }

    private String getPostgresParameterValue(PropertySimple prop, PropertyDefinitionSimple propDef) {
        String value = propDef.getType() == PropertySimpleType.BOOLEAN && prop.getBooleanValue() != null ? (prop.getBooleanValue() != false ? "on" : "off") : prop.getStringValue();
        return value;
    }

    private PropertySimple createProperty(String value, PropertyDefinitionSimple propDef) {
        String jonValue;
        if (propDef.getType() == PropertySimpleType.BOOLEAN && value != null) {
            String lowerCaseValue = value.toLowerCase();
            if ("on".equals(lowerCaseValue) || "true".startsWith(lowerCaseValue) || "yes".startsWith(lowerCaseValue) || "1".equals(lowerCaseValue)) {
                jonValue = Boolean.TRUE.toString();
            } else if ("off".startsWith(lowerCaseValue) && lowerCaseValue.length() != 1 || "false".startsWith(lowerCaseValue) || "no".startsWith(lowerCaseValue) || "0".equals(lowerCaseValue)) {
                jonValue = Boolean.FALSE.toString();
            } else {
                jonValue = propDef.isRequired() ? Boolean.FALSE.toString() : null;
                log.warn((Object)("Boolean PostgreSQL configuration parameter '" + propDef.getName() + "' has an invalid value: '" + value + "' - defaulting value to '" + jonValue + "'"));
            }
        } else {
            jonValue = value;
        }
        return new PropertySimple(propDef.getName(), (Object)jonValue);
    }

    public void findProcessInfo() {
        List processes = this.resourceContext.getSystemInformation().getProcesses("process|basename|match=^(?i)(postgres|postmaster)\\.exe$,process|basename|nomatch|parent=^(?i)(postgres|postmaster)\\.exe$");
        processes.addAll(this.resourceContext.getSystemInformation().getProcesses("process|basename|match=^(postgres|postmaster)$,process|basename|nomatch|parent=^(postgres|postmaster)$"));
        for (ProcessInfo processInfo : processes) {
            String pgDataPath = PostgresDiscoveryComponent.getDataDirPath(processInfo);
            if (pgDataPath == null) continue;
            this.aggregateProcessInfo = processInfo.getAggregateProcessTree();
            break;
        }
    }
}

