/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.util.jdbc.JDBCUtil;

public class PostgresqlConfFile {
    private Log log = LogFactory.getLog(PostgresqlConfFile.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private File configurationFile;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostgresqlConfFile(File configurationFile) throws IOException {
        if (!configurationFile.exists()) {
            throw new IOException("PostgreSQL configuration file [" + configurationFile + "] does not exist or is not readable. Make sure the user the RHQ Agent is running as has read permissions on the file and its parent directory.");
        }
        if (!configurationFile.canRead()) {
            throw new IOException("PostgreSQL configuration file [" + configurationFile + "] is not readable. Make sure the user the RHQ Agent is running as has read permissions on the file.");
        }
        this.configurationFile = configurationFile;
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new FileReader(configurationFile));
            Pattern p = Pattern.compile("^\\s*(\\w+)\\s*\\=\\s*((?:\\w+)|(?:\\'[^\\']*\\')).*$");
            while ((line = r.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                String val = m.group(2);
                if (val.startsWith("'") && val.endsWith("'")) {
                    val = val.substring(1, val.length() - 1);
                }
                this.properties.put(m.group(1), val);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(r);
            throw throwable;
        }
        JDBCUtil.safeClose((Reader)r);
    }

    @Nullable
    public String getProperty(String paramName) {
        return this.properties.get(paramName);
    }

    @NotNull
    public List<String> getPropertyList(String propertyName) {
        String prop = this.getProperty(propertyName);
        if (prop == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(PostgresqlConfFile.stripQuotes(prop).split(","));
    }

    @NotNull
    public static String stripQuotes(@NotNull String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Nullable
    public String getPort() {
        return this.getProperty("port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Map<String, String> parameters) {
        BufferedReader r = null;
        FilterOutputStream bos = null;
        try {
            String line;
            r = new BufferedReader(new FileReader(this.configurationFile));
            StringBuilder newBuffer = new StringBuilder();
            Pattern p = Pattern.compile("^\\s*(\\#?)\\s*(\\w+)\\s*\\=\\s*((?:\\w+)|(?:\\'[^\\']*\\'))(.*)$");
            while ((line = r.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    boolean isCommented = m.group(1).equals("#");
                    String paramName = m.group(2);
                    String oldParamValue = m.group(3);
                    String tail = m.group(4);
                    if (oldParamValue.startsWith("'") && oldParamValue.endsWith("'")) {
                        oldParamValue = oldParamValue.substring(1, oldParamValue.length() - 1);
                    }
                    if (parameters.containsKey(paramName)) {
                        String paramValue = parameters.get(paramName);
                        if (paramValue == null) {
                            if (!isCommented) {
                                newBuffer.append('#');
                            }
                            newBuffer.append(line).append(LINE_SEPARATOR);
                        } else {
                            newBuffer.append(paramName).append(" = ").append(paramValue);
                            if (tail != null) {
                                newBuffer.append(tail);
                            }
                            newBuffer.append(LINE_SEPARATOR);
                        }
                        parameters.remove(paramName);
                        continue;
                    }
                    newBuffer.append(line).append(LINE_SEPARATOR);
                    continue;
                }
                newBuffer.append(line).append(LINE_SEPARATOR);
            }
            for (String paramName : parameters.keySet()) {
                String paramValue = parameters.get(paramName);
                if (paramValue == null) continue;
                newBuffer.append(paramName).append(" = ").append(paramValue).append(LINE_SEPARATOR);
            }
            PostgresqlConfFile.backupFile(this.configurationFile);
            bos = new BufferedOutputStream(new FileOutputStream(this.configurationFile));
            bos.write(newBuffer.toString().getBytes());
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)"Unable to find Postgres configuration file", (Throwable)e);
        }
        catch (IOException e) {
            this.log.warn((Object)"Unable to update Postgres configuration file", (Throwable)e);
        }
        finally {
            try {
                r.close();
                bos.close();
            }
            catch (IOException e) {}
        }
    }

    private static void backupFile(File file) throws IOException {
        String backupName = file.getName();
        File dir = file.getParentFile();
        int i = 0;
        while (new File(dir, backupName + ".bak." + i).exists()) {
            ++i;
        }
        backupName = backupName + ".bak." + i;
        PostgresqlConfFile.copyFile(file, new File(dir, backupName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        try {
            int i;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    public String toString() {
        return this.configurationFile.toString();
    }
}

