/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertdef;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AlertDefinitionServerPluginComponent
implements ServerPluginComponent,
ControlFacet {
    private final Log log = LogFactory.getLog(AlertDefinitionServerPluginComponent.class);
    private static final List<InjectedTemplate> injectedTemplates;
    private static final InjectedTemplate storageNodeHighHeapTemplate;
    private ServerPluginContext context;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        this.log.debug((Object)("The RHQ AlertDefinition plugin has been initialized!!! : " + this));
    }

    public void start() {
        boolean injectAtPluginStartup = Boolean.valueOf(this.context.getPluginConfiguration().getSimpleValue("injectAtPluginStartup", "true"));
        boolean replaceIfExists = Boolean.valueOf(this.context.getPluginConfiguration().getSimpleValue("replaceIfExists", "false"));
        if (injectAtPluginStartup) {
            this.injectAllAlertDefs(replaceIfExists);
        }
        this.log.debug((Object)("The RHQ AlertDefinition plugin has started!!! : " + this));
    }

    public void stop() {
        this.log.debug((Object)("The RHQ AlertDefinition plugin has stopped!!! : " + this));
    }

    public void shutdown() {
        this.log.debug((Object)("The RHQ AlertDefinition plugin has been shut down!!! : " + this));
    }

    public ControlResults invoke(String name, Configuration parameters) {
        ControlResults controlResults = new ControlResults();
        try {
            if (name.equals("listInjectedAlertDefinitions")) {
                PropertyList result = new PropertyList("injectedAlertDefinitions");
                for (InjectedTemplate iad : injectedTemplates) {
                    PropertyMap map = new PropertyMap("injectedAlertDefinition");
                    map.put((Property)new PropertySimple("plugin", (Object)iad.getPluginName()));
                    map.put((Property)new PropertySimple("type", (Object)iad.getResourceTypeName()));
                    map.put((Property)new PropertySimple("name", (Object)iad.getName()));
                    map.put((Property)new PropertySimple("description", (Object)iad.getDescription()));
                    result.add((Property)map);
                }
                controlResults.getComplexResults().put((Property)result);
            } else if (name.equals("injectAllAlertDefinitions")) {
                this.injectAllAlertDefs(Boolean.valueOf(parameters.getSimpleValue("replaceIfExists")));
            } else if (name.equals("injectAlertDefinition")) {
                InjectedTemplate requestedInjection = new InjectedTemplate(parameters.getSimpleValue("plugin"), parameters.getSimpleValue("type"), parameters.getSimpleValue("name"), null);
                boolean injected = false;
                for (InjectedTemplate iad : injectedTemplates) {
                    if (!iad.equals(requestedInjection)) continue;
                    this.injectAlertDef(iad, Boolean.valueOf(parameters.getSimpleValue("replaceIfExists", "false")));
                    injected = true;
                    break;
                }
                if (!injected) {
                    controlResults.setError("Unknown requested alert definition. Check spelling: " + requestedInjection);
                }
            } else {
                controlResults.setError("Unknown control name: " + name);
            }
        }
        catch (Throwable t) {
            controlResults.setError(t);
        }
        return controlResults;
    }

    private List<AlertDefinition> injectAllAlertDefs(boolean replaceIfExists) {
        ArrayList<AlertDefinition> result = new ArrayList<AlertDefinition>();
        for (InjectedTemplate iad : injectedTemplates) {
            AlertDefinition newAlertDef = this.injectAlertDef(iad, replaceIfExists);
            if (null == newAlertDef) continue;
            result.add(newAlertDef);
        }
        return result;
    }

    private AlertDefinition injectAlertDef(InjectedTemplate injectedAlertDef, boolean replaceIfExists) {
        AlertDefinition result = null;
        ResourceTypeManagerLocal typeManager = LookupUtil.getResourceTypeManager();
        AlertDefinitionManagerLocal alertDefManager = LookupUtil.getAlertDefinitionManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        ResourceTypeCriteria rtc = new ResourceTypeCriteria();
        rtc.addFilterPluginName(injectedAlertDef.getPluginName());
        rtc.addFilterName(injectedAlertDef.getResourceTypeName());
        rtc.fetchMetricDefinitions(true);
        PageList resourceTypes = typeManager.findResourceTypesByCriteria(subjectManager.getOverlord(), rtc);
        if (resourceTypes.isEmpty()) {
            return result;
        }
        assert (1 == resourceTypes.size()) : "Found more than 1 resource type!";
        ResourceType resourceType = (ResourceType)resourceTypes.get(0);
        AlertDefinitionCriteria adc = new AlertDefinitionCriteria();
        adc.addFilterName(injectedAlertDef.getName());
        adc.addFilterAlertTemplateResourceTypeId(Integer.valueOf(resourceType.getId()));
        PageList alertDefs = alertDefManager.findAlertDefinitionsByCriteria(subjectManager.getOverlord(), adc);
        if (!alertDefs.isEmpty()) {
            assert (1 == alertDefs.size()) : "Found more than 1 existing alert def!";
            if (!replaceIfExists) {
                return result;
            }
            int[] alertDefIdArray = new int[]{((AlertDefinition)alertDefs.get(0)).getId()};
            alertDefManager.removeAlertDefinitions(subjectManager.getOverlord(), alertDefIdArray);
        }
        int newAlertDefId = 0;
        if (storageNodeHighHeapTemplate.equals(injectedAlertDef)) {
            newAlertDefId = this.injectStorageNodeHighHeapTemplate(resourceType);
        }
        adc.addFilterId(Integer.valueOf(newAlertDefId));
        alertDefs = alertDefManager.findAlertDefinitionsByCriteria(subjectManager.getOverlord(), adc);
        assert (1 == alertDefs.size()) : "Found more than 1 new alert def!";
        result = (AlertDefinition)alertDefs.get(0);
        return result;
    }

    private int injectStorageNodeHighHeapTemplate(ResourceType resourceType) {
        AlertTemplateManagerLocal alertTemplateManager = LookupUtil.getAlertTemplateManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        AlertDefinition newTemplate = new AlertDefinition();
        newTemplate.setName(storageNodeHighHeapTemplate.getName());
        newTemplate.setResourceType(resourceType);
        newTemplate.setPriority(AlertPriority.MEDIUM);
        newTemplate.setConditionExpression(BooleanExpression.ANY);
        newTemplate.setRecoveryId(Integer.valueOf(0));
        newTemplate.setEnabled(true);
        AlertCondition ac = new AlertCondition();
        ac.setCategory(AlertConditionCategory.THRESHOLD);
        ac.setComparator(">");
        ac.setThreshold(Double.valueOf(0.75));
        ArrayList<Integer> measurementDefinitionIds = new ArrayList<Integer>(2);
        for (MeasurementDefinition d : resourceType.getMetricDefinitions()) {
            if ("Calculated.HeapUsagePercentage".equals(d.getName())) {
                measurementDefinitionIds.add(d.getId());
                ac.setMeasurementDefinition(d);
                ac.setName(d.getDisplayName());
                continue;
            }
            if (!"{HeapMemoryUsage.used}".equals(d.getName())) continue;
            measurementDefinitionIds.add(d.getId());
        }
        assert (null != ac.getMeasurementDefinition()) : "Did not find expected measurement definition [Calculated.HeapUsagePercentage] for " + resourceType;
        newTemplate.addCondition(ac);
        AlertDampening dampener = new AlertDampening(AlertDampening.Category.PARTIAL_COUNT);
        dampener.setPeriod(15);
        dampener.setPeriodUnits(AlertDampening.TimeUnits.MINUTES);
        dampener.setValue(10);
        newTemplate.setAlertDampening(dampener);
        int newTemplateId = alertTemplateManager.createAlertTemplate(subjectManager.getOverlord(), newTemplate, Integer.valueOf(resourceType.getId()));
        MeasurementScheduleManagerLocal measurementManager = LookupUtil.getMeasurementScheduleManager();
        measurementManager.updateDefaultCollectionIntervalAndEnablementForMeasurementDefinitions(subjectManager.getOverlord(), ArrayUtils.toPrimitive((Integer[])measurementDefinitionIds.toArray(new Integer[2])), 60000L, true, true);
        return newTemplateId;
    }

    static {
        storageNodeHighHeapTemplate = new InjectedTemplate("RHQStorage", "VM Memory System", "StorageNodeHighHeapTemplate", "An alert template to notify users of excessive heap use by an RHQ Storage Node. When fired please see documentation for the proper corrective action.");
        injectedTemplates = new ArrayList<InjectedTemplate>();
        injectedTemplates.add(storageNodeHighHeapTemplate);
    }

    private static class InjectedTemplate {
        public static final String FIELD_PLUGIN_NAME = "plugin";
        public static final String FIELD_RESOURCE_TYPE_NAME = "type";
        public static final String FIELD_NAME = "name";
        public static final String FIELD_DESCRIPTION = "description";
        private String pluginName;
        private String resourceTypeName;
        private String name;
        private String description;

        public InjectedTemplate(String pluginName, String resourceTypeName, String name, String description) {
            this.pluginName = pluginName;
            this.resourceTypeName = resourceTypeName;
            this.name = name;
            this.description = description;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getResourceTypeName() {
            return this.resourceTypeName;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.pluginName == null ? 0 : this.pluginName.hashCode());
            result = 31 * result + (this.resourceTypeName == null ? 0 : this.resourceTypeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InjectedTemplate other = (InjectedTemplate)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.pluginName == null ? other.pluginName != null : !this.pluginName.equals(other.pluginName)) {
                return false;
            }
            return !(this.resourceTypeName == null ? other.resourceTypeName != null : !this.resourceTypeName.equals(other.resourceTypeName));
        }

        public String toString() {
            return "InjectedAlertDef [pluginName=" + this.pluginName + ", resourceTypeName=" + this.resourceTypeName + ", name=" + this.name + "]";
        }
    }
}

