/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.rhq.cassandra.schema.TopologyManager;
import org.rhq.cassandra.schema.VersionManager;
import org.rhq.core.domain.cloud.StorageNode;

public class SchemaManager {
    private final Log log = LogFactory.getLog(SchemaManager.class);
    private final String username;
    private final String password;
    private final List<StorageNode> nodes = new ArrayList<StorageNode>();

    public SchemaManager(String username, String password, String ... nodes) {
        this(username, password, SchemaManager.parseNodeInformation(nodes));
    }

    public SchemaManager(String username, String password, List<StorageNode> nodes) {
        this.username = username;
        this.password = password;
        this.nodes.addAll(nodes);
    }

    public void install() throws Exception {
        VersionManager version = new VersionManager(this.username, this.password, this.nodes);
        version.install();
    }

    public void drop() throws Exception {
        VersionManager version = new VersionManager(this.username, this.password, this.nodes);
        version.drop();
    }

    public boolean updateTopology() throws Exception {
        TopologyManager topology = new TopologyManager(this.username, this.password, this.nodes);
        return topology.updateTopology();
    }

    private static List<StorageNode> parseNodeInformation(String ... nodes) {
        ArrayList<StorageNode> parsedNodes = new ArrayList<StorageNode>();
        for (String node : nodes) {
            StorageNode storageNode = new StorageNode();
            storageNode.parseNodeInformation(node);
            parsedNodes.add(storageNode);
        }
        return parsedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block11: {
            try {
                Logger root = Logger.getRootLogger();
                if (!root.getAllAppenders().hasMoreElements()) {
                    root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
                }
                Logger migratorLogging = root.getLoggerRepository().getLogger("org.rhq");
                migratorLogging.setLevel(Level.ALL);
                if (args.length < 4) {
                    System.out.println("Usage      : command username password nodes...");
                    System.out.println("\n");
                    System.out.println("Commands   : install | drop | topology");
                    System.out.println("Node format: hostname|thriftPort|nativeTransportPort");
                    return;
                }
                String command = args[0];
                String username = args[1];
                String password = args[2];
                SchemaManager schemaManager = new SchemaManager(username, password, Arrays.copyOfRange(args, 3, args.length));
                if ("install".equalsIgnoreCase(command)) {
                    schemaManager.install();
                    break block11;
                }
                if ("drop".equalsIgnoreCase(command)) {
                    schemaManager.drop();
                    break block11;
                }
                if ("topology".equalsIgnoreCase(command)) {
                    schemaManager.updateTopology();
                    break block11;
                }
                throw new IllegalArgumentException(command + " not available.");
            }
            catch (Exception e) {
                System.err.println(e);
            }
            finally {
                System.exit(0);
            }
        }
    }
}

